/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Global;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.crafting.ICrafting;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotCrafting;
import net.minecraft.core.util.helper.Listener;
import net.minecraft.core.util.helper.MathHelper;

public abstract class Container {
    public List<ItemStack> inventoryItemStacks = new ArrayList<ItemStack>();
    public List<Slot> inventorySlots = new ArrayList<Slot>();
    public int windowId = 0;
    private short lastActionId = 0;
    protected List<ICrafting> crafters = new ArrayList<ICrafting>();
    private final Set<EntityPlayer> field_20918_b = new HashSet<EntityPlayer>();
    public Listener<Slot> slotUpdateListener;

    protected void addSlot(Slot slot) {
        slot.id = this.inventorySlots.size();
        this.inventorySlots.add(slot);
        this.inventoryItemStacks.add(null);
    }

    public void onContainerInit(ICrafting icrafting) {
        if (this.crafters.contains(icrafting)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.crafters.add(icrafting);
        icrafting.updateCraftingInventory(this, this.func_28127_b());
        this.updateInventory();
    }

    public List<ItemStack> func_28127_b() {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (Slot inventorySlot : this.inventorySlots) {
            arraylist.add(inventorySlot.getStack());
        }
        return arraylist;
    }

    public void updateInventory() {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack itemstack = this.inventorySlots.get(i).getStack();
            ItemStack itemstack1 = this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual(itemstack1, itemstack)) continue;
            itemstack1 = itemstack != null ? itemstack.copy() : null;
            this.inventoryItemStacks.set(i, itemstack1);
            for (ICrafting crafter : this.crafters) {
                crafter.updateInventorySlot(this, i, itemstack1);
            }
        }
    }

    public Slot func_20127_a(IInventory iinventory, int i) {
        for (Slot inventorySlot : this.inventorySlots) {
            Slot slot = inventorySlot;
            if (!slot.isHere(iinventory, i)) continue;
            return slot;
        }
        return null;
    }

    public Slot getSlot(int i) {
        try {
            return this.inventorySlots.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack clickInventorySlot(InventoryAction action, int[] args, EntityPlayer player) {
        Item itemInSlot;
        if (action.requireCreative() && player.getGamemode().consumeBlocks()) {
            System.out.println("Player " + player.username + " used a creative inventory action but is not in creative mode!");
            return null;
        }
        InventoryPlayer inventory = player.inventory;
        if (action == InventoryAction.DROP_HELD_SINGLE || action == InventoryAction.DROP_HELD_STACK) {
            if (inventory.getHeldItemStack() != null) {
                if (action == InventoryAction.DROP_HELD_STACK) {
                    player.dropPlayerItem(inventory.getHeldItemStack());
                    inventory.setHeldItemStack(null);
                }
                if (action == InventoryAction.DROP_HELD_SINGLE) {
                    player.dropPlayerItem(inventory.getHeldItemStack().splitStack(1));
                    if (inventory.getHeldItemStack().stackSize == 0) {
                        inventory.setHeldItemStack(null);
                    }
                }
            }
            this.onCraftMatrixChanged(inventory);
            return null;
        }
        if (action == InventoryAction.PICKUP_SIMILAR || action == InventoryAction.DRAG_ITEMS_ALL || action == InventoryAction.DRAG_ITEMS_ONE || action == InventoryAction.CREATIVE_DRAG) {
            ItemStack itemStack = inventory.getHeldItemStack();
            if (itemStack == null) {
                return null;
            }
            ItemStack controlStack = itemStack.copy();
            if (action == InventoryAction.PICKUP_SIMILAR) {
                this.pickupSimilarItems(player);
            } else {
                this.dragItemsAcrossSlots(player, action, args);
            }
            this.onCraftMatrixChanged(player.inventory);
            return controlStack;
        }
        if (args == null || args.length == 0) {
            return null;
        }
        int slotId = args[0];
        Slot slot = this.getSlot(slotId);
        if (slot == null) {
            this.onCraftMatrixChanged(inventory);
            return null;
        }
        ItemStack controlStack = null;
        ItemStack stackInSlot = slot.getStack();
        Item item = itemInSlot = stackInSlot != null ? stackInSlot.getItem() : null;
        if (stackInSlot != null) {
            controlStack = stackInSlot.copy();
        }
        if (action == InventoryAction.INTERACT_SLOT || action == InventoryAction.INTERACT_GRABBED) {
            Item interactItem;
            ItemStack grabbedItem = player.inventory.getHeldItemStack();
            if (action == InventoryAction.INTERACT_SLOT) {
                if (stackInSlot == null) {
                    return null;
                }
                interactItem = itemInSlot;
            } else {
                interactItem = player.inventory.getHeldItemStack().getItem();
            }
            if (!interactItem.hasInventoryInteraction() || !slot.allowItemInteraction()) {
                return controlStack;
            }
            ItemStack result = interactItem.onInventoryInteract(player, slot, stackInSlot, action == InventoryAction.INTERACT_GRABBED);
            if (result != null && result.stackSize <= 0) {
                result = null;
            }
            slot.putStack(result);
            grabbedItem = player.inventory.getHeldItemStack();
            if (grabbedItem != null && grabbedItem.stackSize <= 0) {
                player.inventory.setHeldItemStack(null);
            }
            this.onCraftMatrixChanged(inventory);
            return controlStack;
        }
        if (action == InventoryAction.EQUIP_ARMOR) {
            this.handleArmorEquip(slot, player);
            this.onCraftMatrixChanged(inventory);
            return controlStack;
        }
        if (action == InventoryAction.HOTBAR_ITEM_SWAP) {
            this.handleHotbarSwap(args, player);
            this.onCraftMatrixChanged(inventory);
            return controlStack;
        }
        if (action == InventoryAction.MOVE_STACK || action == InventoryAction.MOVE_SINGLE_ITEM || action == InventoryAction.MOVE_SIMILAR || action == InventoryAction.MOVE_ALL) {
            int target = args.length > 1 ? args[1] : 0;
            this.handleItemMove(action, slot, target, player);
            this.onCraftMatrixChanged(player.inventory);
            return controlStack;
        }
        if (action == InventoryAction.SORT) {
            if (player.world.isClientSide) {
                return null;
            }
            this.handleSort(args, player);
            this.onCraftMatrixChanged(inventory);
            return controlStack;
        }
        slot.onSlotChanged();
        ItemStack stackInHand = inventory.getHeldItemStack();
        if (action == InventoryAction.DROP) {
            if (stackInSlot == null) {
                return null;
            }
            int amount = args.length > 1 ? args[1] : 1;
            amount = Math.min(amount, stackInSlot.stackSize);
            ItemStack dropStack = slot.decrStackSize(amount);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            }
            slot.onPickupFromSlot(dropStack);
            player.dropPlayerItem(dropStack);
            this.onCraftMatrixChanged(inventory);
            return controlStack;
        }
        if (action == InventoryAction.CREATIVE_GRAB || action == InventoryAction.CREATIVE_MOVE || action == InventoryAction.CREATIVE_DELETE) {
            if (action == InventoryAction.CREATIVE_DELETE) {
                int count = args.length > 1 ? args[1] : 1;
                for (int i = 0; i < count; ++i) {
                    Slot slot1 = this.getSlot(slotId + i);
                    if (slot1 == null) continue;
                    slot1.putStack(null);
                }
            } else {
                ItemStack stack;
                int amount = args.length > 1 ? args[1] : 0;
                amount = stackInSlot != null ? MathHelper.clamp(amount, 0, stackInSlot.getMaxStackSize()) : 0;
                if (action == InventoryAction.CREATIVE_GRAB) {
                    if (amount > 0) {
                        stack = slot.getStack().copy();
                        stack.stackSize = amount;
                    } else {
                        stack = null;
                    }
                    inventory.setHeldItemStack(stack);
                }
                if (action == InventoryAction.CREATIVE_MOVE && amount > 0) {
                    stack = slot.getStack().copy();
                    stack.stackSize = amount;
                    player.inventory.insertItem(stack, false);
                }
            }
            this.onCraftMatrixChanged(player.inventory);
            return controlStack;
        }
        if (stackInSlot == null) {
            if (stackInHand != null && slot.canPutStackInSlot(stackInHand)) {
                int i1;
                int n = i1 = action != InventoryAction.CLICK_LEFT ? 1 : stackInHand.stackSize;
                if (i1 > slot.getSlotStackLimit()) {
                    i1 = slot.getSlotStackLimit();
                }
                slot.putStack(stackInHand.splitStack(i1));
                if (stackInHand.stackSize <= 0) {
                    inventory.setHeldItemStack(null);
                }
            }
        } else if (stackInHand == null) {
            int j1 = action != InventoryAction.CLICK_LEFT ? (stackInSlot.stackSize + 1) / 2 : stackInSlot.stackSize;
            ItemStack itemstack5 = slot.decrStackSize(j1);
            inventory.setHeldItemStack(itemstack5);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            }
            slot.onPickupFromSlot(inventory.getHeldItemStack());
        } else if (slot.canPutStackInSlot(stackInHand)) {
            if (!stackInSlot.canStackWith(stackInHand)) {
                if (stackInHand.stackSize <= slot.getSlotStackLimit()) {
                    slot.putStack(stackInHand);
                    inventory.setHeldItemStack(stackInSlot);
                }
            } else {
                int splitSize;
                int n = splitSize = action != InventoryAction.CLICK_LEFT ? 1 : stackInHand.stackSize;
                if (splitSize > slot.getSlotStackLimit() - stackInSlot.stackSize) {
                    splitSize = slot.getSlotStackLimit() - stackInSlot.stackSize;
                }
                if (splitSize > stackInHand.getMaxStackSize() - stackInSlot.stackSize) {
                    splitSize = stackInHand.getMaxStackSize() - stackInSlot.stackSize;
                }
                stackInHand.splitStack(splitSize);
                if (stackInHand.stackSize <= 0) {
                    inventory.setHeldItemStack(null);
                }
                stackInSlot.stackSize += splitSize;
            }
        } else if (stackInSlot.canStackWith(stackInHand) && stackInSlot.stackSize + stackInHand.stackSize <= stackInHand.getMaxStackSize()) {
            slot.putStack(null);
            slot.onPickupFromSlot(stackInSlot);
            if (stackInSlot.canStackWith(stackInHand) && stackInHand.stackSize + stackInSlot.stackSize <= stackInHand.getMaxStackSize()) {
                stackInHand.stackSize += stackInSlot.stackSize;
            } else {
                player.dropPlayerItem(stackInSlot);
            }
        }
        if (inventory.getHeldItemStack() != null && inventory.getHeldItemStack().stackSize <= 0) {
            inventory.setHeldItemStack(null);
        }
        this.onCraftMatrixChanged(player.inventory);
        return controlStack;
    }

    public void handleArmorEquip(Slot slot, EntityPlayer player) {
        ItemStack stackInSlot = slot.getStack();
        if (stackInSlot == null) {
            return;
        }
        Item itemInSlot = stackInSlot.getItem();
        if (!(itemInSlot instanceof ItemArmor)) {
            return;
        }
        ItemArmor itemArmor = (ItemArmor)itemInSlot;
        int armorSlot = 3 - itemArmor.armorPiece;
        ItemStack newArmor = stackInSlot;
        slot.putStack(null);
        slot.onPickupFromSlot(stackInSlot);
        slot.onSlotChanged();
        ItemStack oldArmor = player.inventory.armorInventory[armorSlot];
        player.inventory.armorInventory[armorSlot] = newArmor;
        this.mergeItems(oldArmor, slot.id);
        this.storeOrDropItem(player, oldArmor);
    }

    public void handleSort(int[] args, EntityPlayer player) {
        if (args.length < 1) {
            return;
        }
        Slot slot = this.getSlot(args[0]);
        if (slot == null) {
            return;
        }
        slot.sortSlotInventory();
    }

    public void handleHotbarSwap(int[] args, EntityPlayer player) {
        if (args.length < 2) {
            return;
        }
        int hotbarSlotNumber = args[1];
        if (hotbarSlotNumber < 1 || hotbarSlotNumber > 9) {
            return;
        }
        Slot slot = this.getSlot(args[0]);
        Slot hotbarSlot = this.getSlot(this.getHotbarSlotId(hotbarSlotNumber));
        if (hotbarSlot == null || slot == hotbarSlot) {
            return;
        }
        ItemStack slotStack = slot.getStack();
        ItemStack hotbarStack = hotbarSlot.getStack();
        if (slotStack != null) {
            slot.putStack(null);
            slot.onPickupFromSlot(slotStack);
        }
        if (hotbarStack != null) {
            hotbarSlot.putStack(null);
            hotbarSlot.onPickupFromSlot(hotbarStack);
        }
        this.mergeItems(slotStack, hotbarSlot.id);
        this.storeOrDropItem(player, slotStack);
        this.mergeItems(hotbarStack, slot.id);
        this.storeOrDropItem(player, hotbarStack);
        slot.onSlotChanged();
        hotbarSlot.onSlotChanged();
    }

    public void handleItemMove(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        ItemStack stackInSlot = slot.getStack();
        if (slot instanceof SlotCrafting) {
            this.handleCrafting(action, (SlotCrafting)slot, target, player);
            return;
        }
        if (action == InventoryAction.MOVE_SINGLE_ITEM || action == InventoryAction.MOVE_STACK) {
            if (stackInSlot == null) {
                return;
            }
            List<Integer> targetSlots = this.getTargetSlots(action, slot, target, player);
            if (targetSlots == null || targetSlots.size() == 0) {
                return;
            }
            ItemStack item = null;
            if (action == InventoryAction.MOVE_SINGLE_ITEM) {
                item = stackInSlot.splitStack(1);
            }
            if (action == InventoryAction.MOVE_STACK) {
                item = stackInSlot.splitStack(stackInSlot.stackSize);
            }
            if (item == null) {
                return;
            }
            slot.onPickupFromSlot(item);
            this.mergeItems(item, targetSlots);
            if (item.stackSize > 0) {
                stackInSlot.stackSize += item.stackSize;
                item.stackSize = 0;
            }
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            }
            return;
        }
        if (action == InventoryAction.MOVE_ALL || action == InventoryAction.MOVE_SIMILAR) {
            List<Integer> moveSlots = this.getMoveSlots(action, slot, target, player);
            List<Integer> targetSlots = this.getTargetSlots(action, slot, target, player);
            if (moveSlots == null || targetSlots == null) {
                return;
            }
            ItemStack compareStack = null;
            if (action == InventoryAction.MOVE_SIMILAR && (compareStack = stackInSlot) == null) {
                return;
            }
            for (int i = 0; i < moveSlots.size(); ++i) {
                int freeSpace;
                ItemStack item;
                Slot slot1 = this.getSlotFromList(moveSlots, i);
                if (slot1 == null || !this.compare(compareStack, item = slot1.getStack()) || (freeSpace = this.getFreeSpace(item, targetSlots)) <= 0) continue;
                int amount = Math.min(freeSpace, item.stackSize);
                ItemStack takenItem = item.splitStack(amount);
                slot.onPickupFromSlot(takenItem);
                this.mergeItems(takenItem, targetSlots);
                if (item.stackSize <= 0) {
                    slot1.putStack(null);
                }
                if (takenItem.stackSize <= 0) continue;
                player.dropPlayerItem(takenItem);
            }
        }
    }

    private boolean compare(ItemStack compareStack, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (compareStack == null) {
            return true;
        }
        return compareStack.canStackWith(stack);
    }

    public void handleCrafting(InventoryAction action, SlotCrafting slot, int target, EntityPlayer player) {
        ItemStack itemToCraft = slot.getStack();
        if (itemToCraft == null) {
            return;
        }
        ItemStack originalCraftItem = itemToCraft.copy();
        Integer craftCount = null;
        if (action == InventoryAction.MOVE_SINGLE_ITEM) {
            craftCount = 1;
        }
        if (action == InventoryAction.MOVE_STACK) {
            craftCount = itemToCraft.getMaxStackSize() / itemToCraft.stackSize;
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            craftCount = 65536;
        }
        if (craftCount == null) {
            return;
        }
        List<Integer> resultSlots = this.getTargetSlots(action, slot, target, player);
        if (resultSlots == null) {
            return;
        }
        for (int i = 0; i < craftCount && (itemToCraft = slot.getStack()) != null && itemToCraft.canStackWith(originalCraftItem) && itemToCraft.itemID == originalCraftItem.itemID && itemToCraft.getMetadata() == originalCraftItem.getMetadata(); ++i) {
            int space = this.getFreeSpace(itemToCraft, resultSlots);
            if (space < itemToCraft.stackSize) continue;
            slot.putStack(null);
            slot.onPickupFromSlot(itemToCraft);
            this.onCraftMatrixChanged(player.inventory);
            this.mergeItems(itemToCraft, resultSlots);
            if (itemToCraft.stackSize <= 0) continue;
            this.storeOrDropItem(player, itemToCraft);
        }
    }

    public int getFreeSpace(ItemStack item, List<Integer> slots) {
        int space = 0;
        int max = item.getMaxStackSize();
        for (int i = 0; i < slots.size(); ++i) {
            Slot slot = this.getSlotFromList(slots, i);
            if (slot == null) continue;
            ItemStack stackInSlot = slot.getStack();
            if (stackInSlot == null) {
                return max;
            }
            if (item.canStackWith(stackInSlot)) {
                space += stackInSlot.getMaxStackSize() - stackInSlot.stackSize;
            }
            if (space < max) continue;
            return space;
        }
        return space;
    }

    public abstract List<Integer> getMoveSlots(InventoryAction var1, Slot var2, int var3, EntityPlayer var4);

    public abstract List<Integer> getTargetSlots(InventoryAction var1, Slot var2, int var3, EntityPlayer var4);

    public void pickupSimilarItems(EntityPlayer player) {
        ItemStack item = player.inventory.getHeldItemStack();
        if (item == null) {
            return;
        }
        List<Slot> slots = this.inventorySlots;
        for (int i = 0; i < slots.size(); ++i) {
            int amount;
            ItemStack slotStack;
            Slot slot1 = slots.get(i);
            if (!slot1.enableDragAndPickup() || (slotStack = slot1.getStack()) == null || slotStack.stackSize >= slotStack.getMaxStackSize()) continue;
            if (slotStack.canStackWith(item) && (amount = Math.min(slotStack.stackSize, item.getMaxStackSize() - item.stackSize)) > 0) {
                slotStack.stackSize -= amount;
                item.stackSize += amount;
                if (slotStack.stackSize <= 0) {
                    slot1.putStack(null);
                }
            }
            if (item.stackSize >= item.getMaxStackSize()) break;
        }
    }

    public void dragItemsAcrossSlots(EntityPlayer player, InventoryAction action, int[] slots) {
        int itemsPerSlot;
        ItemStack draggingItemStack = player.inventory.getHeldItemStack();
        if (action == InventoryAction.CREATIVE_DRAG) {
            for (int i = 0; i < slots.length; ++i) {
                Slot slot = this.getSlot(slots[i]);
                if (slot == null || !slot.enableDragAndPickup() || !slot.canPutStackInSlot(draggingItemStack) || slot.getStack() != null) continue;
                ItemStack stack = draggingItemStack.copy();
                stack.stackSize = stack.getMaxStackSize();
                slot.putStack(stack);
                slot.onSlotChanged();
            }
            player.inventory.setHeldItemStack(null);
            return;
        }
        if (action == InventoryAction.DRAG_ITEMS_ONE) {
            itemsPerSlot = 1;
        } else if (action == InventoryAction.DRAG_ITEMS_ALL) {
            itemsPerSlot = draggingItemStack.stackSize / slots.length;
        } else {
            return;
        }
        if (itemsPerSlot <= 0) {
            return;
        }
        for (int i = 0; i < slots.length; ++i) {
            Slot slot = this.getSlot(slots[i]);
            if (slot == null || !slot.enableDragAndPickup() || !slot.canPutStackInSlot(draggingItemStack)) continue;
            ItemStack stackInSlot = slot.getStack();
            int amount = itemsPerSlot;
            amount = Math.min(amount, slot.getSlotStackLimit());
            if (stackInSlot != null) {
                amount = Math.min(amount, stackInSlot.getMaxStackSize() - stackInSlot.stackSize);
            }
            if ((amount = Math.min(amount, draggingItemStack.stackSize)) <= 0) continue;
            if (stackInSlot == null) {
                slot.putStack(draggingItemStack.splitStack(amount));
            } else if (stackInSlot.canStackWith(draggingItemStack)) {
                draggingItemStack.stackSize -= amount;
                stackInSlot.stackSize += amount;
            }
            if (draggingItemStack.stackSize <= 0) break;
        }
        if (draggingItemStack.stackSize <= 0) {
            player.inventory.setHeldItemStack(null);
        }
    }

    public void onCraftGuiClosed(EntityPlayer player) {
        InventoryPlayer inventory = player.inventory;
        if (inventory.getHeldItemStack() != null) {
            ItemStack stack = inventory.getHeldItemStack();
            inventory.setHeldItemStack(null);
            this.storeOrDropItem(player, stack);
        }
    }

    public void storeOrDropItem(EntityPlayer player, ItemStack stack) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        InventoryPlayer inventory = player.inventory;
        inventory.insertItem(stack, false);
        if (stack.stackSize > 0) {
            player.dropPlayerItem(stack);
        }
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.updateInventory();
    }

    public boolean getCanCraft(EntityPlayer entityplayer) {
        return !this.field_20918_b.contains(entityplayer);
    }

    public void setCanCraft(EntityPlayer entityplayer, boolean flag) {
        if (flag) {
            this.field_20918_b.remove(entityplayer);
        } else {
            this.field_20918_b.add(entityplayer);
        }
    }

    public void putStackInSlot(int i, ItemStack itemstack) {
        this.getSlot(i).putStack(itemstack);
    }

    public void putStacksInSlots(ItemStack[] aitemstack) {
        for (int i = 0; i < aitemstack.length; ++i) {
            this.getSlot(i).putStack(aitemstack[i]);
        }
    }

    public void updateClientProgressBar(int id, int value) {
    }

    public short getActionId(InventoryPlayer inventoryplayer) {
        this.lastActionId = (short)(this.lastActionId + 1);
        return this.lastActionId;
    }

    public void func_20113_a(short word0) {
    }

    public void func_20110_b(short word0) {
    }

    public abstract boolean isUsableByPlayer(EntityPlayer var1);

    public final void mergeItems(ItemStack stack, List<Integer> targetSlots) {
        int amount;
        ItemStack stackInSlot;
        Slot slot;
        int i;
        if (stack == null || targetSlots == null) {
            return;
        }
        for (i = 0; i < targetSlots.size(); ++i) {
            slot = this.getSlotFromList(targetSlots, i);
            if (slot == null || (stackInSlot = slot.getStack()) == null || !slot.canPutStackInSlot(stack) || !stack.canStackWith(stackInSlot)) continue;
            amount = Math.min(stack.stackSize, stack.getMaxStackSize(slot.getInventory()) - stackInSlot.stackSize);
            if ((amount = Math.min(amount, slot.getSlotStackLimit() - stackInSlot.stackSize)) <= 0) continue;
            stack.stackSize -= amount;
            stackInSlot.stackSize += amount;
            slot.onSlotChanged();
            if (stack.stackSize != 0) continue;
            return;
        }
        for (i = 0; i < targetSlots.size(); ++i) {
            slot = this.getSlotFromList(targetSlots, i);
            if (slot == null || (stackInSlot = slot.getStack()) != null || !slot.canPutStackInSlot(stack)) continue;
            amount = Math.min(stack.stackSize, stack.getMaxStackSize(slot.getInventory()));
            if ((amount = Math.min(amount, slot.getSlotStackLimit())) <= 0) continue;
            slot.putStack(stack.splitStack(amount));
            slot.onSlotChanged();
            if (stack.stackSize > 0) continue;
            return;
        }
    }

    public Slot getSlotFromList(List<Integer> slots, int i) {
        int slotId = slots.get(i);
        Slot slot = this.getSlot(slotId);
        if (slot == null && Global.BUILD_CHANNEL.isUnstableBuild()) {
            throw new NullPointerException("Slot " + slotId + " does not exist!");
        }
        return slot;
    }

    public final void mergeItems(ItemStack stack, int targetSlot) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(targetSlot);
        this.mergeItems(stack, list);
    }

    public final void mergeItems(ItemStack stack, int minSlot, int maxSlot, boolean lastSlotFirst) {
        this.mergeItems(stack, this.getSlots(minSlot, maxSlot - minSlot + 1, lastSlotFirst));
    }

    public List<Integer> getSlots(int min, int count, boolean lastSlotsFirst) {
        return this.getSlots(new ArrayList<Integer>(), min, count, lastSlotsFirst);
    }

    public List<Integer> getSlots(List<Integer> targetSlots, int min, int count, boolean lastSlotsFirst) {
        for (int i = 0; i < count; ++i) {
            targetSlots.add(lastSlotsFirst ? min + count - 1 - i : min + i);
        }
        return targetSlots;
    }

    public int getHotbarSlotId(int number) {
        return this.inventorySlots.size() - 10 + number;
    }
}

