/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.slot;

import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.slot.Slot;

public class SlotGuidebook
extends Slot {
    public ItemStack item;
    public RecipeSymbol symbol;
    public RecipeEntryBase<?, ?, ?> recipe;
    public int recipeIndex = 0;
    public int recipeAmount = 0;
    public boolean isOutput = false;

    public SlotGuidebook(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe) {
        super(null, id, x, y);
        this.id = id;
        this.symbol = symbol;
        if (symbol != null && symbol.getItemGroup() != null) {
            this.showRandomItem();
        } else if (symbol != null) {
            this.item = symbol.resolve().get(0);
            if (recipe instanceof RecipeEntryTrommel) {
                WeightedRandomBag loot = (WeightedRandomBag)recipe.getOutput();
                this.recipeAmount = loot.getEntries().size() - 1;
            }
        }
        this.discovered = discovered;
        this.recipe = recipe;
    }

    @Deprecated
    public SlotGuidebook(int id, int x, int y, RecipeSymbol symbol, boolean discovered) {
        super(null, id, x, y);
        this.symbol = symbol;
        if (symbol != null && symbol.getItemGroup() != null) {
            this.showRandomItem();
        } else if (symbol != null) {
            this.item = symbol.resolve().get(0);
        }
        this.discovered = discovered;
        this.recipe = null;
    }

    public SlotGuidebook setAsOutput() {
        this.isOutput = true;
        return this;
    }

    @Override
    public ItemStack decrStackSize(int i) {
        return null;
    }

    @Override
    public boolean hasStack() {
        return this.item != null;
    }

    @Override
    public int getSlotStackLimit() {
        return this.item.getMaxStackSize();
    }

    @Override
    public ItemStack getStack() {
        return this.item;
    }

    @Override
    public void onPickupFromSlot(ItemStack itemstack) {
    }

    @Override
    public void onSlotChanged() {
    }

    @Override
    public void putStack(ItemStack itemstack) {
    }

    public void showRandomItem() {
        if (this.symbol != null && this.symbol.getItemGroup() != null) {
            Random r = new Random();
            List<ItemStack> list = this.symbol.resolve();
            ItemStack newItem = list.get(r.nextInt(list.size()));
            if (list.size() > 1) {
                while (newItem == this.item) {
                    newItem = list.get(r.nextInt(list.size()));
                }
            }
            this.item = newItem;
        }
    }

    @Override
    public boolean getIsDiscovered(EntityPlayer player) {
        if (this.item == null || this.discovered) {
            return true;
        }
        if (player instanceof EntityPlayerSP && !((Boolean)((EntityPlayerSP)player).sender.minecraft.gameSettings.hideUndiscoveredItems.value).booleanValue()) {
            return true;
        }
        return player.getStat(StatList.pickUpItemStats[this.item.itemID]) > 0 || player.getGamemode() == Gamemode.creative;
    }

    public void scrollRecipe() {
    }
}

