/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.util.debug.Debug;
import net.minecraft.client.world.chunk.provider.ChunkProviderViewer;
import net.minecraft.core.Global;
import net.minecraft.core.HitResult;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.BlockSound;
import net.minecraft.core.sound.BlockSoundDispatcher;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.LightUpdate;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.saveddata.SavedData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.WeatherManager;
import org.jetbrains.annotations.Nullable;

public class World
implements WorldSource {
    public static boolean AUTOSAVE = true;
    private final int heightBlocks = 256;
    private final int heightBits = -1;
    private final List<LightUpdate> lightingToUpdate = new LinkedList<LightUpdate>();
    public List<Entity> loadedEntityList = new ArrayList<Entity>();
    private final List<Entity> unloadedEntityList = new ArrayList<Entity>();
    private final TreeSet<NextTickListEntry> scheduledTickTreeSet = new TreeSet();
    private final Set<NextTickListEntry> scheduledTickSet = new HashSet<NextTickListEntry>();
    public List<TileEntity> loadedTileEntityList = new ArrayList<TileEntity>();
    private final List<TileEntity> field_30900_E = new ArrayList<TileEntity>();
    public List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    public List<Entity> weatherEffects = new ArrayList<Entity>();
    public final ArrayList<AABB> collidingBoundingBoxes = new ArrayList();
    public List<LevelListener> listeners = new ArrayList<LevelListener>();
    private final Set<ChunkCoordinate> positionsToUpdate = new HashSet<ChunkCoordinate>();
    private final List<Entity> entityBuffer = new ArrayList<Entity>();
    private final Set<NextTickListEntry> immediatelyUpdatedPositions = new HashSet<NextTickListEntry>();
    public boolean scheduledUpdatesAreImmediate = false;
    private final int dimensionColor = 0xFFFFFF;
    public int skyDarken = 0;
    protected int updateLCG = new Random().nextInt();
    public int lightningFlicker = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp = System.currentTimeMillis();
    public int difficultySetting;
    public Random rand = new Random();
    public boolean isNewWorld = false;
    public final Dimension dimension;
    public final WorldType worldType;
    protected IChunkProvider chunkProvider;
    protected final LevelStorage saveHandler;
    protected LevelData levelData;
    public DimensionData dimensionData;
    public boolean findingSpawnPoint;
    protected boolean enoughPlayersSleeping;
    public SavedDataStorage savedDataStorage;
    private boolean field_31055_L;
    private int lightingUpdatesCounter = 0;
    protected boolean spawnHostileMobs = true;
    private boolean spawnPeacefulMobs = true;
    static int lightingUpdatesScheduled = 0;
    private int caveSoundCounter = this.rand.nextInt(12000);
    public boolean isClientSide = false;
    public int sleepPercent = 100;
    private long runtime = 0L;
    public int dayCountLastTick;
    private final BiomeProvider biomeProvider;
    public AuroraProvider auroraProvider;
    public final SeasonManager seasonManager;
    public final WeatherManager weatherManager;

    public World(LevelStorage saveHandler, String name, long seed, Dimension dimension, WorldType worldType) {
        this.saveHandler = saveHandler;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.levelData = saveHandler.getLevelData();
        boolean bl = this.isNewWorld = this.levelData == null;
        this.dimension = dimension != null ? dimension : (this.levelData != null ? Dimension.getDimensionList().get(this.levelData.getDimension()) : Dimension.getDimensionList().get(0));
        this.dimensionData = saveHandler.getDimensionData(this.dimension.id);
        this.worldType = worldType != null ? worldType : (this.dimensionData != null ? this.dimensionData.getWorldType() : this.dimension.defaultWorldType);
        boolean isNewWorld = false;
        if (this.levelData == null) {
            this.levelData = new LevelData(seed, name);
            isNewWorld = true;
        } else {
            this.levelData.setWorldName(name);
        }
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(this.worldType);
            this.weatherManager = new WeatherManager(this);
        } else {
            this.weatherManager = new WeatherManager(this, this.dimensionData.getCurrentWeather(), this.dimensionData.getNextWeather(), this.dimensionData.getWeatherDuration(), this.dimensionData.getWeatherIntensity(), this.dimensionData.getWeatherPower());
        }
        this.chunkProvider = this.createChunkProvider();
        this.auroraProvider = new AuroraProvider(this, seed);
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        if (isNewWorld) {
            this.worldType.onWorldCreation(this);
            this.getInitialSpawnLocation();
        }
        this.updateSkyBrightness();
    }

    public World(World world, Dimension dimension) {
        this.lockTimestamp = world.lockTimestamp;
        this.saveHandler = world.saveHandler;
        this.levelData = new LevelData(world.levelData);
        this.dimensionData = world.saveHandler.getDimensionData(dimension.id);
        if (this.dimensionData == null) {
            this.dimensionData = new DimensionData(dimension.defaultWorldType);
            this.weatherManager = new WeatherManager(this);
        } else {
            this.weatherManager = new WeatherManager(this, this.dimensionData.getCurrentWeather(), this.dimensionData.getNextWeather(), this.dimensionData.getWeatherDuration(), this.dimensionData.getWeatherIntensity(), this.dimensionData.getWeatherPower());
        }
        this.worldType = this.dimensionData.getWorldType();
        this.savedDataStorage = new SavedDataStorage(this.saveHandler);
        this.dimension = dimension;
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.biomeProvider = this.worldType.createBiomeProvider(this);
        this.updateSkyBrightness();
        this.auroraProvider = new AuroraProvider(this, this.getRandomSeed());
    }

    public World(LevelStorage saveHandler, String name, Dimension dimension, WorldType worldType, long seed) {
        this.saveHandler = saveHandler;
        this.levelData = new LevelData(seed, name);
        this.dimension = dimension;
        this.dimensionData = new DimensionData(worldType);
        this.worldType = worldType;
        this.savedDataStorage = new SavedDataStorage(saveHandler);
        this.chunkProvider = this.createChunkProvider();
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.updateSkyBrightness();
        this.weatherManager = new WeatherManager(this);
        this.auroraProvider = new AuroraProvider(this, seed);
        this.biomeProvider = this.worldType.createBiomeProvider(this);
    }

    public World() {
        this.dimension = Dimension.overworld;
        this.saveHandler = null;
        this.levelData = new LevelData(0L, "modelviewer");
        this.worldType = WorldTypes.DEBUG;
        this.chunkProvider = new ChunkProviderViewer(this);
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getDefaultSeasonConfig());
        this.updateSkyBrightness();
        this.weatherManager = new WeatherManager(this);
        this.auroraProvider = new AuroraProvider(this, 0L);
        this.biomeProvider = this.worldType.createBiomeProvider(this);
    }

    public <T> T getGameRuleValue(GameRule<T> gameRule) {
        return this.levelData.getGameRules().getValue(gameRule);
    }

    public int getHeightBlocks() {
        return 256;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    protected IChunkProvider createChunkProvider() {
        IChunkLoader chunkLoader = this.saveHandler.getChunkLoader(this.dimension);
        return Global.accessor.createChunkProvider(this, chunkLoader);
    }

    protected void getInitialSpawnLocation() {
        this.findingSpawnPoint = true;
        this.getWorldType().getInitialSpawnLocation(this);
        this.findingSpawnPoint = false;
    }

    public void getRespawnLocation() {
        this.getWorldType().getRespawnLocation(this);
    }

    public int getTopBlock(int x, int z) {
        int y = this.levelData.getSpawnY() - 1;
        while (!this.isAirBlock(x, y + 1, z)) {
            ++y;
        }
        return this.getBlockId(x, y, z);
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer player) {
        try {
            CompoundTag nbttagcompound = this.levelData.getPlayerNBTTagCompound();
            if (nbttagcompound != null) {
                player.load(nbttagcompound);
                this.levelData.setPlayerNBTTagCompound(null);
            }
            int chunkX = MathHelper.floor_float((int)player.x) / 16;
            int chunkZ = MathHelper.floor_float((int)player.z) / 16;
            this.chunkProvider.setCurrentChunkOver(chunkX, chunkZ);
            this.entityJoinedWorld(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveWorld(boolean saveImmediately, ProgressListener progressUpdate, boolean saveLevelData) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (saveLevelData) {
            if (progressUpdate != null) {
                progressUpdate.progressStart("Saving level data");
            }
            this.saveWorldData();
        }
        if (progressUpdate != null) {
            progressUpdate.progressStage("Saving chunks");
        }
        this.chunkProvider.saveChunks(saveImmediately, progressUpdate);
        if (progressUpdate != null) {
            progressUpdate.progressStop();
        }
    }

    private void saveWorldData() {
        this.checkSessionLock();
        this.saveHandler.saveLevelDataAndPlayerData(this.levelData, this.players);
        this.saveHandler.saveDimensionData(this.dimension.id, this.dimensionData);
        this.savedDataStorage.save();
    }

    public boolean pauseScreenSave(int i) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i == 0) {
            this.saveWorldData();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    public Weather getCurrentWeather() {
        return this.weatherManager == null ? null : this.weatherManager.getCurrentWeather();
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            return 0;
        }
        return this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16)).getBlockID(x & 0xF, y, z & 0xF);
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return Block.getBlock(this.getBlockId(x, y, z));
    }

    @Override
    public double getBlockTemperature(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        double temperature = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            temperature = chunk.getBlockTemperature(x & 0xF, z & 0xF);
        }
        if (temperature == Double.NEGATIVE_INFINITY) {
            temperature = this.getBiomeProvider().getTemperature(x, z);
            if (chunk != null) {
                chunk.setBlockTemperature(x & 0xF, z & 0xF, temperature);
            }
        }
        return temperature;
    }

    @Override
    public double getBlockHumidity(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        double humidity = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            humidity = chunk.getBlockHumidity(x & 0xF, z & 0xF);
        }
        if (humidity == Double.NEGATIVE_INFINITY) {
            humidity = this.getBiomeProvider().getHumidity(x, z);
            if (chunk != null) {
                chunk.setBlockHumidity(x & 0xF, z & 0xF, humidity);
            }
        }
        return humidity;
    }

    @Override
    public SeasonManager getSeasonManager() {
        return this.seasonManager;
    }

    public double getBlockVariety(int x, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0.0;
        }
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        double variety = Double.NEGATIVE_INFINITY;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            variety = chunk.getBlockVariety(x & 0xF, z & 0xF);
        }
        if (variety == Double.NEGATIVE_INFINITY) {
            variety = this.getBiomeProvider().getVariety(x, z);
            if (chunk != null) {
                chunk.setBlockVariety(x & 0xF, z & 0xF, variety);
            }
        }
        return variety;
    }

    @Override
    public Biome getBlockBiome(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return Biomes.OVERWORLD_PLAINS;
        }
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        Biome biome = null;
        Chunk chunk = null;
        if (this.isChunkLoaded(chunkX, chunkZ)) {
            chunk = this.getChunkFromChunkCoords(chunkX, chunkZ);
            biome = chunk.getBlockBiome(x & 0xF, y, z & 0xF);
        }
        if (biome == null) {
            biome = this.getBiomeProvider().getBiome(x, y, z);
            if (chunk != null) {
                chunk.setBlockBiome(x & 0xF, y, z & 0xF, biome);
            }
        }
        return biome;
    }

    public boolean getBlockLitInteriorSurface(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return true;
        }
        if (y < 0) {
            return true;
        }
        if (y >= this.getHeightBlocks()) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this, x, y, z);
    }

    public boolean isAirBlock(int x, int y, int z) {
        return this.getBlockId(x, y, z) == 0;
    }

    public boolean isBlockLoaded(int x, int y, int z) {
        if (y < 0 || y >= this.getHeightBlocks()) {
            return false;
        }
        return this.isChunkLoaded(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
    }

    public boolean areBlocksLoaded(int x, int y, int z, int range) {
        return this.areBlocksLoaded(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public boolean areBlocksLoaded(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (maxY < 0 || minY >= this.getHeightBlocks()) {
            return false;
        }
        minZ >>= 4;
        maxX >>= 4;
        maxZ >>= 4;
        for (int chunkX = minX >>= 4; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                if (this.isChunkLoaded(chunkX, chunkZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.chunkProvider.isChunkLoaded(x, z);
    }

    public Chunk getChunkFromBlockCoords(int x, int z) {
        return this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
    }

    public Chunk getChunkFromChunkCoords(int x, int z) {
        return this.chunkProvider.provideChunk(x, z);
    }

    public boolean setBlockAndMetadata(int x, int y, int z, int id, int meta) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        return chunk.setBlockIDWithMetadata(x & 0xF, y, z & 0xF, id, meta);
    }

    public boolean setBlockRaw(int x, int y, int z, int id) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        return chunk.setBlockIDRaw(x & 0xF, y, z & 0xF, id);
    }

    public boolean setBlock(int x, int y, int z, int id) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        return chunk.setBlockID(x & 0xF, y, z & 0xF, id);
    }

    @Override
    public Material getBlockMaterial(int x, int y, int z) {
        int l = this.getBlockId(x, y, z);
        if (l == 0) {
            return Material.air;
        }
        return Block.blocksList[l].blockMaterial;
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        return chunk.getBlockMetadata(x &= 0xF, y, z &= 0xF);
    }

    public void setBlockMetadataWithNotify(int x, int y, int z, int meta) {
        if (this.setBlockMetadata(x, y, z, meta)) {
            this.markBlockNeedsUpdate(x, y, z);
            int id = this.getBlockId(x, y, z);
            if (Block.neighborNotifyOnMetadataChangeDisabled[id & 0x3FFF]) {
                this.notifyBlocksOfNeighborChange(x, y, z, id);
            }
        }
    }

    public boolean setBlockMetadata(int x, int y, int z, int meta) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= this.getHeightBlocks()) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        chunk.setBlockMetadata(x &= 0xF, y, z &= 0xF, meta);
        return true;
    }

    public boolean setBlockRawWithNotify(int x, int y, int z, int id) {
        if (this.setBlockRaw(x, y, z, id)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockWithNotify(int x, int y, int z, int id) {
        if (this.setBlock(x, y, z, id)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int x, int y, int z, int id, int meta) {
        if (this.setBlockAndMetadata(x, y, z, id, meta)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int x, int y, int z) {
        for (LevelListener listener : this.listeners) {
            listener.blockChanged(x, y, z);
        }
    }

    public void notifyBlockChange(int x, int y, int z, int id) {
        this.markBlockNeedsUpdate(x, y, z);
        this.notifyBlocksOfNeighborChange(x, y, z, id);
    }

    public void markBlocksDirtyVertical(int x, int z, int y0, int y1) {
        if (y0 > y1) {
            int t = y1;
            y1 = y0;
            y0 = t;
        }
        this.markBlocksDirty(x, y0, z, x, y1, z);
    }

    public void markBlockDirty(int x, int y, int z) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(x, y, z, x, y, z);
        }
    }

    public void markBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (LevelListener listener : this.listeners) {
            listener.setBlocksDirty(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public void notifyBlocksOfNeighborChange(int x, int y, int z, int blockId) {
        this.notifyBlockOfNeighborChange(x - 1, y, z, blockId);
        this.notifyBlockOfNeighborChange(x + 1, y, z, blockId);
        this.notifyBlockOfNeighborChange(x, y - 1, z, blockId);
        this.notifyBlockOfNeighborChange(x, y + 1, z, blockId);
        this.notifyBlockOfNeighborChange(x, y, z - 1, blockId);
        this.notifyBlockOfNeighborChange(x, y, z + 1, blockId);
    }

    private void notifyBlockOfNeighborChange(int x, int y, int z, int blockId) {
        if (this.editingBlocks || this.isClientSide) {
            return;
        }
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block != null) {
            block.onNeighborBlockChange(this, x, y, z, blockId);
        }
    }

    public boolean canBlockSeeTheSky(int x, int y, int z) {
        return this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16)).canBlockSeeTheSky(x & 0xF, y, z & 0xF);
    }

    public int getFullBlockLightValue(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= this.getHeightBlocks()) {
            y = this.getHeightBlocks() - 1;
        }
        return this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16)).getRawBrightness(x & 0xF, y, z & 0xF, 0);
    }

    public int getBlockLightValue(int i, int j, int k) {
        return this.getBlockLightValue_do(i, j, k, true);
    }

    public int getBlockLightValue_do(int i, int j, int k, boolean flag) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i, j, k)) {
            int i1 = this.getBlockLightValue_do(i, j + 1, k, false);
            int j1 = this.getBlockLightValue_do(i + 1, j, k, false);
            int k1 = this.getBlockLightValue_do(i - 1, j, k, false);
            int l1 = this.getBlockLightValue_do(i, j, k + 1, false);
            int i2 = this.getBlockLightValue_do(i, j, k - 1, false);
            if (j1 > i1) {
                i1 = j1;
            }
            if (k1 > i1) {
                i1 = k1;
            }
            if (l1 > i1) {
                i1 = l1;
            }
            if (i2 > i1) {
                i1 = i2;
            }
            return i1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= this.getHeightBlocks()) {
            j = this.getHeightBlocks() - 1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(i, 16), Math.floorDiv(k, 16));
        return chunk.getRawBrightness(i &= 0xF, j, k &= 0xF, this.skyDarken);
    }

    public boolean canExistingBlockSeeTheSky(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= this.getHeightBlocks()) {
            return true;
        }
        if (!this.isChunkLoaded(Math.floorDiv(i, 16), Math.floorDiv(k, 16))) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(i, 16), Math.floorDiv(k, 16));
        return chunk.canBlockSeeTheSky(i &= 0xF, j, k &= 0xF);
    }

    public int getHeightValue(int i, int j) {
        if (i < -32000000 || j < -32000000 || i >= 32000000 || j > 32000000) {
            return 0;
        }
        if (!this.isChunkLoaded(Math.floorDiv(i, 16), Math.floorDiv(j, 16))) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(i, 16), Math.floorDiv(j, 16));
        return chunk.getHeightValue(i & 0xF, j & 0xF);
    }

    public void neighborLightPropagationChanged(LightLayer lightLayer, int x, int y, int z, int lightValue) {
        int i1;
        if (this.worldType.hasCeiling() && lightLayer == LightLayer.Sky) {
            return;
        }
        if (!this.isBlockLoaded(x, y, z)) {
            return;
        }
        if (lightLayer == LightLayer.Sky) {
            if (this.canExistingBlockSeeTheSky(x, y, z)) {
                lightValue = 15;
            }
        } else if (lightLayer == LightLayer.Block && Block.lightEmission[i1 = this.getBlockId(x, y, z)] > lightValue) {
            lightValue = Block.lightEmission[i1];
        }
        if (this.getSavedLightValue(lightLayer, x, y, z) != lightValue) {
            this.scheduleLightingUpdate(lightLayer, x, y, z, x, y, z);
        }
    }

    @Override
    public int getSavedLightValue(LightLayer layer, int x, int y, int z) {
        int i1;
        if (y < 0) {
            y = 0;
        }
        if (y >= this.getHeightBlocks()) {
            y = this.getHeightBlocks() - 1;
        }
        if (y < 0 || y >= this.getHeightBlocks() || x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return layer.defaultLightLevel;
        }
        int l = Math.floorDiv(x, 16);
        if (!this.isChunkLoaded(l, i1 = Math.floorDiv(z, 16))) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l, i1);
        return chunk.getBrightness(layer, x & 0xF, y, z & 0xF);
    }

    public void setLightValue(LightLayer layer, int x, int y, int z, int value) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.getHeightBlocks()) {
            return;
        }
        if (!this.isChunkLoaded(Math.floorDiv(x, 16), Math.floorDiv(z, 16))) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        chunk.setBrightness(layer, x & 0xF, y, z & 0xF, value);
        for (LevelListener listener : this.listeners) {
            listener.blockChanged(x, y, z);
        }
    }

    @Override
    public float getBrightness(int x, int y, int z, int blockLightValue) {
        int i1 = this.getBlockLightValue(x, y, z);
        if (i1 < blockLightValue) {
            i1 = blockLightValue;
        }
        return this.worldType.getBrightnessRamp()[i1];
    }

    @Override
    public int getLightmapCoord(int x, int y, int z, int blockLightValue) {
        int skyLight = this.getSavedLightValue(LightLayer.Sky, x, y, z);
        int blockLight = Math.max(this.getSavedLightValue(LightLayer.Block, x, y, z), blockLightValue);
        if (this.getBlockLitInteriorSurface(x, y, z) || !this.isBlockOpaqueCube(x, y, z)) {
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x, y + 1, z));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x, y - 1, z));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x + 1, y, z));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x - 1, y, z));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x, y, z + 1));
            skyLight = Math.max(skyLight, this.getSavedLightValue(LightLayer.Sky, x, y, z - 1));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x, y + 1, z));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x, y - 1, z));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x + 1, y, z));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x - 1, y, z));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x, y, z + 1));
            blockLight = Math.max(blockLight, this.getSavedLightValue(LightLayer.Block, x, y, z - 1));
        }
        return LightmapHelper.getLightmapCoord(skyLight, blockLight);
    }

    @Override
    public float getLightBrightness(int x, int y, int z) {
        return this.worldType.getBrightnessRamp()[this.getBlockLightValue(x, y, z)];
    }

    public boolean isDaytime() {
        return this.skyDarken < 4;
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end) {
        return this.checkBlockCollisionBetweenPoints(start, end, false, false);
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end, boolean shouldCollideWithFluids) {
        return this.checkBlockCollisionBetweenPoints(start, end, shouldCollideWithFluids, false);
    }

    @Nullable
    public HitResult checkBlockCollisionBetweenPoints(Vec3d start, Vec3d end, boolean shouldCollideWithFluids, boolean flag1) {
        HitResult movingobjectposition;
        if (Double.isNaN(start.xCoord) || Double.isNaN(start.yCoord) || Double.isNaN(start.zCoord)) {
            return null;
        }
        if (Double.isNaN(end.xCoord) || Double.isNaN(end.yCoord) || Double.isNaN(end.zCoord)) {
            return null;
        }
        int blockEndX = MathHelper.floor_double(end.xCoord);
        int blockEndY = MathHelper.floor_double(end.yCoord);
        int blockEndZ = MathHelper.floor_double(end.zCoord);
        int blockStartX = MathHelper.floor_double(start.xCoord);
        int blockStartY = MathHelper.floor_double(start.yCoord);
        int blockStartZ = MathHelper.floor_double(start.zCoord);
        int id = this.getBlockId(blockStartX, blockStartY, blockStartZ);
        int meta = this.getBlockMetadata(blockStartX, blockStartY, blockStartZ);
        Block block = Block.blocksList[id];
        if ((!flag1 || block == null || block.getCollisionBoundingBoxFromPool(this, blockStartX, blockStartY, blockStartZ) != null) && id > 0 && block.canCollideCheck(meta, shouldCollideWithFluids) && (movingobjectposition = block.collisionRayTrace(this, blockStartX, blockStartY, blockStartZ, start, end)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            HitResult movingobjectposition1;
            if (Double.isNaN(start.xCoord) || Double.isNaN(start.yCoord) || Double.isNaN(start.zCoord)) {
                return null;
            }
            if (blockStartX == blockEndX && blockStartY == blockEndY && blockStartZ == blockEndZ) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (blockEndX > blockStartX) {
                d = (double)blockStartX + 1.0;
            } else if (blockEndX < blockStartX) {
                d = (double)blockStartX + 0.0;
            } else {
                flag2 = false;
            }
            if (blockEndY > blockStartY) {
                d1 = (double)blockStartY + 1.0;
            } else if (blockEndY < blockStartY) {
                d1 = (double)blockStartY + 0.0;
            } else {
                flag3 = false;
            }
            if (blockEndZ > blockStartZ) {
                d2 = (double)blockStartZ + 1.0;
            } else if (blockEndZ < blockStartZ) {
                d2 = (double)blockStartZ + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.xCoord - start.xCoord;
            double d7 = end.yCoord - start.yCoord;
            double d8 = end.zCoord - start.zCoord;
            if (flag2) {
                d3 = (d - start.xCoord) / d6;
            }
            if (flag3) {
                d4 = (d1 - start.yCoord) / d7;
            }
            if (flag4) {
                d5 = (d2 - start.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = blockEndX > blockStartX ? 4 : 5;
                start.xCoord = d;
                start.yCoord += d7 * d3;
                start.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = blockEndY > blockStartY ? 0 : 1;
                start.xCoord += d6 * d4;
                start.yCoord = d1;
                start.zCoord += d8 * d4;
            } else {
                byte0 = blockEndZ > blockStartZ ? 2 : 3;
                start.xCoord += d6 * d5;
                start.yCoord += d7 * d5;
                start.zCoord = d2;
            }
            Vec3d vec3d2 = Vec3d.createVector(start.xCoord, start.yCoord, start.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(start.xCoord);
            blockStartX = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --blockStartX;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(start.yCoord);
            blockStartY = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --blockStartY;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(start.zCoord);
            blockStartZ = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --blockStartZ;
                vec3d2.zCoord += 1.0;
            }
            int j2 = this.getBlockId(blockStartX, blockStartY, blockStartZ);
            int k2 = this.getBlockMetadata(blockStartX, blockStartY, blockStartZ);
            Block block1 = Block.blocksList[j2];
            if (flag1 && block1 != null && block1.getCollisionBoundingBoxFromPool(this, blockStartX, blockStartY, blockStartZ) == null || j2 <= 0 || !block1.canCollideCheck(k2, shouldCollideWithFluids) || (movingobjectposition1 = block1.collisionRayTrace(this, blockStartX, blockStartY, blockStartZ, start, end)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public void playSoundAtEntity(Entity player, Entity entity, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(player, soundPath, SoundCategory.ENTITY_SOUNDS, entity.x, entity.y - (double)entity.heightOffset, entity.z, volume, pitch);
        }
    }

    public void playSoundEffect(Entity player, SoundCategory category, double x, double y, double z, String soundPath, float volume, float pitch) {
        for (LevelListener listener : this.listeners) {
            listener.playSound(player, soundPath, category, x, y, z, volume, pitch);
        }
    }

    public void playBlockSoundEffect(Entity player, double x, double y, double z, Block block, EnumBlockSoundEffectType soundType) {
        if (block == null) {
            return;
        }
        BlockSound sound = (BlockSound)BlockSoundDispatcher.getInstance().getDispatch(block);
        if (sound == null) {
            return;
        }
        String name = soundType == EnumBlockSoundEffectType.MINE ? sound.getBreakSoundName() : sound.getStepSoundName();
        this.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, x, y, z, name, soundType.modifyVolume(sound.getVolume()), soundType.modifyPitch(sound.getPitch()));
    }

    public void playRecord(String soundPath, String author, int x, int y, int z) {
        for (int l = 0; l < this.listeners.size(); ++l) {
            this.listeners.get(l).playStreamingMusic(soundPath, author, x, y, z);
        }
    }

    public void spawnParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, maxDistance);
        }
    }

    public void spawnParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data);
        }
    }

    public boolean addWeatherEffect(Entity entity) {
        this.weatherEffects.add(entity);
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor_double(entity.x / 16.0);
        int j = MathHelper.floor_double(entity.z / 16.0);
        boolean flag = entity instanceof EntityPlayer;
        if (flag || this.isChunkLoaded(i, j)) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                this.players.add(entityplayer);
                this.updateEnoughPlayersSleepingFlag(null);
            }
            this.getChunkFromChunkCoords(i, j).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityAdded(entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).entityRemoved(entity);
        }
    }

    public void setEntityDead(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.startRiding(null);
        }
        if (entity.vehicle != null) {
            entity.startRiding(null);
        }
        entity.remove();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
    }

    public void removePlayer(Entity entity) {
        entity.remove();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
        int i = entity.chunkCoordX;
        int j = entity.chunkCoordZ;
        if (entity.addedToChunk && this.isChunkLoaded(i, j)) {
            this.getChunkFromChunkCoords(i, j).removeEntity(entity);
        }
        this.loadedEntityList.remove(entity);
        this.releaseEntitySkin(entity);
    }

    public void addListener(LevelListener iworldaccess) {
        this.listeners.add(iworldaccess);
    }

    public void removeListener(LevelListener iworldaccess) {
        this.listeners.remove(iworldaccess);
    }

    public List<AABB> getCubes(Entity entity, AABB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int minX = MathHelper.floor_double(axisalignedbb.minX);
        int maxX = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int minY = MathHelper.floor_double(axisalignedbb.minY);
        int maxY = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int minZ = MathHelper.floor_double(axisalignedbb.minZ);
        int maxZ = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int dx = minX - 1; dx <= maxX; ++dx) {
            for (int dz = minZ - 1; dz <= maxZ; ++dz) {
                if (!this.isBlockLoaded(dx, 64, dz)) continue;
                for (int dy = minY - 1; dy <= maxY; ++dy) {
                    Block block = Block.blocksList[this.getBlockId(dx, dy, dz)];
                    if (block == null) continue;
                    int metadata = this.getBlockMetadata(dx, dy, dz);
                    if (!block.collidesWithEntity(entity, this, dx, dy, dz) || !entity.collidesWithBlock(block, metadata)) continue;
                    block.getCollidingBoundingBoxes(this, dx, dy, dz, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double radius = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(radius, radius, radius));
        for (Entity value : list) {
            AABB axisalignedbb1 = value.getBb();
            if (axisalignedbb1 == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public List<AABB> getCollidingSolidBlockBoundingBoxes(Entity entity, AABB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int minX = MathHelper.floor_double(axisalignedbb.minX);
        int maxX = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int minY = MathHelper.floor_double(axisalignedbb.minY);
        int maxY = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int minZ = MathHelper.floor_double(axisalignedbb.minZ);
        int maxZ = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int dx = minX - 1; dx <= maxX; ++dx) {
            for (int dz = minZ - 1; dz <= maxZ; ++dz) {
                if (!this.isBlockLoaded(dx, 64, dz)) continue;
                for (int dy = minY - 1; dy <= maxY; ++dy) {
                    Block block = Block.blocksList[this.getBlockId(dx, dy, dz)];
                    if (block == null || !block.isSolidRender() || entity instanceof EntityItem && (block.id == Block.mesh.id || block.id == Block.spikes.id || block.id == Block.mobspawner.id)) continue;
                    block.getCollidingBoundingBoxes(this, dx, dy, dz, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double d = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d, d, d));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            AABB axisalignedbb1 = list.get(j2).getBb();
            if (axisalignedbb1 == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public float getAmbientBrightness(float partialTicks) {
        float angle = this.getCelestialAngle(partialTicks);
        float bright = 1.0f - (MathHelper.cos(angle * 3.141593f * 2.0f) * 2.0f + 0.2f);
        bright = 1.0f - MathHelper.clamp(bright, 0.0f, 1.0f);
        Weather weather = this.weatherManager.getCurrentWeather();
        if (weather != null) {
            float power;
            if (weather == Weather.overworldRain) {
                power = this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower();
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
            }
            if (weather == Weather.overworldStorm) {
                power = this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower();
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
                bright = (float)((double)bright * (1.0 - (double)(power * 5.0f) / 16.0));
            }
        }
        return bright * 0.8f + 0.2f;
    }

    public Vec3d getSkyColor(ICamera camera, float partialTick) {
        float f7;
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int x = MathHelper.floor_double(camera.getX(partialTick));
        int y = MathHelper.floor_double(camera.getY(partialTick));
        int z = MathHelper.floor_double(camera.getZ(partialTick));
        float blockTemperature = (float)this.getBlockTemperature(x, z);
        if (this.seasonManager.getCurrentSeason() != null && (this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_FALL)) {
            blockTemperature -= 1.25f;
        }
        int skyColor = Colorizers.sky.isEnabled() ? Colorizers.sky.getColor(this, x, y, z) : this.getBiomeProvider().getBiome(x, y, z).getSkyColor(blockTemperature);
        float r = (float)(skyColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(skyColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(skyColor & 0xFF) / 255.0f;
        r *= f2;
        g *= f2;
        b *= f2;
        float f = f7 = this.getCurrentWeather() != null && this.getCurrentWeather().isPrecipitation ? this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower() : 0.0f;
        if (f7 > 0.0f) {
            float f8 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f10 = 1.0f - f7 * 0.75f;
            r = r * f10 + f8 * (1.0f - f10);
            g = g * f10 + f8 * (1.0f - f10);
            b = b * f10 + f8 * (1.0f - f10);
        }
        if (this.lightningFlicker > 0) {
            float f12 = (float)this.lightningFlicker - partialTick;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            r = r * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            g = g * (1.0f - f12) + 0.8f * f12;
            b = b * (1.0f - f12) + f12;
        }
        return Vec3d.createVector(r, g, b);
    }

    public float getCelestialAngle(float partialTick) {
        if (!this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            partialTick = 1.0f;
        }
        return this.worldType.getCelestialAngle(this, this.levelData.getWorldTime(), partialTick);
    }

    public Vec3d getDimensionColor(ICamera camera, float partialTick) {
        float f6;
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int color = 0xFFFFFF;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float f = f6 = this.getCurrentWeather() != null && this.getCurrentWeather().isPrecipitation ? this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower() : 0.0f;
        if (f6 > 0.0f) {
            float f7 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f9 = 1.0f - f6 * 0.95f;
            r = r * f9 + f7 * (1.0f - f9);
            g = g * f9 + f7 * (1.0f - f9);
            b = b * f9 + f7 * (1.0f - f9);
        }
        return Vec3d.createVector(r *= f2 * 0.9f + 0.1f, g *= f2 * 0.9f + 0.1f, b *= f2 * 0.85f + 0.15f);
    }

    public Vec3d getFogColor(ICamera camera, float partialTick) {
        double x = camera.getX(partialTick);
        double y = camera.getY(partialTick);
        double z = camera.getZ(partialTick);
        float celestialAngle = this.getCelestialAngle(partialTick);
        return this.worldType.getFogColor(this, x, y, z, celestialAngle, partialTick);
    }

    public int findTopSolidBlock(int x, int z) {
        Chunk chunk = this.getChunkFromBlockCoords(x, z);
        x &= 0xF;
        z &= 0xF;
        for (int y = this.getHeightBlocks() - 1; y > 0; --y) {
            Material material;
            int id = chunk.getBlockID(x, y, z);
            Material material2 = material = id != 0 ? Block.blocksList[id].blockMaterial : Material.air;
            if (!material.blocksMotion() && !material.isLiquid()) {
                continue;
            }
            return y + 1;
        }
        return -1;
    }

    public int findTopSolidNonLiquidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = this.getHeightBlocks() - 1; k > 0; --k) {
            Material material;
            int l = chunk.getBlockID(i, k, j);
            Material material2 = material = l != 0 ? Block.blocksList[l].blockMaterial : Material.air;
            if (!material.blocksMotion()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public float getStarBrightness(float partialTick) {
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void scheduleBlockUpdate(int x, int y, int z, int id, int delay) {
        NextTickListEntry entry = new NextTickListEntry(x, y, z, id);
        int radius = 8;
        if (this.scheduledUpdatesAreImmediate && !this.immediatelyUpdatedPositions.contains(entry)) {
            int id1;
            if (this.areBlocksLoaded(entry.x - radius, entry.y - radius, entry.z - radius, entry.x + radius, entry.y + radius, entry.z + radius) && (id1 = this.getBlockId(entry.x, entry.y, entry.z)) == entry.blockId && id1 > 0) {
                this.immediatelyUpdatedPositions.add(entry);
                Block.blocksList[id1].updateTick(this, entry.x, entry.y, entry.z, this.rand);
            }
            return;
        }
        if (this.areBlocksLoaded(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius)) {
            if (id > 0) {
                entry.setDelay((long)delay + this.runtime);
            }
            if (!this.scheduledTickSet.contains(entry)) {
                this.scheduledTickSet.add(entry);
                this.scheduledTickTreeSet.add(entry);
            }
        }
    }

    public void updateEntities() {
        for (int i = 0; i < this.weatherEffects.size(); ++i) {
            Entity entity = this.weatherEffects.get(i);
            entity.tick();
            if (!entity.removed) continue;
            this.weatherEffects.remove(i--);
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            Entity entity1 = this.unloadedEntityList.get(j);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.isChunkLoaded(i1, k1)) continue;
            this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
        }
        for (int k = 0; k < this.unloadedEntityList.size(); ++k) {
            this.releaseEntitySkin(this.unloadedEntityList.get(k));
        }
        this.unloadedEntityList.clear();
        for (int l = 0; l < this.loadedEntityList.size(); ++l) {
            Entity entity2 = this.loadedEntityList.get(l);
            if (entity2.vehicle != null) {
                if (!entity2.vehicle.isRemoved() && entity2.vehicle.getPassenger() == entity2) continue;
                entity2.vehicle.setPassenger(null);
                entity2.vehicle = null;
            }
            if (!entity2.removed) {
                this.updateEntity(entity2);
            }
            if (!entity2.removed) continue;
            int j1 = entity2.chunkCoordX;
            int l1 = entity2.chunkCoordZ;
            if (entity2.addedToChunk && this.isChunkLoaded(j1, l1)) {
                this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
            }
            this.loadedEntityList.remove(l--);
            this.releaseEntitySkin(entity2);
        }
        this.field_31055_L = true;
        Iterator<TileEntity> iterator = this.loadedTileEntityList.iterator();
        while (iterator.hasNext()) {
            TileEntity tileentity = iterator.next();
            if (!tileentity.isInvalid()) {
                tileentity.tick();
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(tileentity.x, 16), Math.floorDiv(tileentity.z, 16));
            if (chunk == null) continue;
            chunk.removeTileEntity(tileentity.x & 0xF, tileentity.y, tileentity.z & 0xF);
        }
        this.field_31055_L = false;
        if (!this.field_30900_E.isEmpty()) {
            for (TileEntity tileentity1 : this.field_30900_E) {
                Chunk chunk1;
                if (tileentity1.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileentity1)) {
                    this.loadedTileEntityList.add(tileentity1);
                }
                if ((chunk1 = this.getChunkFromChunkCoords(Math.floorDiv(tileentity1.x, 16), Math.floorDiv(tileentity1.z, 16))) != null) {
                    chunk1.setTileEntity(tileentity1.x & 0xF, tileentity1.y, tileentity1.z & 0xF, tileentity1);
                }
                this.markBlockNeedsUpdate(tileentity1.x, tileentity1.y, tileentity1.z);
            }
            this.field_30900_E.clear();
        }
    }

    public void func_31054_a(Collection collection) {
        if (this.field_31055_L) {
            this.field_30900_E.addAll(collection);
        } else {
            this.loadedTileEntityList.addAll(collection);
        }
    }

    public void updateEntity(Entity entity) {
        this.updateEntityWithOptionalForce(entity, true);
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        int i = MathHelper.floor_double(entity.x);
        int j = MathHelper.floor_double(entity.z);
        int byte0 = 32;
        if (flag && !this.areBlocksLoaded(i - byte0, 0, j - byte0, i + byte0, this.getHeightBlocks(), j + byte0)) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).tryToDespawn();
            }
            return;
        }
        entity.xo = entity.x;
        entity.yo = entity.y;
        entity.zo = entity.z;
        entity.yRotO = entity.yRot;
        entity.xRotO = entity.xRot;
        if (flag && entity.addedToChunk) {
            if (entity.vehicle != null) {
                entity.rideTick();
            } else {
                entity.tick();
            }
        }
        if (Double.isNaN(entity.x) || Double.isInfinite(entity.x)) {
            entity.x = entity.xo;
        }
        if (Double.isNaN(entity.y) || Double.isInfinite(entity.y)) {
            entity.y = entity.yo;
        }
        if (Double.isNaN(entity.z) || Double.isInfinite(entity.z)) {
            entity.z = entity.zo;
        }
        if (Double.isNaN(entity.xRot) || Double.isInfinite(entity.xRot)) {
            entity.xRot = entity.xRotO;
        }
        if (Double.isNaN(entity.yRot) || Double.isInfinite(entity.yRot)) {
            entity.yRot = entity.yRotO;
        }
        int k = MathHelper.floor_double(entity.x / 16.0);
        int l = MathHelper.floor_double(entity.y / 16.0);
        int i1 = MathHelper.floor_double(entity.z / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.isChunkLoaded(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.isChunkLoaded(k, i1)) {
                entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
            }
        }
        if (flag && entity.addedToChunk && entity.passenger != null) {
            if (entity.passenger.removed || entity.passenger.vehicle != entity) {
                entity.passenger.vehicle = null;
                entity.passenger = null;
            } else {
                this.updateEntity(entity.passenger);
            }
        }
    }

    public boolean checkIfAABBIsClear(AABB axisalignedbb) {
        if (axisalignedbb == null) {
            return true;
        }
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity instanceof EntityFireflyCluster || entity.removed || !entity.blocksBuilding) continue;
            return false;
        }
        return true;
    }

    public boolean getIsAnySolidGround(AABB boundingBox) {
        int minX = MathHelper.floor_double(boundingBox.minX);
        int maxX = MathHelper.floor_double(boundingBox.maxX);
        int minY = MathHelper.floor_double(boundingBox.minY);
        int maxY = MathHelper.floor_double(boundingBox.maxY);
        int minZ = MathHelper.floor_double(boundingBox.minZ);
        int maxZ = MathHelper.floor_double(boundingBox.maxZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block block = Block.blocksList[this.getBlockId(x, y, z)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        List<Entity> entities = this.getEntitiesWithinAABBExcludingEntity(null, boundingBox);
        for (Entity entity : entities) {
            AABB axisalignedbb1 = entity.getBb();
            if (axisalignedbb1 == null || !axisalignedbb1.intersectsWith(boundingBox)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return false;
    }

    public boolean getIsAnyLiquid(AABB boundingBox) {
        int minX = MathHelper.floor_double(boundingBox.minX);
        int maxX = MathHelper.floor_double(boundingBox.maxX);
        int minY = MathHelper.floor_double(boundingBox.minY);
        int maxY = MathHelper.floor_double(boundingBox.maxY);
        int minZ = MathHelper.floor_double(boundingBox.minZ);
        int maxZ = MathHelper.floor_double(boundingBox.maxZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block block = Block.blocksList[this.getBlockId(x, y, z)];
                    if (block == null || !block.blockMaterial.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AABB axisalignedbb) {
        return this.isMaterialInBB(axisalignedbb, Material.fire, Material.lava);
    }

    public boolean handleMaterialAcceleration(AABB axisalignedbb, Material material, Entity entity, boolean addVelocity) {
        int j1;
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (!this.areBlocksLoaded(i, k, i1, j, l, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            return false;
        }
        boolean flag = false;
        Vec3d vec3d = Vec3d.createVector(0.0, 0.0, 0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || !this.isMaterialInBB(axisalignedbb, material)) continue;
                    flag = true;
                    block.handleEntityInside(this, k1, l1, i2, entity, vec3d);
                }
            }
        }
        if (vec3d.lengthVector() > 0.0 && addVelocity) {
            vec3d = vec3d.normalize();
            double d = 0.014;
            entity.xd += vec3d.xCoord * d;
            entity.yd += vec3d.yCoord * d;
            entity.zd += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean isMaterialInBB(AABB axisalignedbb, Material ... materials) {
        int minX_i = MathHelper.floor_double(axisalignedbb.minX);
        int maxX_i = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int minY_i = MathHelper.floor_double(axisalignedbb.minY);
        int maxY_i = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int minZ_i = MathHelper.floor_double(axisalignedbb.minZ);
        int maxZ_i = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int _x = minX_i; _x < maxX_i; ++_x) {
            for (int _y = minY_i; _y < maxY_i; ++_y) {
                for (int _z = minZ_i; _z < maxZ_i; ++_z) {
                    Block block = Block.blocksList[this.getBlockId(_x, _y, _z)];
                    if (block == null) continue;
                    boolean isMaterial = false;
                    for (Material m : materials) {
                        if (block.blockMaterial != m) continue;
                        isMaterial = true;
                        break;
                    }
                    if (!isMaterial) continue;
                    block.setBlockBoundsBasedOnState(this, _x, _y, _z);
                    if (!axisalignedbb.intersectsWith(AABB.getBoundingBoxFromPool((double)_x + block.minZ, (double)_y + block.minY, (double)_z + block.minZ, (double)_x + block.maxZ, (double)_y + block.maxY, (double)_z + block.maxZ))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAABBInMaterial(AABB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i2)];
                    if (block == null || block.blockMaterial != material) continue;
                    int j2 = this.getBlockMetadata(k1, l1, i2);
                    double d = l1 + 1;
                    if (j2 < 8) {
                        d = (double)(l1 + 1) - (double)j2 / 8.0;
                    }
                    if (!(d >= axisalignedbb.minY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double x, double y, double z, float explosionSize) {
        return this.newExplosion(entity, x, y, z, explosionSize, false, false);
    }

    public Explosion newExplosion(Entity entity, double x, double y, double z, float explosionSize, boolean flaming, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, x, y, z, explosionSize) : new ExplosionCannonball(this, entity, x, y, z, explosionSize);
        explosion.isFlaming = flaming;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    public float func_675_a(Vec3d vec3d, AABB axisalignedbb) {
        double d = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f2;
                    if (this.checkBlockCollisionBetweenPoints(Vec3d.createVector(d3, d4, d5), vec3d) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void onBlockHit(EntityPlayer entityplayer, int x, int y, int z, Side side) {
        if (this.getBlockId(x += side.getOffsetX(), y += side.getOffsetY(), z += side.getOffsetZ()) == Block.fire.id) {
            this.playSoundEffect(entityplayer, 1004, x, y, z, 0);
            this.setBlockWithNotify(x, y, z, 0);
        }
    }

    public Entity func_4085_a(Class class1) {
        return null;
    }

    public String getNumLoadedEntitiesString() {
        return "All: " + this.loadedEntityList.size();
    }

    public String getChunkProviderInfoString() {
        return this.chunkProvider.getInfoString();
    }

    @Override
    public TileEntity getBlockTileEntity(int x, int y, int z) {
        Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(x, 16), Math.floorDiv(z, 16));
        if (chunk != null) {
            return chunk.getTileEntity(x & 0xF, y, z & 0xF);
        }
        return null;
    }

    public void setBlockTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (!tileentity.isInvalid()) {
            if (this.field_31055_L) {
                tileentity.x = i;
                tileentity.y = j;
                tileentity.z = k;
                this.field_30900_E.add(tileentity);
            } else {
                this.loadedTileEntityList.add(tileentity);
                Chunk chunk = this.getChunkFromChunkCoords(Math.floorDiv(i, 16), Math.floorDiv(k, 16));
                if (chunk != null) {
                    chunk.setTileEntity(i & 0xF, j, k & 0xF, tileentity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int i, int j, int k) {
        TileEntity tileentity = this.getBlockTileEntity(i, j, k);
        if (tileentity != null && this.field_31055_L) {
            tileentity.invalidate();
        } else {
            Chunk chunk;
            if (tileentity != null) {
                this.loadedTileEntityList.remove(tileentity);
            }
            if ((chunk = this.getChunkFromChunkCoords(Math.floorDiv(i, 16), Math.floorDiv(k, 16))) != null) {
                chunk.removeTileEntity(i & 0xF, j, k & 0xF);
            }
        }
    }

    @Override
    public boolean isBlockOpaqueCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isSolidRender();
    }

    public boolean canPlaceOnSurfaceOfBlock(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.canPlaceOnSurfaceOnCondition(this, x, y, z);
    }

    @Override
    public boolean isBlockNormalCube(int x, int y, int z) {
        Block block = Block.blocksList[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, x, y, z);
    }

    public boolean canPlaceInsideBlock(int x, int y, int z) {
        int id = this.getBlockId(x, y, z);
        return id == 0 || Block.getBlock(id).hasTag(BlockTags.PLACE_OVERWRITES);
    }

    public void onUnload() {
        this.updateEntities();
        this.loadedEntityList.clear();
        this.unloadedEntityList.clear();
    }

    public void saveWorldIndirectly(ProgressListener iprogressupdate) {
        this.saveWorld(true, iprogressupdate, true);
    }

    public boolean updatingLighting() {
        if (this.lightingUpdatesCounter >= 50) {
            return false;
        }
        ++this.lightingUpdatesCounter;
        try {
            for (int i = 499; this.lightingToUpdate.size() > 0 && i >= 0; --i) {
                this.lightingToUpdate.remove(this.lightingToUpdate.size() - 1).performLightUpdate(this);
                if (i != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this.lightingUpdatesCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleLightingUpdate(LightLayer layer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.worldType.hasCeiling() && layer == LightLayer.Sky) {
            return;
        }
        ++lightingUpdatesScheduled;
        try {
            if (lightingUpdatesScheduled == 50) {
                return;
            }
            int centerX = (maxX + minX) / 2;
            int centerZ = (maxZ + minZ) / 2;
            if (!this.isBlockLoaded(centerX, 64, centerZ)) {
                return;
            }
            if (this.getChunkFromBlockCoords(centerX, centerZ).isChunkEmpty()) {
                return;
            }
            int numLightingUpdates = this.lightingToUpdate.size();
            if (numLightingUpdates > 5) {
                numLightingUpdates = 5;
            }
            for (int i = 0; i < numLightingUpdates; ++i) {
                LightUpdate lightUpdate = this.lightingToUpdate.get(this.lightingToUpdate.size() - i - 1);
                if (lightUpdate.layer != layer || !lightUpdate.expandToContain(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return;
            }
            this.lightingToUpdate.add(new LightUpdate(layer, minX, minY, minZ, maxX, maxY, maxZ));
            int maxLightingUpdates = 1000000;
            if (this.lightingToUpdate.size() > maxLightingUpdates) {
                System.out.println("More than " + maxLightingUpdates + " updates, dropping first " + maxLightingUpdates / 2 + " lighting updates");
                this.lightingToUpdate.subList(0, maxLightingUpdates / 2).clear();
            }
        }
        finally {
            --lightingUpdatesScheduled;
        }
    }

    public void updateSkyBrightness() {
        int i = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f);
        if (i != this.skyDarken) {
            this.skyDarken = i;
        }
    }

    public void setAllowedMobSpawns(boolean flag, boolean flag1) {
        this.spawnHostileMobs = flag;
        this.spawnPeacefulMobs = flag1;
    }

    public void allChanged(boolean lightChanged, boolean seasonChanged) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).allChanged(lightChanged, seasonChanged);
        }
    }

    protected void updateSleepingPlayers() {
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean wasInterrupted = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                wasInterrupted = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!wasInterrupted) {
                long timePlusOneDay = this.levelData.getWorldTime() + 24000L;
                this.levelData.setWorldTime(timePlusOneDay - timePlusOneDay % 24000L + (long)this.worldType.getSunriseTick(this) + 1000L);
                this.wakeUpAllPlayers();
            }
        }
    }

    public void tick() {
        Debug.push("misc");
        this.immediatelyUpdatedPositions.clear();
        Debug.change("weather");
        this.weatherManager.tick();
        Debug.change("misc");
        this.updateSleepingPlayers();
        Debug.change("spawning");
        SpawnerMobs.performSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs);
        Debug.change("chunk");
        this.chunkProvider.tick();
        Debug.change("autosave");
        int autosaveTimeInSeconds = Global.accessor.getAutosaveTimer();
        int autosaveTimeInTicks = autosaveTimeInSeconds * 20;
        boolean bl = AUTOSAVE = autosaveTimeInTicks != 0;
        if (AUTOSAVE && this.runtime % (long)autosaveTimeInTicks == 0L) {
            this.saveWorld(false, null, true);
        }
        Debug.change("misc");
        if (this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            this.levelData.setWorldTime(this.levelData.getWorldTime() + 1L);
        }
        ++this.runtime;
        this.tickUpdates(false);
        Debug.change("blocks&cavesSounds");
        this.updateBlocksAndPlayCaveSounds();
        Debug.change("season&light");
        this.updateSeasonAndLight();
        Debug.pop();
    }

    public void updateSeasonAndLight() {
        int currentSkyDarken;
        boolean seasonChanged = false;
        boolean lightChanged = false;
        int currentDayCount = (int)(this.levelData.getWorldTime() / 24000L);
        if (currentDayCount != this.dayCountLastTick) {
            this.dayCountLastTick = currentDayCount;
            seasonChanged = true;
        }
        if ((currentSkyDarken = this.worldType.getSkyDarken(this, this.getWorldTime(), 1.0f)) != this.skyDarken) {
            this.skyDarken = currentSkyDarken;
            lightChanged = true;
        }
        if (seasonChanged || lightChanged) {
            this.allChanged(lightChanged, seasonChanged);
        }
    }

    protected void updateBlocksAndPlayCaveSounds() {
        this.positionsToUpdate.clear();
        for (int i = 0; i < this.players.size(); ++i) {
            EntityPlayer entityplayer = this.players.get(i);
            int playerChunkX = MathHelper.floor_double(entityplayer.x / 16.0);
            int playerChunkZ = MathHelper.floor_double(entityplayer.z / 16.0);
            int radius = 9;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    this.positionsToUpdate.add(new ChunkCoordinate(x + playerChunkX, z + playerChunkZ));
                }
            }
        }
        if (this.caveSoundCounter > 0) {
            --this.caveSoundCounter;
        }
        for (ChunkCoordinate coordinate : this.positionsToUpdate) {
            EntityPlayer entityplayer1;
            int blockY;
            int id;
            int chunkBlockX = coordinate.x * 16;
            int chunkBlockZ = coordinate.z * 16;
            if (!this.isChunkLoaded(coordinate.x, coordinate.z)) continue;
            Chunk chunk = this.getChunkFromChunkCoords(coordinate.x, coordinate.z);
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int randVal = this.updateLCG >> 2;
            int blockX = randVal & 0xF;
            int blockZ = randVal / 256 & 0xF;
            if (this.caveSoundCounter == 0 && (id = chunk.getBlockID(blockX, blockY = randVal / 65536 & 0xFF, blockZ)) == 0 && this.getFullBlockLightValue(blockX += chunkBlockX, blockY, blockZ += chunkBlockZ) <= this.rand.nextInt(8) && this.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) <= 0 && (entityplayer1 = this.getClosestPlayer((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, 8.0)) != null && entityplayer1.distanceToSqr((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5) > 4.0) {
                this.playSoundEffect(null, SoundCategory.CAVE_SOUNDS, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                this.caveSoundCounter = this.rand.nextInt(12000) + 6000;
            }
            if (this.getCurrentWeather() != null) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                randVal = this.updateLCG >> 2;
                int weatherBlockX = randVal & 0xF;
                int weatherBlockZ = randVal / 256 & 0xF;
                this.getCurrentWeather().doEnvironmentUpdate(this, this.rand, chunkBlockX + weatherBlockX, chunkBlockZ + weatherBlockZ);
            }
            for (int i = 0; i < 80; ++i) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int iRandVal = this.updateLCG >> 2;
                int iBlockX = iRandVal & 0xF;
                int iBlockY = iRandVal / 65536 & 0xFF;
                int iBlockZ = iRandVal / 256 & 0xF;
                int id2 = chunk.getBlockID(iBlockX, iBlockY, iBlockZ);
                if (Block.shouldTick[id2]) {
                    Block.blocksList[id2].updateTick(this, iBlockX + chunkBlockX, iBlockY, iBlockZ + chunkBlockZ, this.rand);
                }
                ++i;
            }
        }
    }

    public boolean tickUpdates(boolean all) {
        int count = this.scheduledTickTreeSet.size();
        if (count != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of sync");
        }
        if (count > 1000) {
            count = 1000;
        }
        for (int j = 0; j < count; ++j) {
            int k;
            NextTickListEntry entry = this.scheduledTickTreeSet.first();
            if (!all && entry.delay > this.runtime) break;
            this.scheduledTickTreeSet.remove(entry);
            this.scheduledTickSet.remove(entry);
            int byte0 = 8;
            if (!this.areBlocksLoaded(entry.x - byte0, entry.y - byte0, entry.z - byte0, entry.x + byte0, entry.y + byte0, entry.z + byte0) || (k = this.getBlockId(entry.x, entry.y, entry.z)) != entry.blockId || k <= 0) continue;
            Block.blocksList[k].updateTick(this, entry.x, entry.y, entry.z, this.rand);
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public void randomDisplayUpdates(int x, int y, int z) {
        int radius = 16;
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int rz;
            int ry;
            int rx = x + this.rand.nextInt(radius) - this.rand.nextInt(radius);
            int id = this.getBlockId(rx, ry = y + this.rand.nextInt(radius) - this.rand.nextInt(radius), rz = z + this.rand.nextInt(radius) - this.rand.nextInt(radius));
            if (id <= 0) continue;
            Block.blocksList[id].randomDisplayTick(this, rx, ry, rz, random);
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AABB aabb) {
        this.entityBuffer.clear();
        int minX = MathHelper.floor_double((aabb.minX - 2.0) / 16.0);
        int maxX = MathHelper.floor_double((aabb.maxX + 2.0) / 16.0);
        int minZ = MathHelper.floor_double((aabb.minZ - 2.0) / 16.0);
        int maxZ = MathHelper.floor_double((aabb.maxZ + 2.0) / 16.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.isChunkLoaded(x, z)) continue;
                this.getChunkFromChunkCoords(x, z).getEntitiesWithin(entity, aabb, this.entityBuffer);
            }
        }
        return this.entityBuffer;
    }

    public List<Entity> getEntitiesWithinAABB(Class<? extends Entity> ofClass, AABB aabb) {
        int minX = MathHelper.floor_double((aabb.minX - 2.0) / 16.0);
        int maxX = MathHelper.floor_double((aabb.maxX + 2.0) / 16.0);
        int minZ = MathHelper.floor_double((aabb.minZ - 2.0) / 16.0);
        int maxZ = MathHelper.floor_double((aabb.maxZ + 2.0) / 16.0);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.isChunkLoaded(x, z)) continue;
                this.getChunkFromChunkCoords(x, z).getEntitiesWithin(ofClass, aabb, entities);
            }
        }
        return entities;
    }

    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void updateTileEntityChunkAndSendToPlayer(int x, int y, int z, TileEntity tileEntity) {
        if (this.isBlockLoaded(x, y, z)) {
            this.getChunkFromBlockCoords(x, z).setChunkModified();
        }
        for (int l = 0; l < this.listeners.size(); ++l) {
            this.listeners.get(l).tileEntityChanged(x, y, z, tileEntity);
        }
    }

    public int countEntities(Class<?> clazz) {
        int i = 0;
        for (Entity entity : this.loadedEntityList) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void addLoadedEntities(List<Entity> list) {
        this.loadedEntityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.obtainEntitySkin(list.get(i));
        }
    }

    public void unloadEntities(List<Entity> list) {
        this.unloadedEntityList.addAll(list);
    }

    public void dropOldChunks() {
        while (this.chunkProvider.tick()) {
        }
    }

    public boolean canBlockBePlacedAt(int blockId, int x, int y, int z, boolean flag, Side side) {
        if (y < 0 || y >= this.getHeightBlocks()) {
            return false;
        }
        int j1 = this.getBlockId(x, y, z);
        Block block = Block.blocksList[j1];
        Block block1 = Block.blocksList[blockId];
        AABB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, x, y, z);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.checkIfAABBIsClear(axisalignedbb)) {
            return false;
        }
        if (block != null && block.hasTag(BlockTags.PLACE_OVERWRITES)) {
            block = null;
        }
        return blockId > 0 && block == null && block1.canPlaceBlockOnSide(this, x, y, z, side.getId());
    }

    public Path getPathToEntity(Entity entity, Entity entityToTravelTo, float distance) {
        int x1 = MathHelper.floor_double(entity.x);
        int y2 = MathHelper.floor_double(entity.y);
        int z1 = MathHelper.floor_double(entity.z);
        int radius = (int)(distance + 16.0f);
        int xMin = x1 - radius;
        int yMin = y2 - radius;
        int zMin = z1 - radius;
        int xMax = x1 + radius;
        int yMax = y2 + radius;
        int zMax = z1 + radius;
        ChunkCache chunkcache = new ChunkCache(this, xMin, yMin, zMin, xMax, yMax, zMax);
        return new PathFinder(chunkcache).findPath(entity, entityToTravelTo, distance);
    }

    public Path getEntityPathToXYZ(Entity entity, int i, int j, int k, float f) {
        int l = MathHelper.floor_double(entity.x);
        int i1 = MathHelper.floor_double(entity.y);
        int j1 = MathHelper.floor_double(entity.z);
        int k1 = (int)(f + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3);
        return new PathFinder(chunkcache).findPath(entity, i, j, k, f);
    }

    public boolean isBlockProvidingPowerTo(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isIndirectlyPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockGettingPowered(int i, int j, int k) {
        if (this.isBlockProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(i + 1, j, k, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (this.isBlockNormalCube(i, j, k) && i1 != Block.blockRedstone.id) {
            return this.isBlockGettingPowered(i, j, k);
        }
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockIndirectlyGettingPowered(int i, int j, int k) {
        if (this.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double radius) {
        return this.getClosestPlayer(entity.x, entity.y, entity.z, radius);
    }

    public EntityPlayer getClosestPlayer(double x, double y, double z, double radius) {
        if (radius < 0.0) {
            return null;
        }
        double closestDistance = Double.POSITIVE_INFINITY;
        EntityPlayer entityplayer = null;
        for (EntityPlayer entityPlayer1 : this.players) {
            double currentDistance = entityPlayer1.distanceToSqr(x, y, z);
            if (!(currentDistance < radius * radius) || !(currentDistance < closestDistance)) continue;
            closestDistance = currentDistance;
            entityplayer = entityPlayer1;
        }
        return entityplayer;
    }

    public EntityPlayer getPlayerEntityByName(String s) {
        for (EntityPlayer player : this.players) {
            if (!s.equals(player.username)) continue;
            return player;
        }
        return null;
    }

    public void setChunkData(int x, int y, int z, int width, int height, int length, byte[] data) {
        int minChunkX = Math.floorDiv(x, 16);
        int minChunkZ = Math.floorDiv(z, 16);
        int maxChunkX = Math.floorDiv(x + width - 1, 16);
        int maxChunkZ = Math.floorDiv(z + length - 1, 16);
        int startIndex = 0;
        int minY = y;
        int maxY = y + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).setChunkData(data, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
                this.markBlocksDirty(chunkX * 16 + minX, minY, chunkZ * 16 + minZ, chunkX * 16 + maxX, maxY, chunkZ * 16 + maxZ);
            }
        }
    }

    public byte[] getChunkData(int x, int y, int z, int xSize, int ySize, int zSize) {
        byte[] data = new byte[xSize * ySize * zSize * 8];
        int minChunkX = Math.floorDiv(x, 16);
        int minChunkZ = Math.floorDiv(z, 16);
        int maxChunkX = Math.floorDiv(x + xSize - 1, 16);
        int maxChunkZ = Math.floorDiv(z + zSize - 1, 16);
        int startIndex = 0;
        int minY = y;
        int maxY = y + ySize;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > this.getHeightBlocks()) {
            maxY = this.getHeightBlocks();
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x - chunkX * 16;
            int maxX = x + xSize - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z - chunkZ * 16;
                int maxZ = z + zSize - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).getChunkData(data, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
            }
        }
        return data;
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.checkSessionLock();
    }

    public void setWorldTime(long l) {
        this.levelData.setWorldTime(l);
    }

    public void setWorldTimeUpdateTicks(long l) {
        long l1 = l - this.levelData.getWorldTime();
        for (NextTickListEntry nextticklistentry : this.scheduledTickSet) {
            nextticklistentry.delay += l1;
        }
        this.setWorldTime(l);
    }

    public long getRandomSeed() {
        return this.levelData.getRandomSeed();
    }

    public long getWorldTime() {
        return this.levelData.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.levelData.getSpawnX(), this.levelData.getSpawnY(), this.levelData.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.levelData.setSpawn(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z);
    }

    public void joinEntityInSurroundings(Entity entity) {
        int i = MathHelper.floor_double(entity.x / 16.0);
        int j = MathHelper.floor_double(entity.z / 16.0);
        int byte0 = 2;
        for (int k = i - byte0; k <= i + byte0; ++k) {
            for (int l = j - byte0; l <= j + byte0; ++l) {
                this.getChunkFromChunkCoords(k, l);
            }
        }
        if (!this.loadedEntityList.contains(entity)) {
            this.loadedEntityList.add(entity);
        }
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        return true;
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
    }

    public void sendTrackedEntityDataPacket(Entity entity) {
    }

    public void updateEntityList() {
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int i = 0; i < this.unloadedEntityList.size(); ++i) {
            Entity entity = this.unloadedEntityList.get(i);
            int l = entity.chunkCoordX;
            int j1 = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.isChunkLoaded(l, j1)) continue;
            this.getChunkFromChunkCoords(l, j1).removeEntity(entity);
        }
        for (int j = 0; j < this.unloadedEntityList.size(); ++j) {
            this.releaseEntitySkin(this.unloadedEntityList.get(j));
        }
        this.unloadedEntityList.clear();
        for (int k = 0; k < this.loadedEntityList.size(); ++k) {
            Entity entity1 = this.loadedEntityList.get(k);
            if (entity1.vehicle != null) {
                if (!entity1.vehicle.isRemoved() && entity1.vehicle.getPassenger() == entity1) continue;
                entity1.vehicle.setPassenger(null);
                entity1.vehicle = null;
            }
            if (!entity1.removed) continue;
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.isChunkLoaded(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
            }
            this.loadedEntityList.remove(k--);
            this.releaseEntitySkin(entity1);
        }
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void triggerEvent(int x, int y, int z, int index, int data) {
        int j1 = this.getBlockId(x, y, z);
        if (j1 > 0) {
            Block.blocksList[j1].triggerEvent(this, x, y, z, index, data);
        }
    }

    public LevelStorage getSaveHandler() {
        return this.saveHandler;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public void updateEnoughPlayersSleepingFlag(EntityPlayer player) {
        this.enoughPlayersSleeping = false;
        if (this.players.size() > 0) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (EntityPlayer p : this.players) {
                if (!p.isPlayerSleeping()) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
        }
    }

    public int getPlayersRequiredToSkipNight() {
        return (int)((double)this.players.size() * ((double)this.sleepPercent / 100.0));
    }

    protected void wakeUpAllPlayers() {
        this.enoughPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.players) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false);
        }
        if (this.getCurrentWeather() != null && this.getCurrentWeather().spawnRainParticles) {
            this.weatherManager.overrideWeather(this.worldType.getDefaultWeather());
        }
    }

    public boolean areEnoughPlayersFullyAsleep() {
        if (this.enoughPlayersSleeping && !this.isClientSide) {
            int fullyAsleep = 0;
            for (EntityPlayer player : this.players) {
                if (!player.isPlayerFullyAsleep()) continue;
                ++fullyAsleep;
            }
            return fullyAsleep >= this.getPlayersRequiredToSkipNight() && fullyAsleep > 0;
        }
        return false;
    }

    public boolean canBlockBeRainedOn(int x, int y, int z) {
        if (this.getCurrentWeather() == null) {
            return false;
        }
        if (!this.getCurrentWeather().isPrecipitation) {
            return false;
        }
        if (!this.canBlockSeeTheSky(x, y, z)) {
            return false;
        }
        if (this.getHeightValue(x, z) > y) {
            return false;
        }
        Biome biome = this.getBlockBiome(x, y, z);
        for (int q = 0; q < biome.blockedWeathers.length; ++q) {
            if (biome.blockedWeathers[q] != this.getCurrentWeather()) continue;
            return false;
        }
        return true;
    }

    public void setSavedData(String s, SavedData mapdatabase) {
        this.savedDataStorage.set(s, mapdatabase);
    }

    public SavedData getSavedData(Class class1, String s) {
        return this.savedDataStorage.load(class1, s);
    }

    public int getUniqueDataId(String s) {
        return this.savedDataStorage.getFreeMetadataFor(s);
    }

    public void playSoundEffect(int id, int x, int y, int z, int data) {
        this.playSoundEffect(null, id, x, y, z, data);
    }

    public void playSoundEffect(EntityPlayer entityplayer, int id, int x, int y, int z, int data) {
        for (LevelListener listener : this.listeners) {
            listener.levelEvent(entityplayer, id, x, y, z, data);
        }
    }

    public WorldType getWorldType() {
        return this.worldType;
    }

    public EntityItem dropItem(int x, int y, int z, ItemStack itemStack) {
        float f = 0.7f;
        double x1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double y1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double z1 = (double)(this.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this, (double)x + x1, (double)y + y1, (double)z + z1, itemStack);
        entityitem.delayBeforeCanPickup = 10;
        this.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public void sendGlobalMessage(String message) {
        for (EntityPlayer player : this.players) {
            player.sendMessage(message);
        }
    }
}

