/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.conversion;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.world.save.IdKeyTable;

public class IdKeyTableConverter {
    public void convert(CompoundTag chunkData, IdKeyTable oldTable, IdKeyTable newTable) {
        if (IdKeyTable.areMapsIdentical(oldTable, newTable)) {
            return;
        }
        CompoundTag tagLevel = chunkData.getCompound("Level");
        short[] blocks = tagLevel.getShortArray("Blocks");
        short lastId = -1;
        int newId = -1;
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] != lastId) {
                lastId = blocks[i];
                String key = oldTable.getKeyById(lastId);
                newId = (short)newTable.getIDByKey(key);
            }
            blocks[i] = newId;
        }
    }
}

