/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.Packet130UpdateSign;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditSign
extends GuiScreen {
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_sign.label.title");
    private TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;
    private int yOffset = 0;
    private static final String allowedCharacters = ChatAllowedCharacters.ALLOWED_CHARACTERS;

    public GuiEditSign(TileEntitySign tileentitysign) {
        this.entitySign = tileentitysign;
    }

    @Override
    public void init() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        Block block = this.entitySign.getBlockType();
        if (block == Block.signPostPlanksOak) {
            this.yOffset = 36;
        }
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, 200 + this.yOffset, I18n.getInstance().translateKey("gui.edit_sign.button.done")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 20, 170 + this.yOffset, 20, 20, "<"));
        this.controlList.add(new GuiButton(2, this.width / 2, 170 + this.yOffset, 20, 20, ">"));
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.mc.theWorld != null && this.mc.theWorld.isClientSide) {
            this.mc.getSendQueue().addToSendQueue(new Packet130UpdateSign(this.entitySign.x, this.entitySign.y, this.entitySign.z, this.entitySign.signText, this.entitySign.getPicture().getId(), this.entitySign.getColor().id));
        }
    }

    @Override
    public void tick() {
        ++this.updateCounter;
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        int id;
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.entitySign.onInventoryChanged();
            this.mc.displayGuiScreen(null);
        }
        if (button.id == 1) {
            id = this.entitySign.getPicture().getId();
            int lastId = id - 1;
            if (lastId < 0) {
                lastId = EnumSignPicture.values().length - 1;
            }
            this.entitySign.setPicture(EnumSignPicture.values()[lastId]);
            this.entitySign.onInventoryChanged();
        }
        if (button.id == 2) {
            id = this.entitySign.getPicture().getId();
            int nextId = id + 1;
            if (nextId >= EnumSignPicture.values().length) {
                nextId = 0;
            }
            this.entitySign.setPicture(EnumSignPicture.values()[nextId]);
            this.entitySign.onInventoryChanged();
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i == 1) {
            this.entitySign.onInventoryChanged();
            this.mc.displayGuiScreen(null);
        }
        if (i == 200) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (i == 208 || i == 28 || i == 156) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (i == 14 && this.entitySign.signText[this.editLine].length() > 0) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if ((allowedCharacters.indexOf(c) >= 0 || Character.isLetterOrDigit(c)) && this.entitySign.signText[this.editLine].length() < 15) {
            int n = this.editLine;
            this.entitySign.signText[n] = this.entitySign.signText[n] + c;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.width / 2.0f), (float)0.0f, (float)50.0f);
        float scale = 93.75f;
        GL11.glScalef((float)(-scale), (float)(-scale), (float)(-scale));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Block block = this.entitySign.getBlockType();
        if (block == Block.signPostPlanksOak) {
            float signAngle = (float)(this.entitySign.getMovedData() * 360) / 16.0f;
            GL11.glRotatef((float)signAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0625f, (float)0.0f);
        } else {
            int meta = this.entitySign.getMovedData();
            float signAngle = 0.0f;
            if (meta == 2) {
                signAngle = 180.0f;
            }
            if (meta == 4) {
                signAngle = 90.0f;
            }
            if (meta == 5) {
                signAngle = -90.0f;
            }
            GL11.glRotatef((float)signAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.0625f, (float)0.0f);
        }
        if (this.updateCounter / 6 % 2 == 0) {
            this.entitySign.lineBeingEdited = this.editLine;
        }
        TileEntityRenderDispatcher.instance.renderTileEntity(Tessellator.instance, this.entitySign, -0.5, -0.75, -0.5, 0.0f);
        this.entitySign.lineBeingEdited = -1;
        GL11.glPopMatrix();
        this.drawStringCentered(this.fontRenderer, I18n.getInstance().translateKey(this.entitySign.getPicture().getLanguageKey()), this.width / 2, 150 + this.yOffset, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
    }
}

