/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.PageNavigationStack;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.util.helper.MathHelper;

public class PageManager {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private final PageNavigationStack stack = new PageNavigationStack(10);
    private GuidebookPage leftPage = null;
    private GuidebookPage rightPage = null;
    private GuidebookSection currentSection = null;
    public static SearchQuery searchQuery = null;

    public PageManager() {
        this.updatePages();
        this.setCurrentPage(0, false);
    }

    public void updatePages() {
        this.pages.clear();
        for (GuidebookSection section : GuidebookSections.getSectionList()) {
            if (section instanceof SearchableGuidebookSection && searchQuery != null) {
                this.pages.addAll(((SearchableGuidebookSection)section).searchPages(searchQuery));
                continue;
            }
            this.pages.addAll(section.getPages());
        }
        this.setCurrentPage(this.getCurrentPage(), false);
    }

    private int getCurrentPage() {
        return this.stack.getCurrentPage();
    }

    public GuidebookPage getPageByIndex(int index) {
        if (index < 0 || index >= this.getNumPages()) {
            return null;
        }
        return this.pages.get(index);
    }

    public int getPageIndex(GuidebookPage page) {
        return this.pages.indexOf(page);
    }

    public int getSectionIndex(GuidebookSection section) {
        if (section instanceof SearchableGuidebookSection && searchQuery != null) {
            List<GuidebookPage> search = ((SearchableGuidebookSection)section).searchPages(searchQuery);
            if (search != null && search.size() > 0) {
                return this.pages.indexOf(search.get(0));
            }
        } else {
            List<GuidebookPage> pages = section.getPages();
            if (pages != null && pages.size() > 0) {
                return this.pages.indexOf(pages.get(0));
            }
        }
        return -1;
    }

    public List<GuidebookPage> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public GuidebookPage getLeftPage() {
        return this.leftPage;
    }

    public GuidebookPage getRightPage() {
        return this.rightPage;
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPage() > 0;
    }

    public boolean hasNextPage() {
        if (this.getCurrentPage() % 2 == 1) {
            return this.getCurrentPage() < this.getNumPages() - 2;
        }
        return this.getCurrentPage() < this.getNumPages() - 1;
    }

    public GuidebookSection getCurrentSection() {
        return this.currentSection;
    }

    public void setCurrentPage(int index, boolean addToStack) {
        index = MathHelper.clamp(index, 0, this.getNumPages() - 1);
        GuidebookPage oldLeftPage = this.leftPage;
        GuidebookPage oldRightPage = this.rightPage;
        if (index % 2 == 0) {
            --index;
        }
        if (addToStack) {
            this.stack.pushPage(index);
        }
        this.leftPage = this.getPageByIndex(index);
        this.rightPage = this.getPageByIndex(index + 1);
        this.currentSection = this.leftPage != null ? this.leftPage.getSection() : (this.rightPage != null ? this.rightPage.getSection() : null);
        if (oldLeftPage != this.leftPage) {
            if (oldLeftPage != null) {
                oldLeftPage.onStopBeingVisible();
            }
            if (this.leftPage != null) {
                this.leftPage.onBecomeVisible();
            }
        }
        if (oldRightPage != this.rightPage) {
            if (oldRightPage != null) {
                oldRightPage.onStopBeingVisible();
            }
            if (this.rightPage != null) {
                this.rightPage.onBecomeVisible();
            }
        }
    }

    public void offsetPage(int offset) {
        this.setCurrentPage(this.getCurrentPage() + offset, true);
    }

    public void goBack() {
        this.stack.goBack();
        this.setCurrentPage(this.getCurrentPage(), false);
    }

    public void goForward() {
        this.stack.goForward();
        this.setCurrentPage(this.getCurrentPage(), false);
    }
}

