/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import com.b100.utils.interfaces.Condition;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiCrafting;
import net.minecraft.client.gui.GuiFurnace;
import net.minecraft.client.gui.GuiInventory;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.core.player.inventory.slot.Slot;

public class ControllerInventoryHandler {
    public final ControllerInput controllerInput;
    private Slot lastSlot;

    public ControllerInventoryHandler(ControllerInput controllerInput) {
        this.controllerInput = controllerInput;
    }

    public void handleAbstractCrafting(GuiContainer container, Condition<Slot> isInventorySlot, Condition<Slot> isCraftingSlot, Condition<Slot> isResultSlot, int craftingSlot, int resultSlot, int invSlot) {
        Slot slot = this.controllerInput.getSlotAtCursor(container);
        if (this.controllerInput.buttonA.pressedThisFrame()) {
            for (Slot slot2 : container.inventorySlots.inventorySlots) {
                System.out.println(slot2.id + ": " + slot2.getStack());
            }
        }
        if (slot != null && isCraftingSlot.isTrue(slot) && slot.hasStack() && this.controllerInput.buttonA.isPressed() && this.controllerInput.buttonA.getHoldTime() > 10 && this.controllerInput.buttonA.getHoldTime() % 2 == 1) {
            this.click(container, 0);
        }
        if (this.controllerInput.buttonZL.pressedThisFrame()) {
            if (slot != null) {
                if (isCraftingSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (slot != null && slot.id > 9) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, craftingSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, invSlot);
            }
        }
        if (this.controllerInput.buttonZR.pressedThisFrame()) {
            if (slot != null) {
                if (isResultSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (isInventorySlot.isTrue(slot)) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, resultSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, resultSlot);
            }
        }
    }

    public void handleCrafting(GuiCrafting crafting) {
        this.handleAbstractCrafting(crafting, e -> e.id > 9, e -> e.id > 0 && e.id < 10, e -> e.id == 0, 5, 0, 24);
    }

    public void handleInventory(GuiInventory inventory) {
        this.handleAbstractCrafting(inventory, e -> e.id >= 9 && e.id <= 44, e -> e.id >= 1 && e.id <= 4, e -> e.id == 0, 1, 0, 22);
    }

    public void handleFurnace(GuiFurnace furnace) {
        this.handleAbstractCrafting(furnace, e -> e.id >= 3 && e.id <= 38, e -> e.id >= 0 && e.id <= 1, e -> e.id == 2, 0, 2, 16);
    }

    public void click(GuiContainer guiCrafting, int button) {
        guiCrafting.mouseClicked((int)this.controllerInput.cursorX, (int)this.controllerInput.cursorY, button);
    }
}

