/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.stitcher;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.client.render.stitcher.AtlasStitcher;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;

public class TextureRegistry {
    public static HashMap<String, AtlasStitcher> stitcherMap = new HashMap();
    public static AtlasStitcher blockAtlas = TextureRegistry.register("block", new AtlasStitcher("textures/block", true, "/assets/minecraft/textures/block/texture_missing.png"));
    public static AtlasStitcher itemAtlas = TextureRegistry.register("item", new AtlasStitcher("textures/item", true, "/assets/minecraft/textures/item/texture_missing.png"));
    public static AtlasStitcher particleAtlas = TextureRegistry.register("particle", new AtlasStitcher("textures/particle", false, null));
    public static AtlasStitcher artAtlas = TextureRegistry.register("art", new AtlasStitcher("textures/art", false, null));

    @NotNull
    public static IconCoordinate getTexture(@NotNull String key) {
        return TextureRegistry.getTexture(new NamespaceID(key));
    }

    @NotNull
    public static IconCoordinate getTexture(@NotNull NamespaceID id) {
        String[] split2 = id.value.split("/");
        AtlasStitcher atlas = stitcherMap.get(split2[0]);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + split2[0] + "'!");
        }
        StringBuilder target = new StringBuilder(split2[1]);
        for (int i = 2; i < split2.length; ++i) {
            target.append("/").append(split2[i]);
        }
        return atlas.getTexture(new NamespaceID(id.namespace, target.toString()));
    }

    public static boolean hasTexture(@NotNull String key) {
        return TextureRegistry.hasTexture(new NamespaceID(key));
    }

    public static boolean hasTexture(@NotNull NamespaceID id) {
        String[] split2 = id.value.split("/");
        AtlasStitcher atlas = stitcherMap.get(split2[0]);
        if (atlas == null) {
            throw new IllegalArgumentException("Failed to find atlas '" + split2[0] + "'!");
        }
        StringBuilder target = new StringBuilder(split2[1]);
        for (int i = 2; i < split2.length; ++i) {
            target.append("/").append(split2[i]);
        }
        return atlas.textureMap.containsKey(new NamespaceID(id.namespace, target.toString()));
    }

    public static AtlasStitcher register(String id, AtlasStitcher atlas) {
        stitcherMap.put(id, atlas);
        return atlas;
    }

    protected static void initializeAllFiles(String namespace, AtlasStitcher atlas) {
        String[] files;
        String path = String.format("%s/%s/%s/", "/assets", namespace, atlas.directoryPath);
        for (String s : files = TextureRegistry.getFilesAndSubFiles(path)) {
            String name = s.replaceFirst(path, "");
            if (!name.endsWith(".png")) continue;
            atlas.getTexture(new NamespaceID(namespace, name.replace(".png", "")));
        }
    }

    public static String[] getFilesAndSubFiles(String directory) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        try {
            Path myPath;
            URI uri = TexturePack.class.getResource(directory).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                myPath = fileSystem.getPath(directory, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    File f = ((Path)it.next()).toFile();
                    if (f.isDirectory()) {
                        paths.addAll(Arrays.asList(TextureRegistry.getFilesAndSubFiles(directory + f.getName())));
                        continue;
                    }
                    paths.add(directory + f.getName());
                }
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paths.toArray(new String[0]);
    }

    static {
        try {
            for (AtlasStitcher stitcher : stitcherMap.values()) {
                TextureRegistry.initializeAllFiles("minecraft", stitcher);
            }
        }
        catch (Exception e) {
            new RuntimeException(e).printStackTrace();
            System.out.println("Failed to fully initialize assets, some issue may occur!");
        }
    }
}

