/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texturepack.Manifest;
import net.minecraft.client.render.texturepack.ManifestFallback;
import net.minecraft.client.render.texturepack.TexturePack;
import org.lwjgl.opengl.GL11;

public class TexturePackCustom
extends TexturePack {
    private int thumbnailImage = -1;
    private BufferedImage thumbnailBuffer;
    private final File file;
    private ZipFile zipFile;

    public TexturePackCustom(File file) {
        this.fileName = file.getName();
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTexturePackManifest() throws IOException {
        String line1;
        String name;
        InputStream in;
        if (this.file.isFile()) {
            ZipEntry manifestEntry = this.zipFile.getEntry("manifest.json");
            if (manifestEntry != null) {
                in = null;
                try {
                    in = this.zipFile.getInputStream(manifestEntry);
                    this.readManifest(in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                name = this.file.getName();
                line1 = "";
                String line2 = "";
                ZipEntry packTxtEntry = this.zipFile.getEntry("pack.txt");
                if (packTxtEntry != null) {
                    InputStream in2 = null;
                    BufferedReader br = null;
                    try {
                        in2 = this.zipFile.getInputStream(packTxtEntry);
                        br = new BufferedReader(new InputStreamReader(in2));
                        line1 = br.readLine();
                        line2 = br.readLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            in2.close();
                        }
                        catch (Exception e) {}
                        try {
                            br.close();
                        }
                        catch (Exception e) {}
                    }
                }
                this.manifest = new ManifestFallback(name, line1, line2, 0);
            }
        } else if (this.file.isDirectory()) {
            File manifestFile = new File(this.file, "manifest.json");
            if (manifestFile.exists()) {
                in = null;
                try {
                    in = new FileInputStream(manifestFile);
                    this.readManifest(in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                name = this.file.getName();
                line1 = "";
                String line2 = "";
                File packTxtFile = new File(this.file, "pack.txt");
                if (packTxtFile.exists()) {
                    FileInputStream in3 = null;
                    BufferedReader br = null;
                    try {
                        in3 = new FileInputStream(packTxtFile);
                        br = new BufferedReader(new InputStreamReader(in3));
                        line1 = br.readLine();
                        line2 = br.readLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            ((InputStream)in3).close();
                        }
                        catch (Exception exception) {}
                        try {
                            br.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.manifest = new ManifestFallback(name, line1, line2, 0);
            }
        }
        try (InputStream inputstream = this.getResourceAsStream("pack.png");){
            this.thumbnailBuffer = ImageIO.read(inputstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readManifest(InputStream in) {
        try {
            this.manifest = new Manifest(this.file, in);
        }
        catch (Manifest.ManifestException e) {
            this.manifest = new ManifestFallback(this.fileName, "Manifest Error: " + e.getMessage(), "", -1);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.manifest = new ManifestFallback(this.fileName, "Manifest Error", "", -1);
            e.printStackTrace();
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.thumbnailBuffer != null) {
            minecraft.renderEngine.deleteTexture(this.thumbnailImage);
        }
        this.closeTexturePackFile();
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.thumbnailBuffer != null && this.thumbnailImage < 0) {
            this.thumbnailImage = minecraft.renderEngine.allocateAndSetupTexture(this.thumbnailBuffer);
        }
        if (this.thumbnailBuffer != null) {
            minecraft.renderEngine.bindTexture(this.thumbnailImage);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/assets/minecraft/textures/gui/unknown_pack.png"));
        }
    }

    @Override
    public void readZipFile() {
        try {
            this.zipFile = new ZipFile(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeTexturePackFile() {
        try {
            this.zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zipFile = null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        block8: {
            if (this.file.isFile()) {
                String zipEntryPath = path;
                if (path.startsWith("/")) {
                    zipEntryPath = path.substring(1);
                }
                try {
                    ZipEntry zipentry = this.zipFile.getEntry(zipEntryPath);
                    if (zipentry != null) {
                        return this.zipFile.getInputStream(zipentry);
                    }
                    break block8;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            try {
                File file = new File(this.file, path);
                if (file.exists()) {
                    return Files.newInputStream(file.toPath(), new OpenOption[0]);
                }
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected String[] getFilesInDirectory(String directory) {
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (this.file.isFile()) {
            ZipEntry dirEntry = this.zipFile.getEntry(directory);
            if (dirEntry != null) {
                if (dirEntry.isDirectory()) {
                    ArrayList<String> files = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> e = this.zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().startsWith(directory)) continue;
                        files.add(entry.getName());
                    }
                    return files.toArray(new String[0]);
                }
                return new String[]{directory};
            }
            return super.getFilesInDirectory(directory);
        }
        File file = new File(this.file, directory);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    String[] fileStrings = new String[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        fileStrings[i] = directory + files[i].getName();
                    }
                    return fileStrings;
                }
                return new String[0];
            }
            return new String[]{directory};
        }
        return super.getFilesInDirectory(directory);
    }

    @Override
    public boolean hasFile(String file) {
        if (this.file.isFile()) {
            boolean h = false;
            try (ZipFile zipfile = new ZipFile(this.file);){
                h = zipfile.getEntry(file.substring(1)) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return h;
        }
        return new File(this.file, file).exists();
    }
}

