/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.player.Session;

public class StatsSyncher {
    private volatile boolean busy = false;
    private volatile Map<Stat, Integer> map1 = null;
    private volatile Map<Stat, Integer> map2 = null;
    private final StatsCounter statsCounter;
    private final File unsentStatsFile;
    private final File statsFile;
    private final File unsentStatsFileTemp;
    private final File statsFileTemp;
    private final File unsentStatsFileOld;
    private final File statsFileOld;
    private final Session session;
    private int int1 = 0;
    private int int2 = 0;

    public StatsSyncher(Session session, StatsCounter statsCounter, File statsDir) {
        this.unsentStatsFile = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.dat");
        this.statsFile = new File(statsDir, "stats_" + session.username.toLowerCase() + ".dat");
        this.unsentStatsFileOld = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.old");
        this.statsFileOld = new File(statsDir, "stats_" + session.username.toLowerCase() + ".old");
        this.unsentStatsFileTemp = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.tmp");
        this.statsFileTemp = new File(statsDir, "stats_" + session.username.toLowerCase() + ".tmp");
        if (!session.username.toLowerCase().equals(session.username)) {
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.dat", this.unsentStatsFile);
            this.renameFile(statsDir, "stats_" + session.username + ".dat", this.statsFile);
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.old", this.unsentStatsFileOld);
            this.renameFile(statsDir, "stats_" + session.username + ".old", this.statsFileOld);
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.tmp", this.unsentStatsFileTemp);
            this.renameFile(statsDir, "stats_" + session.username + ".tmp", this.statsFileTemp);
        }
        this.statsCounter = statsCounter;
        this.session = session;
        if (this.unsentStatsFile.exists()) {
            statsCounter.func_27179_a(this.readStatsFromFile(this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld));
        }
        this.func_27418_a();
    }

    private void renameFile(File file, String s, File file1) {
        File file2 = new File(file, s);
        if (file2.exists() && !file2.isDirectory() && !file1.exists()) {
            file2.renameTo(file1);
        }
    }

    private Map<Stat, Integer> readStatsFromFile(File statsFile, File tempStatsFile, File oldStatsFile) {
        if (statsFile.exists()) {
            return this.readStatsFromFile(statsFile);
        }
        if (oldStatsFile.exists()) {
            return this.readStatsFromFile(oldStatsFile);
        }
        if (tempStatsFile.exists()) {
            return this.readStatsFromFile(tempStatsFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Stat, Integer> readStatsFromFile(File statsFile) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(statsFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            Map<Stat, Integer> map = StatsCounter.func_27177_a(sb.toString());
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void saveStats(Map<Stat, Integer> map, File statsFile, File tempStatsFile, File oldStatsFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempStatsFile, false));){
            writer.print(StatsCounter.getStatFileContentString(this.session.username, "local", map));
        }
        if (oldStatsFile.exists()) {
            oldStatsFile.delete();
        }
        if (statsFile.exists()) {
            statsFile.renameTo(oldStatsFile);
        }
        tempStatsFile.renameTo(statsFile);
    }

    public void func_27418_a() {
        if (this.busy) {
            throw new IllegalStateException("Can't get stats from server while StatsSyncher is busy!");
        }
        this.int1 = 100;
        this.busy = true;
        new Thread(() -> {
            try {
                if (this.map1 != null) {
                    this.saveStats(this.map1, this.statsFile, this.statsFileTemp, this.statsFileOld);
                } else if (this.statsFile.exists()) {
                    this.map1 = this.readStatsFromFile(this.statsFile, this.statsFileTemp, this.statsFileOld);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.busy = false;
            }
        }).start();
    }

    public void func_27424_a(Map<Stat, Integer> map) {
        if (this.busy) {
            throw new IllegalStateException("Can't save stats while StatsSyncher is busy!");
        }
        this.int1 = 100;
        this.busy = true;
        new Thread(() -> {
            try {
                this.saveStats(map, this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.busy = false;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStatsFileWithMap(Map<Stat, Integer> map) {
        int i = 30;
        while (this.busy && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedexception) {
                interruptedexception.printStackTrace();
            }
        }
        this.busy = true;
        try {
            this.saveStats(map, this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.busy = false;
        }
    }

    public boolean func_27420_b() {
        return this.int1 <= 0 && !this.busy && this.map2 == null;
    }

    public void func_27425_c() {
        if (this.int1 > 0) {
            --this.int1;
        }
        if (this.int2 > 0) {
            --this.int2;
        }
        if (this.map2 != null) {
            this.statsCounter.func_27187_c(this.map2);
            this.map2 = null;
        }
        if (this.map1 != null) {
            this.statsCounter.func_27180_b(this.map1);
            this.map1 = null;
        }
    }
}

