/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityBasket;
import net.minecraft.core.block.entity.TileEntityBlastFurnace;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityNote;
import net.minecraft.core.block.entity.TileEntityRecordPlayer;
import net.minecraft.core.block.entity.TileEntitySeat;
import net.minecraft.core.block.entity.TileEntitySensor;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.block.piston.TileEntityPistonMoving;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class TileEntity {
    private static Map nameToClassMap = new HashMap();
    private static Map classToNameMap = new HashMap();
    public World worldObj;
    public int x;
    public int y;
    public int z;
    protected boolean tileEntityInvalid;

    private static void addMapping(Class class1, String s) {
        if (classToNameMap.containsKey(s)) {
            throw new IllegalArgumentException("Duplicate id: " + s);
        }
        nameToClassMap.put(s, class1);
        classToNameMap.put(class1, s);
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        String s = (String)classToNameMap.get(this.getClass());
        if (s == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.putString("id", s);
        nbttagcompound.putInt("x", this.x);
        nbttagcompound.putInt("y", this.y);
        nbttagcompound.putInt("z", this.z);
    }

    public void tick() {
    }

    public static TileEntity createAndLoadEntity(CompoundTag nbttagcompound) {
        TileEntity tileentity = null;
        try {
            Class class1 = (Class)nameToClassMap.get(nbttagcompound.getString("id"));
            if (class1 != null) {
                tileentity = (TileEntity)class1.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileentity != null) {
            tileentity.readFromNBT(nbttagcompound);
        } else {
            System.out.println("Skipping TileEntity with id " + nbttagcompound.getString("id"));
        }
        return tileentity;
    }

    public static Class<?> getClassFromID(String id) {
        return (Class)nameToClassMap.get(id);
    }

    public int getMovedData() {
        return this.worldObj.getBlockMetadata(this.x, this.y, this.z);
    }

    public void onInventoryChanged() {
        if (this.worldObj != null) {
            this.worldObj.updateTileEntityChunkAndSendToPlayer(this.x, this.y, this.z, this);
        }
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    public double getDistanceFrom(double d, double d1, double d2) {
        double d3 = (double)this.x + 0.5 - d;
        double d4 = (double)this.y + 0.5 - d1;
        double d5 = (double)this.z + 0.5 - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public Block getBlockType() {
        return Block.blocksList[this.worldObj.getBlockId(this.x, this.y, this.z)];
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    static {
        TileEntity.addMapping(TileEntityFurnace.class, "Furnace");
        TileEntity.addMapping(TileEntityChest.class, "Chest");
        TileEntity.addMapping(TileEntityRecordPlayer.class, "RecordPlayer");
        TileEntity.addMapping(TileEntityDispenser.class, "Trap");
        TileEntity.addMapping(TileEntitySign.class, "Sign");
        TileEntity.addMapping(TileEntityMobSpawner.class, "MobSpawner");
        TileEntity.addMapping(TileEntityNote.class, "Music");
        TileEntity.addMapping(TileEntityPistonMoving.class, "Piston");
        TileEntity.addMapping(TileEntityBlastFurnace.class, "BlastFurnace");
        TileEntity.addMapping(TileEntitySensor.class, "Sensor");
        TileEntity.addMapping(TileEntityTrommel.class, "Trommel");
        TileEntity.addMapping(TileEntityBasket.class, "Basket");
        TileEntity.addMapping(TileEntityFlag.class, "Flag");
        TileEntity.addMapping(TileEntitySeat.class, "Seat");
        TileEntity.addMapping(TileEntityFlowerJar.class, "FlowerJar");
        TileEntity.addMapping(TileEntityMeshGold.class, "MeshGold");
    }
}

