/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.item.ItemStack;

public class RecipeSymbol {
    private char symbol;
    private ItemStack stack;
    private String itemGroup;
    private int amount = 1;
    private List<ItemStack> override;

    public RecipeSymbol(char symbol, ItemStack stack, String itemGroup) {
        if (stack == null && (itemGroup == null || Objects.equals(itemGroup, ""))) {
            throw new NullPointerException("Null symbol!");
        }
        if (Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.symbol = symbol;
        this.stack = stack;
        this.itemGroup = itemGroup;
    }

    public RecipeSymbol(char symbol, ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("Null symbol!");
        }
        this.symbol = symbol;
        this.stack = stack;
    }

    public RecipeSymbol(char symbol, ItemStack stack, int amount) {
        if (stack == null) {
            throw new NullPointerException("Null symbol!");
        }
        this.symbol = symbol;
        this.stack = stack;
        this.amount = amount;
    }

    public RecipeSymbol(char symbol, ItemStack stack, String itemGroup, int amount) {
        if (stack == null && (itemGroup == null || Objects.equals(itemGroup, ""))) {
            throw new NullPointerException("Null symbol!");
        }
        if (itemGroup != null && !Objects.equals(itemGroup, "") && Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.symbol = symbol;
        this.stack = stack;
        this.itemGroup = itemGroup;
        this.amount = amount;
    }

    public RecipeSymbol(ItemStack stack, String itemGroup) {
        if (stack == null && (itemGroup == null || Objects.equals(itemGroup, ""))) {
            throw new NullPointerException("Null symbol!");
        }
        if (itemGroup != null && !Objects.equals(itemGroup, "") && Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.stack = stack;
        this.itemGroup = itemGroup;
    }

    public RecipeSymbol(ItemStack stack, String itemGroup, int amount) {
        if (stack == null && (itemGroup == null || Objects.equals(itemGroup, ""))) {
            throw new NullPointerException("Null symbol!");
        }
        if (itemGroup != null && !Objects.equals(itemGroup, "") && Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.stack = stack;
        this.itemGroup = itemGroup;
        this.amount = amount;
    }

    public RecipeSymbol(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("Null symbol!");
        }
        this.stack = stack;
    }

    public RecipeSymbol(ItemStack stack, int amount) {
        if (stack == null) {
            throw new NullPointerException("Null symbol!");
        }
        this.stack = stack;
        this.amount = amount;
    }

    public RecipeSymbol(String itemGroup) {
        if (itemGroup == null || Objects.equals(itemGroup, "")) {
            throw new NullPointerException("Null symbol!");
        }
        if (Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.itemGroup = itemGroup;
    }

    public RecipeSymbol(String itemGroup, int amount) {
        if (itemGroup == null || Objects.equals(itemGroup, "")) {
            throw new NullPointerException("Null symbol!");
        }
        if (Registries.ITEM_GROUPS.getItem(itemGroup) == null) {
            throw new NullPointerException("Item group '" + itemGroup + "' not found!");
        }
        this.itemGroup = itemGroup;
        this.amount = amount;
    }

    public RecipeSymbol(List<ItemStack> override) {
        if (override == null || override.isEmpty()) {
            throw new NullPointerException("Null symbol!");
        }
        this.override = override;
        this.stack = override.get(0);
    }

    public RecipeSymbol(List<ItemStack> override, int amount) {
        if (override == null || override.isEmpty()) {
            throw new NullPointerException("Null symbol!");
        }
        this.override = override;
        this.stack = override.get(0);
        this.amount = amount;
    }

    public List<ItemStack> resolve() {
        if (this.override != null) {
            return this.override.stream().peek(S -> S.copy().stackSize *= this.amount).collect(Collectors.toList());
        }
        if (this.stack != null && this.itemGroup == null) {
            ItemStack s = this.stack.copy();
            s.stackSize *= this.amount;
            return Collections.singletonList(s);
        }
        if (this.itemGroup != null && this.stack == null) {
            return Registries.ITEM_GROUPS.getItem(this.itemGroup).stream().peek(S -> S.copy().stackSize *= this.amount).collect(Collectors.toList());
        }
        if (this.itemGroup != null) {
            ArrayList list = (ArrayList)Registries.ITEM_GROUPS.getItem(this.itemGroup).stream().peek(S -> S.copy().stackSize *= this.amount).collect(Collectors.toList());
            ItemStack s = this.stack.copy();
            s.stackSize *= this.amount;
            list.add(s);
            return list;
        }
        return null;
    }

    public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        List<ItemStack> stacks = this.resolve();
        boolean foundId = false;
        boolean foundMeta = false;
        for (ItemStack resolvedStack : stacks) {
            if (resolvedStack.itemID == stack.itemID) {
                foundId = true;
            }
            if (resolvedStack.getMetadata() != -1 && resolvedStack.getMetadata() != stack.getMetadata()) continue;
            foundMeta = true;
        }
        return foundId && foundMeta;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public String getItemGroup() {
        return this.itemGroup;
    }

    public int getAmount() {
        return this.amount;
    }

    public RecipeSymbol copy() {
        return new RecipeSymbol(this.symbol, this.stack, this.itemGroup, this.amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeSymbol that = (RecipeSymbol)o;
        if (this.getSymbol() != that.getSymbol()) {
            return false;
        }
        if (this.getAmount() != that.getAmount()) {
            return false;
        }
        if (this.getStack() != null ? !this.getStack().equals(that.getStack()) : that.getStack() != null) {
            return false;
        }
        if (this.getItemGroup() != null ? !this.getItemGroup().equals(that.getItemGroup()) : that.getItemGroup() != null) {
            return false;
        }
        return Objects.equals(this.override, that.override);
    }

    public String toString() {
        if (this.stack != null && this.itemGroup == null) {
            return "symbol: " + this.amount + "x " + this.stack;
        }
        if (this.itemGroup != null && this.stack == null) {
            return "symbol: " + this.amount + "x " + this.itemGroup;
        }
        if (this.itemGroup != null) {
            return "symbol: " + this.amount + "x " + this.stack + " && " + this.itemGroup;
        }
        return "null symbol";
    }
}

