/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityLightningBolt
extends Entity {
    private int life;
    public long seed = 0L;
    private int flashes;

    public EntityLightningBolt(World world) {
        this(world, 0.0, 0.0, 0.0);
    }

    public EntityLightningBolt(World world, double x, double y, double z) {
        super(world);
        this.moveTo(x, y, z, 0.0f, 0.0f);
        this.life = 2;
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.life == 2) {
            this.world.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, this.x, this.y, this.z, "ambient.weather.thunder", 10000.0f, 0.8f + this.random.nextFloat() * 0.2f);
            this.world.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, this.x, this.y, this.z, "random.explode", 2.0f, 0.5f + this.random.nextFloat() * 0.2f);
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.remove();
            } else if (this.life < -this.random.nextInt(10)) {
                int k;
                int j;
                int i;
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                if (this.world.areBlocksLoaded(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z), 10) && this.world.getBlockId(i = MathHelper.floor_double(this.x), j = MathHelper.floor_double(this.y), k = MathHelper.floor_double(this.z)) == 0 && Block.fire.canPlaceBlockAt(this.world, i, j, k)) {
                    this.world.setBlockWithNotify(i, j, k, Block.fire.id);
                }
            }
        }
        if (this.life >= 0) {
            double radius = 3.0;
            List<Entity> list = this.world.getEntitiesWithinAABBExcludingEntity(this, AABB.getBoundingBoxFromPool(this.x - radius, this.y - radius, this.z - radius, this.x + radius, this.y + 6.0 + radius, this.z + radius));
            for (Entity entity : list) {
                entity.thunderHit(this);
            }
            this.world.lightningFlicker = 2;
        }
    }

    @Override
    protected void init() {
    }

    @Override
    public void spawnInit() {
        if (this.world.difficultySetting >= 2 && this.world.areBlocksLoaded(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z), 10)) {
            int i1;
            int k;
            int i = MathHelper.floor_double(this.x);
            if (this.world.getBlockId(i, k = MathHelper.floor_double(this.y), i1 = MathHelper.floor_double(this.z)) == 0 && Block.fire.canPlaceBlockAt(this.world, i, k, i1)) {
                this.world.setBlockWithNotify(i, k, i1, Block.fire.id);
            }
            for (int j = 0; j < 4; ++j) {
                int k1;
                int j1;
                int l = MathHelper.floor_double(this.x) + this.random.nextInt(3) - 1;
                if (this.world.getBlockId(l, j1 = MathHelper.floor_double(this.y) + this.random.nextInt(3) - 1, k1 = MathHelper.floor_double(this.z) + this.random.nextInt(3) - 1) != 0 || !Block.fire.canPlaceBlockAt(this.world, l, j1, k1)) continue;
                this.world.setBlockWithNotify(l, j1, k1, Block.fire.id);
            }
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public boolean shouldRender(Vec3d vec3d) {
        return this.life >= 0;
    }
}

