/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.World;

public class SeedCommand
extends Command {
    public SeedCommand() {
        super("seed", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        World world = null;
        if (sender instanceof PlayerCommandSender) {
            world = sender.getPlayer().world;
        }
        if (handler instanceof ServerCommandHandler && args.length > 0) {
            ServerCommandHandler server = (ServerCommandHandler)handler;
            int dim = Integer.parseInt(args[0]);
            world = server.minecraftServer.getDimensionWorld(dim);
        }
        if (world == null) {
            throw new CommandError("Must be used by a player, or a dimension must be defined!");
        }
        sender.sendMessage("Seed: " + TextFormatting.LIME + world.getRandomSeed());
        if (handler.isClient()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(String.valueOf(world.getRandomSeed())), null);
            sender.sendMessage("Copied to clipboard!");
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/seed");
        }
        sender.sendMessage("/seed <dimension>");
    }
}

