/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;

public class WeatherCommand
extends Command {
    public WeatherCommand() {
        super("weather", "w");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String weatherId;
        Weather weather;
        if (args.length == 0) {
            return false;
        }
        if (args[0].equals("list")) {
            StringBuilder weatherString = new StringBuilder();
            weatherString.append(TextFormatting.LIGHT_GRAY + "Available weathers: " + TextFormatting.WHITE);
            weatherString.append("clear");
            for (Weather weather2 : Weather.weatherList) {
                if (weather2 == null) continue;
                weatherString.append(", ");
                weatherString.append(weather2.languageKey.substring(8));
            }
            sender.sendMessage(weatherString.toString());
            return true;
        }
        World world = sender.getWorld();
        if (args[0].equals("next")) {
            world.weatherManager.skip();
            handler.sendCommandFeedback(sender, "Skipping to next weather");
            return true;
        }
        int offset = 0;
        if (args[0].equals("set")) {
            offset = 1;
        }
        if ((weather = WeatherCommand.getWeather(weatherId = args[offset], world)) == null) {
            throw new CommandError("Weather \"" + weatherId + "\" doesn't exist!");
        }
        Long duration = null;
        if (args.length > offset + 1) {
            duration = Long.parseLong(args[offset + 1]) * 20L;
        }
        Float power = null;
        if (args.length > offset + 2) {
            power = Float.valueOf(Float.parseFloat(args[offset + 2]));
        }
        if (duration != null && power != null) {
            world.weatherManager.overrideWeather(weather, duration, power.floatValue());
        } else if (duration != null) {
            world.weatherManager.overrideWeather(weather, duration);
        } else {
            world.weatherManager.overrideWeather(weather);
        }
        handler.sendCommandFeedback(sender, TextFormatting.LIGHT_GRAY + "Changing weather to " + TextFormatting.WHITE + weather.getLanguageKey().substring(8));
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/weather list");
        sender.sendMessage("/weather next");
        sender.sendMessage("/weather set <weather> [duration (sec)] [power (0.0-1.0)]");
        sender.sendMessage("/weather <weather> [duration (sec)] [power (0.0-1.0)]");
    }

    public static Weather getWeather(String string, World world) {
        try {
            return Weather.getWeather(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equalsIgnoreCase("clear")) {
                Weather weather = world.worldType.getDefaultWeather();
                if (weather == null) {
                    throw new CommandError("Dimension " + world.dimension.getTranslatedName() + " does not have a default weather!");
                }
                return weather;
            }
            return Weather.getWeatherByLanguageKey(string);
        }
    }
}

