/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet130UpdateSign
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public String[] signLines;
    public int picture;
    public int color;

    public Packet130UpdateSign() {
        this.isChunkDataPacket = true;
    }

    public Packet130UpdateSign(int x, int y, int z, String[] lines, int picture, int color) {
        this.isChunkDataPacket = true;
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        this.signLines = lines;
        this.picture = picture;
        this.color = color;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.xPosition = dis.readInt();
        this.yPosition = dis.readShort();
        this.zPosition = dis.readInt();
        this.signLines = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.signLines[i] = Packet130UpdateSign.readString(dis, 15);
        }
        this.picture = dis.readInt();
        this.color = dis.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.xPosition);
        dos.writeShort(this.yPosition);
        dos.writeInt(this.zPosition);
        for (int i = 0; i < 4; ++i) {
            Packet130UpdateSign.writeString(this.signLines[i], dos);
        }
        dos.writeInt(this.picture);
        dos.writeInt(this.color);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleUpdateSign(this);
    }

    @Override
    public int getPacketSize() {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            i += this.signLines[j].length();
        }
        i += 4;
        return i += 4;
    }
}

