/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.StringTag;
import com.mojang.nbt.Tag;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;

public class IdKeyTable {
    protected final Map<String, Integer> keyIdMap = new HashMap<String, Integer>();
    protected final Map<Integer, String> idKeyMap = new HashMap<Integer, String>();
    protected byte[] hash;

    public IdKeyTable() {
        int i;
        for (i = 0; i <= Block.highestBlockId; ++i) {
            Block block = Block.blocksList[i];
            if (block == null) continue;
            this.keyIdMap.put(block.getKey(), block.id);
            this.idKeyMap.put(block.id, block.getKey());
        }
        for (i = Block.highestBlockId + 1; i < Item.highestItemId; ++i) {
            Item item = Item.itemsList[i];
            if (item == null) continue;
            this.keyIdMap.put(item.getKey(), item.id);
        }
        this.hash = this.calculateHash();
    }

    public IdKeyTable(CompoundTag tagBlockTable) {
        ListTag tagTable = tagBlockTable.getListOrDefault("Table", null);
        if (tagTable == null) {
            throw new IllegalArgumentException("BlockKeyTable had no list!");
        }
        if (tagTable.getId() != new StringTag().getId()) {
            throw new IllegalArgumentException("BlockKeyTable.Table was not of type String!");
        }
        for (int i = 0; i < tagTable.tagCount(); ++i) {
            Tag<?> idTag = tagTable.tagAt(i);
            if (!(idTag instanceof StringTag)) continue;
            String key = (String)((StringTag)idTag).getValue();
            this.idKeyMap.put(i, key);
            this.keyIdMap.put(key, i);
        }
        this.hash = tagBlockTable.getByteArrayOrDefault("TableHash", null);
        if (this.hash == null || this.hash.length != 16) {
            System.out.println("WARNING: Block ID to Key Map has no/invalid hash code. Regenerating...");
            this.hash = this.calculateHash();
        }
    }

    public int getIDByKey(String key) {
        if (!this.keyIdMap.containsKey(key)) {
            return -1;
        }
        return this.keyIdMap.get(key);
    }

    public String getKeyById(int id) {
        if (!this.idKeyMap.containsKey(id)) {
            return null;
        }
        return this.idKeyMap.get(id);
    }

    protected byte[] calculateHash() {
        MessageDigest digest;
        StringBuilder sb = new StringBuilder();
        for (int id : this.idKeyMap.keySet()) {
            sb.append(id);
            sb.append(this.idKeyMap.get(id));
        }
        String concatenated = sb.toString();
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return digest.digest(concatenated.getBytes(StandardCharsets.UTF_8));
    }

    public CompoundTag writeToCompoundTag() {
        CompoundTag tag = new CompoundTag();
        tag.putByteArray("TableHash", this.hash);
        ListTag list = new ListTag();
        ArrayList<Integer> idList = new ArrayList<Integer>(this.idKeyMap.keySet());
        Collections.sort(idList);
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            list.addTag(new StringTag(this.idKeyMap.get(id)));
        }
        tag.putList("Table", list);
        return tag;
    }

    public static boolean areMapsIdentical(IdKeyTable mapA, IdKeyTable mapB) {
        return Arrays.equals(mapA.hash, mapB.hash);
    }
}

