/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.entity.animal.EntityCow;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;

public class ServerSkinVariantList
extends SkinVariantList {
    private static final Map<String, Integer> entitySkinCounts = new HashMap<String, Integer>();

    public static void registerSkinCount(Class<? extends Entity> entityClass, int numSkins) {
        entitySkinCounts.put(entityClass.getName(), numSkins);
    }

    @Override
    public int getNumSkinsForEntity(Class<? extends Entity> entityClass) {
        return entitySkinCounts.getOrDefault(entityClass.getName(), 1);
    }

    static {
        ServerSkinVariantList.registerSkinCount(EntityChicken.class, 4);
        ServerSkinVariantList.registerSkinCount(EntityCow.class, 4);
        ServerSkinVariantList.registerSkinCount(EntityPig.class, 5);
        ServerSkinVariantList.registerSkinCount(EntitySkeleton.class, 5);
        ServerSkinVariantList.registerSkinCount(EntitySnowman.class, 5);
        ServerSkinVariantList.registerSkinCount(EntitySpider.class, 4);
        ServerSkinVariantList.registerSkinCount(EntitySquid.class, 4);
        ServerSkinVariantList.registerSkinCount(EntityZombie.class, 16);
    }
}

