/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.util.helper.JTextAreaWriter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.GuiStatsComponent;
import net.minecraft.server.gui.ServerGuiCommandListener;
import net.minecraft.server.gui.ServerGuiFocusAdapter;
import net.minecraft.server.gui.ServerWindowAdapter;
import net.minecraft.server.player.PlayerListBox;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;

public class ServerGui
extends JComponent
implements ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    private final MinecraftServer mcServer;

    public static void initGui(MinecraftServer minecraftserver) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerGui servergui = new ServerGui(minecraftserver);
        JFrame jframe = new JFrame("Minecraft server");
        jframe.add(servergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.addWindowListener(new ServerWindowAdapter(minecraftserver));
    }

    public ServerGui(MinecraftServer minecraftserver) {
        this.mcServer = minecraftserver;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.getLogComponent(), "Center");
            this.add((Component)this.getStatsComponent(), "West");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JComponent getStatsComponent() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)new GuiStatsComponent(), "North");
        jpanel.add((Component)this.getPlayerListComponent(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent getPlayerListComponent() {
        PlayerListBox playerlistbox = new PlayerListBox(this.mcServer);
        JScrollPane jscrollpane = new JScrollPane(playerlistbox, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent getLogComponent() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JTextArea jtextarea = new JTextArea();
        Layout layout = logger.getAppender("stdout").getLayout();
        WriterAppender appender = new WriterAppender(layout, new JTextAreaWriter(jtextarea));
        logger.addAppender(appender);
        JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(new ServerGuiCommandListener(this, jtextfield));
        jtextarea.addFocusListener(new ServerGuiFocusAdapter(this));
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        return jpanel;
    }

    @Override
    public void log(String s) {
        logger.info(s);
    }

    @Override
    public String getUsername() {
        return "CONSOLE";
    }

    static MinecraftServer getMinecraftServer(ServerGui servergui) {
        return servergui.mcServer;
    }
}

