/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.SavedServerList;
import net.minecraft.core.net.ServerData;
import org.lwjgl.input.Keyboard;

public class GuiAddServer
extends GuiScreen {
    private GuiButton buttonSave;
    private GuiButton buttonCancel;
    private GuiButton buttonShowIp;
    private GuiTextField ipTextField;
    private GuiTextField serverNameTextField;
    private SavedServerList serverList;
    private boolean showIp = true;

    public GuiAddServer(GuiScreen guiscreen, SavedServerList serverList) {
        super(guiscreen);
        this.serverList = serverList;
    }

    @Override
    public void tick() {
        this.ipTextField.updateCursorCounter();
        this.serverNameTextField.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.buttonSave = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("gui.add_server.button.save"));
        this.controlList.add(this.buttonSave);
        this.buttonCancel = new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.add_server.button.cancel"));
        this.controlList.add(this.buttonCancel);
        this.serverNameTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 18, 200, 20, "", "");
        this.serverNameTextField.isFocused = true;
        this.serverNameTextField.setMaxStringLength(32);
        this.ipTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18, 200, 20, "", "");
        this.ipTextField.setMaxStringLength(128);
        this.buttonShowIp = new GuiButton(2, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18 + 20 + 4, 200, 20, this.getShowIpLabel());
        this.controlList.add(this.buttonShowIp);
        this.buttonSave.enabled = false;
    }

    private String getShowIpLabel() {
        return I18n.getInstance().translateKeyAndFormat("gui.add_server.button.show_ip", this.showIp ? I18n.getInstance().translateKey("gui.add_server.button.show_ip.on") : I18n.getInstance().translateKey("gui.add_server.button.show_ip.off"));
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 0) {
            String serverName = this.serverNameTextField.getText().trim();
            String ipText = this.ipTextField.getText().trim();
            if (serverName.isEmpty()) {
                serverName = "Minecraft Server";
            }
            this.serverList.servers.add(new ServerData(serverName, ipText, this.showIp));
            this.serverList.writeToFile();
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button.id == 2) {
            this.showIp = !this.showIp;
            this.buttonShowIp.displayString = this.getShowIpLabel();
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i != Keyboard.KEY_BACK) {
            super.keyTyped(c, i, mouseX, mouseY);
        }
        if (i == Keyboard.KEY_TAB) {
            if (!this.ipTextField.isFocused && !this.serverNameTextField.isFocused) {
                this.serverNameTextField.isFocused = true;
            } else {
                this.ipTextField.isFocused = !this.ipTextField.isFocused;
                this.serverNameTextField.isFocused = !this.serverNameTextField.isFocused;
            }
            return;
        }
        if (i == Keyboard.KEY_RETURN && this.buttonSave.enabled) {
            this.buttonPressed(this.buttonSave);
        }
        if (this.ipTextField.isFocused) {
            this.ipTextField.textboxKeyTyped(c, i);
        }
        if (this.serverNameTextField.isFocused) {
            this.serverNameTextField.textboxKeyTyped(c, i);
        }
        this.buttonSave.enabled = this.ipTextField.getText().length() > 0;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.ipTextField.mouseClicked(mouseX, mouseY, mouseButton);
        this.serverNameTextField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        I18n stringtranslate = I18n.getInstance();
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.add_server.label.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("gui.add_server.label.server_name"), this.serverNameTextField.xPosition, this.serverNameTextField.yPosition - 14, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("gui.add_server.label.ip_address"), this.ipTextField.xPosition, this.ipTextField.yPosition - 14, 0xA0A0A0);
        this.ipTextField.drawTextBox();
        this.serverNameTextField.drawTextBox();
        super.drawScreen(mouseX, mouseY, partialTick);
    }
}

