/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveFile;
import net.minecraft.core.world.type.WorldType;
import org.lwjgl.input.Keyboard;

public class GuiSelectWorld
extends GuiScreen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected String stringTitle = "Select world";
    private boolean selected = false;
    private int selectedWorld = -1;
    private List<SaveFile> saveList;
    private GuiWorldSlot worldSlotContainer;
    private String stringWorld;
    private String stringConversion;
    private boolean deleting;
    private GuiButton buttonRename;
    private GuiButton buttonSelect;
    private GuiButton buttonDelete;

    public GuiSelectWorld(GuiScreen guiscreen) {
        super(guiscreen);
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        this.stringTitle = i18n.translateKey("gui.select_world.label.title");
        this.stringWorld = i18n.translateKey("gui.select_world.label.world");
        this.stringConversion = i18n.translateKey("gui.select_world.label.must_be_converted");
        this.loadSaves();
        this.worldSlotContainer = new GuiWorldSlot();
        this.initButtons();
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        super.keyTyped(c, key, mouseX, mouseY);
        if (key == Keyboard.KEY_UP && this.selectedWorld > 0) {
            this.worldSlotContainer.selectItem(this.selectedWorld - 1, false);
        }
        if (key == Keyboard.KEY_DOWN && this.selectedWorld < this.saveList.size() - 1) {
            this.worldSlotContainer.selectItem(this.selectedWorld + 1, false);
        }
        if (key == Keyboard.KEY_DELETE) {
            this.tryDeleteWorld(Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown((int)Keyboard.KEY_RSHIFT));
        }
    }

    private void loadSaves() {
        ISaveFormat isaveformat = this.mc.getSaveFormat();
        this.saveList = isaveformat.getSaveFileList();
        Collections.sort(this.saveList);
        if (this.selectedWorld >= this.saveList.size()) {
            this.selectedWorld = -1;
        }
    }

    protected String getSaveFileName(int i) {
        return this.saveList.get(i).getFileName();
    }

    protected String getSaveName(int i) {
        String s = this.saveList.get(i).getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            I18n i18n = I18n.getInstance();
            s = i18n.translateKeyAndFormat(this.stringWorld, i + 1);
        }
        return s;
    }

    public void initButtons() {
        I18n i18n = I18n.getInstance();
        this.buttonSelect = new GuiButton(1, this.width / 2 - 154, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.play_selected_world"));
        this.controlList.add(this.buttonSelect);
        this.buttonRename = new GuiButton(6, this.width / 2 - 154, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.rename"));
        this.controlList.add(this.buttonRename);
        this.buttonDelete = new GuiButton(2, this.width / 2 - 74, this.height - 28, 70, 20, i18n.translateKey("gui.select_world.button.delete"));
        this.controlList.add(this.buttonDelete);
        this.controlList.add(new GuiButton(3, this.width / 2 + 4, this.height - 52, 150, 20, i18n.translateKey("gui.select_world.button.create_new_world")));
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.select_world.button.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonDelete.enabled = false;
    }

    public void deletePresetWorld(String name) {
        for (int i = 0; i < this.saveList.size(); ++i) {
            SaveFile save = this.saveList.get(i);
            if (!save.getDisplayName().equals(name)) continue;
            this.deleting = true;
            this.deleteWorld(true, i);
            --i;
        }
    }

    void tryDeleteWorld(boolean skipConfirm) {
        if (this.selectedWorld < 0 || this.selectedWorld >= this.saveList.size()) {
            return;
        }
        String s = this.getSaveName(this.selectedWorld);
        if (s != null) {
            this.deleting = true;
            if (skipConfirm) {
                this.deleteWorld(true, this.selectedWorld);
            } else {
                I18n i18n = I18n.getInstance();
                GuiPopup popup = new PopupBuilder(this, 250).closeOnEsc(0).withLabel("gui.select_world.label.delete_title").withLabel("gui.select_world.label.delete_confirm.1").withLabelLiteral(i18n.translateKeyAndFormat("gui.select_world.label.delete_confirm.2", s)).withLabelLiteral("").withButtonGroup("endButtons", new String[]{"gui.select_world.button.delete", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                    if (statusCode == 1) {
                        this.deleteWorld(true, this.selectedWorld);
                    }
                }).build();
                this.mc.displayGuiScreen(popup);
            }
        }
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 2) {
            this.tryDeleteWorld(false);
        } else if (button.id == 1) {
            this.selectWorld(this.selectedWorld);
        } else if (button.id == 3) {
            this.mc.displayGuiScreen(new GuiCreateWorld(this));
        } else if (button.id == 6) {
            I18n i18n = I18n.getInstance();
            GuiPopup popup = new PopupBuilder(this, 140).closeOnEsc(0).closeOnEnter(1).withLabel("gui.select_world.label.rename_title").withLabel("gui.select_world.label.world_name").withTextField("nameField", this.getSaveName(this.selectedWorld)).withButtonGroup("endButtons", new String[]{"gui.select_world.button.rename", "gui.select_world.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    String text = (String)results.get("nameField");
                    ISaveFormat format = this.mc.getSaveFormat();
                    format.renameWorld(this.getSaveFileName(this.selectedWorld), text);
                    this.loadSaves();
                }
            }).build();
            this.mc.displayGuiScreen(popup);
        } else if (button.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    public void selectWorld(int i) {
        SaveFile save = this.saveList.get(i);
        if (save.isCorrupted()) {
            return;
        }
        if (save.getNeedsConversion()) {
            // empty if block
        }
        this.mc.displayGuiScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.mc.playerController = new PlayerControllerSP(this.mc);
        String s = this.getSaveFileName(i);
        if (s == null) {
            s = "World" + i;
        }
        this.mc.startWorld(s, this.getSaveName(i), 0L);
        this.mc.displayGuiScreen(null);
    }

    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                ISaveFormat isaveformat = this.mc.getSaveFormat();
                isaveformat.flushCache();
                isaveformat.deleteSave(this.getSaveFileName(i));
                this.loadSaves();
                this.selectedWorld = -1;
            }
            this.mc.displayGuiScreen(this);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.worldSlotContainer.render(mouseX, mouseY, partialTick);
        this.drawStringCentered(this.fontRenderer, this.stringTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    class GuiWorldSlot
    extends ScrolledSelectionList {
        public GuiWorldSlot() {
            super(GuiSelectWorld.this.mc, GuiSelectWorld.this.width, GuiSelectWorld.this.height, 32, GuiSelectWorld.this.height - 64, 36);
        }

        @Override
        protected int getItemCount() {
            return GuiSelectWorld.this.saveList.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
            GuiSelectWorld.this.selectedWorld = itemIndex;
            boolean flag1 = GuiSelectWorld.this.selectedWorld >= 0 && GuiSelectWorld.this.selectedWorld < this.getItemCount();
            boolean corrupted = GuiSelectWorld.this.saveList.get(itemIndex) == null || ((SaveFile)GuiSelectWorld.this.saveList.get(itemIndex)).isCorrupted();
            ((GuiSelectWorld)GuiSelectWorld.this).buttonSelect.enabled = flag1 && !corrupted;
            ((GuiSelectWorld)GuiSelectWorld.this).buttonRename.enabled = flag1 && !corrupted;
            ((GuiSelectWorld)GuiSelectWorld.this).buttonDelete.enabled = flag1;
            if (doubleClicked && flag1) {
                GuiSelectWorld.this.selectWorld(itemIndex);
            }
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return itemIndex == GuiSelectWorld.this.selectedWorld;
        }

        @Override
        protected int getMaxPosition() {
            return GuiSelectWorld.this.saveList.size() * 36;
        }

        @Override
        protected void renderHoleBackground() {
            GuiSelectWorld.this.drawDefaultBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            I18n i18n = I18n.getInstance();
            SaveFile saveFile = (SaveFile)GuiSelectWorld.this.saveList.get(index);
            String s = saveFile.getDisplayName();
            if (saveFile.isCorrupted()) {
                s = TextFormatting.RED + s;
            }
            if (s == null || MathHelper.stringNullOrLengthZero(s)) {
                s = i18n.translateKeyAndFormat(GuiSelectWorld.this.stringWorld, index + 1);
            }
            String s1 = saveFile.getFileName();
            s1 = s1 + " (" + GuiSelectWorld.this.dateFormatter.format(new Date(saveFile.getLastTimePlayed()));
            long l1 = saveFile.getSizeOnDisk();
            s1 = s1 + ", " + (float)(l1 / 1024L * 100L / 1024L) / 100.0f + " MB)";
            String s2 = "";
            if (saveFile.getNeedsConversion()) {
                s2 = GuiSelectWorld.this.stringConversion + " " + s2;
            } else {
                I18n st = I18n.getInstance();
                LevelData ld = saveFile.getLevelData();
                DimensionData dd = saveFile.getDimensionData()[0];
                if (dd == null) {
                    s2 = s2 + TextFormatting.RED + st.translateKey("gui.select_world.label.dimension_corrupted");
                } else {
                    WorldType worldType;
                    s2 = s2 + st.translateNameKey(Gamemode.gamemodesList[ld.getGamemode()].getLanguageKey());
                    if (ld.getCheatsEnabled()) {
                        s2 = s2 + " | " + st.translateKey("gui.select_world.label.cheats");
                    }
                    s2 = (worldType = dd.getWorldType()) != null ? s2 + " | " + st.translateNameKey(dd.getWorldType().getLanguageKey()) : s2 + " | " + TextFormatting.RED + st.translateKey("gui.select_world.label.unknown");
                }
            }
            GuiSelectWorld.this.drawString(GuiSelectWorld.this.fontRenderer, s, x + 2, y + 1, 0xFFFFFF);
            GuiSelectWorld.this.drawString(GuiSelectWorld.this.fontRenderer, s1, x + 2, y + 12, 0x808080);
            GuiSelectWorld.this.drawString(GuiSelectWorld.this.fontRenderer, s2, x + 2, y + 12 + 10, 0x808080);
        }
    }
}

