/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStats
extends GuiScreen {
    private static final int STATS_ICON_SIZE = 18;
    private static final int COLUMN_BUTTON_SIZE = 36;
    private static final int COLUMN0_RIGHT = 115;
    private static final int COLUMN1_RIGHT = 165;
    private static final int COLUMN2_RIGHT = 215;
    protected GuiScreen parent;
    protected GuiTooltip tooltip;
    protected String title = I18n.getInstance().translateKey("gui.statistics.label.title");
    private GeneralStatisticsList generalStatisticsList;
    private ItemStatisticsList itemStatisticsList;
    private BlockStatisticsList blockStatisticsList;
    private final StatsCounter statsCounter;
    private ScrolledSelectionList selectionList = null;

    public GuiStats(GuiScreen parent, StatsCounter statsCounter) {
        this.parent = parent;
        this.statsCounter = statsCounter;
        this.tooltip = new GuiTooltip(Minecraft.getMinecraft(this));
    }

    @Override
    public void init() {
        this.generalStatisticsList = new GeneralStatisticsList();
        this.itemStatisticsList = new ItemStatisticsList();
        this.blockStatisticsList = new BlockStatisticsList();
        this.selectionList = this.generalStatisticsList;
        this.createButtons();
    }

    public void createButtons() {
        I18n i18n = I18n.getInstance();
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.statistics.button.done")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 154, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.general")));
        GuiButton guibutton = new GuiButton(2, this.width / 2 - 46, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.blocks"));
        this.controlList.add(guibutton);
        GuiButton guibutton1 = new GuiButton(3, this.width / 2 + 62, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.items"));
        this.controlList.add(guibutton1);
        if (this.blockStatisticsList.getItemCount() == 0) {
            guibutton.enabled = false;
        }
        if (this.itemStatisticsList.getItemCount() == 0) {
            guibutton1.enabled = false;
        }
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.displayGuiScreen(this.parent);
        } else if (button.id == 1) {
            this.selectionList = this.generalStatisticsList;
        } else if (button.id == 3) {
            this.selectionList = this.itemStatisticsList;
        } else if (button.id == 2) {
            this.selectionList = this.blockStatisticsList;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.selectionList.render(mouseX, mouseY, partialTick);
        this.drawStringCentered(this.fontRenderer, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    private void renderItemAsIcon(int x, int y, int itemID) {
        this.renderBackgroundIcon(x + 1, y + 1);
        GL11.glEnable((int)32826);
        Lighting.enableInventoryLight();
        Item item = Item.itemsList[itemID];
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).renderItemIntoGui(Tessellator.instance, this.fontRenderer, this.mc.renderEngine, item.getDefaultStack(), x + 2, y + 2, 1.0f);
        Lighting.disable();
        GL11.glDisable((int)32826);
    }

    private void renderBackgroundIcon(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawGuiIcon(x, y, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot"));
    }

    class GeneralStatisticsList
    extends ScrolledSelectionList {
        public GeneralStatisticsList() {
            super(GuiStats.this.mc, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 10);
            this.setRenderSelection(false);
        }

        @Override
        protected int getItemCount() {
            return StatList.basicStats.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected int getMaxPosition() {
            return this.getItemCount() * 10;
        }

        @Override
        protected void renderHoleBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            Stat stat = StatList.basicStats.get(index);
            GuiStats.this.drawString(GuiStats.this.fontRenderer, stat.getStatName(), x + 2, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
            String s = stat.getFormattedValue(GuiStats.this.statsCounter.readStat(stat));
            GuiStats.this.drawString(GuiStats.this.fontRenderer, s, x + 2 + 213 - GuiStats.this.fontRenderer.getStringWidth(s), y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
        }
    }

    public class ItemStatisticsList
    extends StatsSelectionList {
        public ItemStatisticsList() {
            this.statsList = new ArrayList();
            for (Stat stat : StatList.usedItemStats) {
                StatItem statItem = (StatItem)stat;
                boolean flag = false;
                int i = statItem.getItemID();
                Stat broken = statItem.getItem().getStat("stat_broken");
                Stat crafted = statItem.getItem().getStat("stat_crafted");
                if (GuiStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (broken != null && GuiStats.this.statsCounter.readStat(broken) > 0) {
                    flag = true;
                } else if (crafted != null && GuiStats.this.statsCounter.readStat(crafted) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.statsList.add(statItem);
            }
            this.statsSorter = (stat1, stat2) -> {
                int id1 = stat1.getItemID();
                int id2 = stat2.getItemID();
                Stat statbase1 = null;
                Stat statbase2 = null;
                if (this.sortingColumn == 0) {
                    statbase1 = stat1.getItem().getStat("stat_broken");
                    statbase2 = stat2.getItem().getStat("stat_broken");
                } else if (this.sortingColumn == 1) {
                    statbase1 = stat1.getItem().getStat("stat_crafted");
                    statbase2 = stat2.getItem().getStat("stat_crafted");
                } else if (this.sortingColumn == 2) {
                    statbase1 = stat1.getItem().getStat("stat_used");
                    statbase2 = stat2.getItem().getStat("stat_used");
                }
                if (statbase1 != null || statbase2 != null) {
                    int l;
                    if (statbase1 == null) {
                        return 1;
                    }
                    if (statbase2 == null) {
                        return -1;
                    }
                    int k = GuiStats.this.statsCounter.readStat(statbase1);
                    if (k != (l = GuiStats.this.statsCounter.readStat(statbase2))) {
                        return (k - l) * this.sortingMode;
                    }
                }
                return id1 - id2;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.clickedColumn == 0) {
                GuiStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/depleted"));
            } else {
                GuiStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/depleted"));
            }
            if (this.clickedColumn == 1) {
                GuiStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/crafted"));
            } else {
                GuiStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/crafted"));
            }
            if (this.clickedColumn == 2) {
                GuiStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/used"));
            } else {
                GuiStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/used"));
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statItem = this.getStat(index);
            int i1 = statItem.getItemID();
            GuiStats.this.renderItemAsIcon(x + 40, y, i1);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_broken"), x + 115, y, index % 2 == 0);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_crafted"), x + 165, y, index % 2 == 0);
            this.renderStatValue(statItem, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String getTooltipKey(int column) {
            if (column == 1) {
                return "stat.crafted";
            }
            if (column == 2) {
                return "stat.used";
            }
            return "stat.depleted";
        }
    }

    public class BlockStatisticsList
    extends StatsSelectionList {
        public BlockStatisticsList() {
            this.statsList = new ArrayList();
            for (Stat stat : Objects.requireNonNull(Item.getStats("stat_mined"))) {
                StatItem statItem = (StatItem)stat;
                boolean flag = false;
                Stat used = statItem.getItem().getStat("stat_used");
                Stat crafted = statItem.getItem().getStat("stat_crafted");
                if (GuiStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (used != null && GuiStats.this.statsCounter.readStat(used) > 0) {
                    flag = true;
                } else if (crafted != null && GuiStats.this.statsCounter.readStat(crafted) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.statsList.add(statItem);
            }
            this.statsSorter = (stat1, stat2) -> {
                int id1 = stat1.getItemID();
                int id2 = stat2.getItemID();
                Stat statbase1 = null;
                Stat statbase2 = null;
                if (this.sortingColumn == 2) {
                    statbase1 = stat1.getItem().getStat("stat_mined");
                    statbase2 = stat2.getItem().getStat("stat_mined");
                } else if (this.sortingColumn == 0) {
                    statbase1 = stat1.getItem().getStat("stat_crafted");
                    statbase2 = stat2.getItem().getStat("stat_crafted");
                } else if (this.sortingColumn == 1) {
                    statbase1 = stat1.getItem().getStat("stat_used");
                    statbase2 = stat2.getItem().getStat("stat_used");
                }
                if (statbase1 != null || statbase2 != null) {
                    int l;
                    if (statbase1 == null) {
                        return 1;
                    }
                    if (statbase2 == null) {
                        return -1;
                    }
                    int k = GuiStats.this.statsCounter.readStat(statbase1);
                    if (k != (l = GuiStats.this.statsCounter.readStat(statbase2))) {
                        return (k - l) * this.sortingMode;
                    }
                }
                return id1 - id2;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.clickedColumn == 0) {
                GuiStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/crafted"));
            } else {
                GuiStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/crafted"));
            }
            if (this.clickedColumn == 1) {
                GuiStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/used"));
            } else {
                GuiStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/used"));
            }
            if (this.clickedColumn == 2) {
                GuiStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/mined"));
            } else {
                GuiStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/mined"));
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statItem = this.getStat(index);
            int id = statItem.getItem().id;
            GuiStats.this.renderItemAsIcon(x + 40, y, id);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_crafted"), x + 115, y, index % 2 == 0);
            this.renderStatValue((StatItem)statItem.getItem().getStat("stat_used"), x + 165, y, index % 2 == 0);
            this.renderStatValue(statItem, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String getTooltipKey(int column) {
            if (column == 0) {
                return "stat.crafted";
            }
            if (column == 1) {
                return "stat.used";
            }
            return "stat.mined";
        }
    }

    abstract class StatsSelectionList
    extends ScrolledSelectionList {
        protected int clickedColumn;
        protected List<StatItem> statsList;
        protected Comparator<StatItem> statsSorter;
        public int sortingColumn;
        public int sortingMode;

        protected StatsSelectionList() {
            super(GuiStats.this.mc, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 20);
            this.clickedColumn = -1;
            this.sortingColumn = -1;
            this.sortingMode = 0;
            this.setRenderSelection(false);
            this.setRenderHeader(true, 20);
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected void renderHoleBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            if (!Mouse.isButtonDown((int)0)) {
                this.clickedColumn = -1;
            }
            if (this.clickedColumn == 0) {
                GuiStats.this.drawGuiIcon(x + 115 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot"));
            } else {
                GuiStats.this.drawGuiIcon(x + 115 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot_raised"));
            }
            if (this.clickedColumn == 1) {
                GuiStats.this.drawGuiIcon(x + 165 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot"));
            } else {
                GuiStats.this.drawGuiIcon(x + 165 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot_raised"));
            }
            if (this.clickedColumn == 2) {
                GuiStats.this.drawGuiIcon(x + 215 - 18 + 1, y + 2, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot"));
            } else {
                GuiStats.this.drawGuiIcon(x + 215 - 18, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/slot_raised"));
            }
            if (this.sortingColumn != -1) {
                int c = 79;
                boolean up = false;
                if (this.sortingColumn == 1) {
                    c = 129;
                } else if (this.sortingColumn == 2) {
                    c = 179;
                }
                if (this.sortingMode == 1) {
                    up = true;
                }
                GuiStats.this.drawGuiIcon(x + c, y + 1, 18, 18, TextureRegistry.getTexture("minecraft:gui/arrow_" + (up ? "up" : "down")));
            }
        }

        @Override
        protected void clickedHeader(int x, int y) {
            this.clickedColumn = -1;
            if (x >= 79 && x < 115) {
                this.clickedColumn = 0;
            } else if (x >= 129 && x < 165) {
                this.clickedColumn = 1;
            } else if (x >= 179 && x < 215) {
                this.clickedColumn = 2;
            }
            if (this.clickedColumn >= 0) {
                this.clickedColumn(this.clickedColumn);
                GuiStats.this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            }
        }

        @Override
        protected final int getItemCount() {
            return this.statsList.size();
        }

        protected final StatItem getStat(int index) {
            return this.statsList.get(index);
        }

        protected abstract String getTooltipKey(int var1);

        protected void renderStatValue(StatItem statItem, int x, int y, boolean white) {
            if (statItem != null) {
                String s = statItem.getFormattedValue(GuiStats.this.statsCounter.readStat(statItem));
                GuiStats.this.drawString(GuiStats.this.fontRenderer, s, x - GuiStats.this.fontRenderer.getStringWidth(s), y + 5, white ? 0xFFFFFF : 0x909090);
            } else {
                String s1 = "-";
                GuiStats.this.drawString(GuiStats.this.fontRenderer, s1, x - GuiStats.this.fontRenderer.getStringWidth(s1), y + 5, white ? 0xFFFFFF : 0x909090);
            }
        }

        @Override
        protected void renderDecorations(int x, int y) {
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            if (y < this.y0 || y > this.y1) {
                return;
            }
            int row = this.getItemAtPosition(x, y);
            int statsListLeft = GuiStats.this.width / 2 - 92 - 16;
            if (row >= 0) {
                if (x < statsListLeft + 40 || x > statsListLeft + 40 + 20) {
                    return;
                }
                StatItem statItem = this.getStat(row);
                this.renderStatItemTooltip(statItem, x, y);
            } else {
                String s;
                if (x >= statsListLeft + 115 - 18 && x <= statsListLeft + 115) {
                    s = this.getTooltipKey(0);
                } else if (x >= statsListLeft + 165 - 18 && x <= statsListLeft + 165) {
                    s = this.getTooltipKey(1);
                } else if (x >= statsListLeft + 215 - 18 && x <= statsListLeft + 215) {
                    s = this.getTooltipKey(2);
                } else {
                    return;
                }
                s = I18n.getInstance().translateKey(s).trim();
                GuiStats.this.tooltip.render(s, x, y, 8, -8);
            }
        }

        protected void renderStatItemTooltip(StatItem statItem, int x, int y) {
            if (statItem == null) {
                return;
            }
            Item item = statItem.getItem();
            String s = I18n.getInstance().translateNameKey(item.getKey()).trim();
            GuiStats.this.tooltip.render(s, x, y, 8, -8);
        }

        protected void clickedColumn(int column) {
            if (column != this.sortingColumn) {
                this.sortingColumn = column;
                this.sortingMode = -1;
            } else if (this.sortingMode == -1) {
                this.sortingMode = 1;
            } else {
                this.sortingColumn = -1;
                this.sortingMode = 0;
            }
            this.statsList.sort(this.statsSorter);
        }
    }
}

