/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.smelting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.GuidebookSlot;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class BlastSmeltingPage
extends RecipePage<RecipeEntryBlastFurnace> {
    public static final int RECIPES_PER_PAGE = 6;
    public List<GuidebookSlot> slots;
    public Map<RecipeEntryBlastFurnace, List<GuidebookSlot>> map;
    private final GuiTooltip guiTooltip;
    private final GuiRenderItem guiRenderItem;
    private static final Minecraft mc = Minecraft.getMinecraft(GuidebookPage.class);
    private static Player player;
    private static long ticks;

    public BlastSmeltingPage(GuidebookSection section, ArrayList<RecipeEntryBlastFurnace> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<GuidebookSlot>();
        this.map = new HashMap<RecipeEntryBlastFurnace, List<GuidebookSlot>>();
        player = BlastSmeltingPage.mc.thePlayer;
        player.addStat(Achievements.OPEN_GUIDEBOOK, 1);
        this.guiTooltip = new GuiTooltip(mc);
        this.guiRenderItem = new GuiRenderItem(mc);
        for (RecipeEntryBlastFurnace recipe : recipes) {
            ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
            recipeSlots.add(new GuidebookSlot(0, 47, 32 * (this.map.size() + 1) - 16, (RecipeSymbol)recipe.getInput(), false, recipe));
            recipeSlots.add(new GuidebookSlot(1, 103, 32 * (this.map.size() + 1) - 16, new RecipeSymbol((ItemStack)recipe.getOutput()), false, recipe));
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
        }
    }

    @Override
    protected void renderForeground(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, "No recipes found :(", x + 79, y + 110, -8355712);
        }
        GuidebookSlot mouseOverSlot = null;
        ++ticks;
        for (GuidebookSlot slot : this.slots) {
            if (ticks > 150L) {
                slot.showRandomItem();
                if (this.slots.get(this.slots.size() - 1) == slot) {
                    ticks = 0L;
                }
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.guiRenderItem.render(slot.getItem(), x + slot.x, y + slot.y, mouseOverSlot == slot, slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    @Override
    public void keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (BlastSmeltingPage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuiGuidebook.getPageManager().updatePages();
                GuiGuidebook.getPageManager().setCurrentPage(GuiGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        } else if (BlastSmeltingPage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuiGuidebook.getPageManager().updatePages();
                GuiGuidebook.getPageManager().setCurrentPage(GuiGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        }
    }

    @Override
    public void render(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBackground(RenderEngine re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryBlastFurnace recipe = (RecipeEntryBlastFurnace)this.recipes.get(i - 1);
            List<GuidebookSlot> list = this.map.get(recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x - 32, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    @Override
    protected void renderOverlay(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        GuidebookSlot mouseOverSlot = null;
        for (GuidebookSlot slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL) || (Boolean)BlastSmeltingPage.mc.gameSettings.alwaysShowDescriptions.value != false;
            String str = this.guiTooltip.getTooltipText(mouseOverSlot.getItem(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            this.guiTooltip.render(str, mouseX, mouseY, 8, -8);
        }
    }

    static {
        ticks = 0L;
    }
}

