/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import org.lwjgl.opengl.GL11;

public class FireBarComponent
extends MovableHudComponent {
    public FireBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.playerController.canHurtPlayer() && !mc.thePlayer.getGamemode().isPlayerInvulnerable() && mc.thePlayer.remainingFireTicks > 0;
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        float fire = (float)mc.thePlayer.remainingFireTicks / (float)mc.thePlayer.maxFireTicks;
        int fireBar = (int)Math.min(fire * 20.0f, 20.0f);
        for (int i = 0; i < fireBar / 2; ++i) {
            gui.drawGuiIcon(x + i * 8, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/fire"));
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        int fireBar = 11;
        for (int i = 0; i < fireBar / 2; ++i) {
            gui.drawGuiIcon(x + i * 8, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/fire"));
        }
    }
}

