/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import net.minecraft.client.input.controller.Button;
import net.minecraft.client.input.controller.IJoystickListener;
import net.minecraft.client.option.FloatOption;

public class Joystick {
    public int xAxis;
    public int yAxis;
    public IJoystickListener joystickListener;
    public final String name;
    public final Button button;
    private FloatOption deadzone;
    private float x;
    private float y;
    private boolean moving = false;
    private boolean moveLastFrame = false;

    public Joystick(String name, int xAxis, int yAxis, IJoystickListener joystickListener, Button button, FloatOption deadzone) {
        this.name = name;
        this.deadzone = deadzone;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.joystickListener = joystickListener;
        this.button = button;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Button getButton() {
        return this.button;
    }

    public void update() {
        boolean yInDeadzone;
        this.button.update();
        float x = this.joystickListener.getValue(this.xAxis);
        float y = this.joystickListener.getValue(this.yAxis);
        boolean xInDeadzone = x < ((Float)this.deadzone.value).floatValue() && x > -((Float)this.deadzone.value).floatValue();
        boolean bl = yInDeadzone = y < ((Float)this.deadzone.value).floatValue() && y > -((Float)this.deadzone.value).floatValue();
        if (xInDeadzone) {
            x = 0.0f;
        }
        if (yInDeadzone) {
            y = 0.0f;
        }
        this.x = x;
        this.y = y;
        this.moveLastFrame = this.moving;
        this.moving = !xInDeadzone || !yInDeadzone;
    }

    public boolean stoppedMoving() {
        return this.moveLastFrame && !this.moving;
    }
}

