/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.glfw;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.input.glfw.GlfwGamepad;
import org.lwjgl.glfw.GLFW;

public class GlfwJoystick {
    private final int id;
    private FloatBuffer axes = null;
    private ByteBuffer buttons = null;
    private ByteBuffer hats = null;
    private GlfwGamepad gamepad = null;

    public GlfwJoystick(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void poll() {
        this.axes = GLFW.glfwGetJoystickAxes((int)this.id);
        this.buttons = GLFW.glfwGetJoystickButtons((int)this.id);
        this.hats = GLFW.glfwGetJoystickHats((int)this.id);
    }

    public boolean isPresent() {
        return GLFW.glfwJoystickPresent((int)this.id);
    }

    public String getName() {
        return GLFW.glfwGetJoystickName((int)this.id);
    }

    public float getAxisValue(int axis) {
        if (this.isPresent() && this.axes != null && axis >= 0 && axis < this.axes.capacity()) {
            return this.axes.get(axis);
        }
        return 0.0f;
    }

    public boolean isButtonPressed(int button) {
        if (this.isPresent() && this.buttons != null && button >= 0 && button < this.buttons.capacity()) {
            return this.buttons.get(button) == 1;
        }
        return false;
    }

    public int getHatValue(int hat) {
        if (this.isPresent() && this.hats != null && hat >= 0 && hat < this.hats.capacity()) {
            return this.hats.get(hat);
        }
        return 0;
    }

    public GlfwGamepad intoGamepad() {
        if (this.gamepad == null && this.isPresent() && GLFW.glfwJoystickIsGamepad((int)this.id)) {
            this.gamepad = new GlfwGamepad(this.id);
        }
        return this.gamepad;
    }
}

