/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.MultiplayerLocalPlayer;
import net.minecraft.client.net.handler.ClientPacketHandler;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.ContainerClickPacket;
import net.minecraft.core.net.packet.InteractPacket;
import net.minecraft.core.net.packet.PlayerActionPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetPaintingArtPacket;
import net.minecraft.core.net.packet.UseItemPacket;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PlayerControllerMP
extends PlayerController {
    protected ClientPacketHandler netHandler;
    protected int currentItem;

    public PlayerControllerMP(Minecraft minecraft, ClientPacketHandler netHandler) {
        super(minecraft);
        this.netHandler = netHandler;
    }

    @Override
    public boolean destroyBlock(int x, int y, int z, Side side, Player player) {
        int id = this.mc.theWorld.getBlockId(x, y, z);
        boolean removed = super.destroyBlock(x, y, z, side, player);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(this.mc.theWorld, id, x, y, z, side, this.mc.thePlayer);
            if (item.stackSize <= 0) {
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return removed;
    }

    @Override
    protected void hitBlock(int x, int y, int z, Side side, double xHit, double yHit) {
        super.hitBlock(x, y, z, side, xHit, yHit);
        this.netHandler.addToSendQueue(new PlayerActionPacket(1, x, y, z, side, xHit, yHit));
    }

    @Override
    public void sendStartDigPacket(int x, int y, int z, Side side, double xHit, double yHit) {
        this.netHandler.addToSendQueue(new PlayerActionPacket(0, x, y, z, side, xHit, yHit));
    }

    @Override
    public void sendDestroyBlockPacket(int x, int y, int z, Side side, double xHit, double yHit) {
        this.netHandler.addToSendQueue(new PlayerActionPacket(2, x, y, z, side, xHit, yHit));
    }

    @Override
    protected void syncCurrentPlayItem() {
        int i = this.mc.thePlayer.inventory.currentItem;
        if (i != this.currentItem) {
            this.currentItem = i;
            this.netHandler.addToSendQueue(new SetCarriedItemPacket(this.currentItem));
        }
    }

    @Override
    public boolean useItemOn(Player entityplayer, World world, ItemStack itemstack, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new UseItemPacket(blockX, blockY, blockZ, side.getDirection(), entityplayer.inventory.getCurrentItem(), xPlaced, yPlaced));
        boolean flag = super.useItemOn(entityplayer, world, itemstack, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        return flag;
    }

    @Override
    public boolean useItem(Player entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new UseItemPacket(-1, -1, -1, Direction.NONE, entityplayer.inventory.getCurrentItem(), 0.0, 0.0));
        boolean flag = super.useItem(entityplayer, world, itemstack);
        return flag;
    }

    @Override
    public Player createPlayer(World world) {
        return new MultiplayerLocalPlayer(this.mc, world, this.mc.session, this.netHandler);
    }

    @Override
    public void attack(Player entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new InteractPacket(entityplayer.id, entity.id, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    @Override
    public boolean interact(Player entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new InteractPacket(entityplayer.id, entity.id, 0));
        return entityplayer.useCurrentItemOnEntity(entity);
    }

    @Override
    public ItemStack handleInventoryMouseClick(int windowId, InventoryAction action, int[] args, Player entityplayer) {
        short actionId = entityplayer.craftingInventory.backup(entityplayer.inventory);
        ItemStack itemstack = super.handleInventoryMouseClick(windowId, action, args, entityplayer);
        this.netHandler.addToSendQueue(new ContainerClickPacket(windowId, action, args, itemstack, actionId));
        return itemstack;
    }

    @Override
    public void handleCloseInventory(int i, Player entityplayer) {
        if (i == -9999) {
            // empty if block
        }
    }

    @Override
    public void setPaintingType(ArtType art) {
        this.netHandler.addToSendQueue(new SetPaintingArtPacket(art));
    }
}

