/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Comparator;
import net.minecraft.client.render.ChunkRenderer;
import net.minecraft.client.render.camera.ICamera;

public class CameraSorter
implements Comparator<ChunkRenderer> {
    private final double posX;
    private final double posY;
    private final double posZ;

    public CameraSorter(ICamera camera) {
        this.posX = -camera.getX();
        this.posY = -camera.getY();
        this.posZ = -camera.getZ();
    }

    public int sortByDistanceToEntity(ChunkRenderer a, ChunkRenderer b) {
        double dx1 = (double)a.xm + this.posX;
        double dy1 = (double)a.ym + this.posY;
        double dz1 = (double)a.zm + this.posZ;
        double dx2 = (double)b.xm + this.posX;
        double dy2 = (double)b.ym + this.posY;
        double dz2 = (double)b.zm + this.posZ;
        return (int)((dx1 * dx1 + dy1 * dy1 + dz1 * dz1 - (dx2 * dx2 + dy2 * dy2 + dz2 * dz2)) * 1024.0);
    }

    @Override
    public int compare(ChunkRenderer o1, ChunkRenderer o2) {
        return this.sortByDistanceToEntity(o1, o2);
    }
}

