/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.ChestBlock;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class ChestBlockModel<T extends Block>
extends StandardBlockModel<T> {
    protected IconCoordinate chestFrontSingle;
    protected IconCoordinate chestFrontLeft;
    protected IconCoordinate chestFrontRight;
    protected IconCoordinate chestBackLeft;
    protected IconCoordinate chestBackRight;
    protected IconCoordinate chestSide;
    protected IconCoordinate chestTop;

    public ChestBlockModel(Block block, String rootKey) {
        super(block);
        this.chestFrontSingle = TextureRegistry.getTexture(rootKey + "_front");
        this.chestFrontLeft = TextureRegistry.getTexture(rootKey + "_left_front");
        this.chestFrontRight = TextureRegistry.getTexture(rootKey + "_right_front");
        this.chestBackLeft = TextureRegistry.getTexture(rootKey + "_left_back");
        this.chestBackRight = TextureRegistry.getTexture(rootKey + "_right_back");
        this.chestSide = TextureRegistry.getTexture(rootKey + "_side");
        this.chestTop = TextureRegistry.getTexture(rootKey + "_top");
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        if (side == Side.TOP || side == Side.BOTTOM) {
            return this.chestTop;
        }
        Side facing = ChestBlock.getDirectionFromMeta(meta).getSide();
        ChestBlock.Type type = ChestBlock.getTypeFromMeta(meta);
        if (type == ChestBlock.Type.SINGLE && side == facing) {
            return this.chestFrontSingle;
        }
        if (type == ChestBlock.Type.LEFT) {
            if (side == facing) {
                return this.chestFrontLeft;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackRight;
            }
        }
        if (type == ChestBlock.Type.RIGHT) {
            if (side == facing) {
                return this.chestFrontRight;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackLeft;
            }
        }
        if (side.getAxis() != Axis.Y) {
            return this.chestSide;
        }
        return this.chestTop;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.SOUTH) {
            return this.chestFrontSingle;
        }
        if (side.isHorizontal()) {
            return this.chestSide;
        }
        return this.chestTop;
    }
}

