/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FarmlandBlock;
import net.minecraft.core.util.helper.Side;

public class FarmlandBlockModel<T extends Block>
extends StandardBlockModel<T> {
    protected IconCoordinate topWet = TextureRegistry.getTexture("minecraft:block/farmland_wet_top");
    protected IconCoordinate topWetFertilized = TextureRegistry.getTexture("minecraft:block/farmland_wet_fertilized_top");
    protected IconCoordinate topDry = TextureRegistry.getTexture("minecraft:block/farmland_dry_top");
    protected IconCoordinate topDryFertilized = TextureRegistry.getTexture("minecraft:block/farmland_dry_fertilized_top");
    protected IconCoordinate mud = TextureRegistry.getTexture("minecraft:block/mud");

    public FarmlandBlockModel(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isWet = FarmlandBlock.isWet(data);
        boolean isFertilized = FarmlandBlock.isFertilized(data);
        if (side == Side.TOP) {
            if (isWet && isFertilized) {
                return this.topWetFertilized;
            }
            if (isWet) {
                return this.topWet;
            }
            if (isFertilized) {
                return this.topDryFertilized;
            }
            return this.topDry;
        }
        if (isWet) {
            return this.mud;
        }
        return this.atlasIndices[side.getId()];
    }
}

