/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.BipedRenderer;
import net.minecraft.client.render.model.ZombieModel;
import net.minecraft.core.entity.monster.ZombieArmoredMob;

public class ArmoredZombieRenderer
extends BipedRenderer<ZombieArmoredMob> {
    private final ZombieModel modelArmorChestplate;
    private final ZombieModel modelArmor;

    public ArmoredZombieRenderer(ZombieModel model, float shadowSize) {
        super(model, shadowSize);
        this.modelBipedMain = model;
        this.modelArmorChestplate = new ZombieModel(1.0f);
        this.modelArmor = new ZombieModel(0.5f);
    }

    protected boolean setArmorModel(ZombieArmoredMob zombie, int renderPass, float partialTick) {
        this.bindTexture("/assets/minecraft/textures/armor/chain_" + (renderPass != 2 ? 1 : 2) + ".png");
        ZombieModel model = renderPass != 2 ? this.modelArmorChestplate : this.modelArmor;
        model.head.visible = renderPass == 0;
        model.hair.visible = renderPass == 0;
        model.body.visible = renderPass == 1 || renderPass == 2;
        model.arm0.visible = renderPass == 1;
        model.arm1.visible = renderPass == 1;
        model.leg0.visible = renderPass == 2 || renderPass == 3;
        model.leg1.visible = renderPass == 2 || renderPass == 3;
        int[] armorBreakPoints = zombie.getArmorBreakPoints();
        int[] armorBreakOrder = zombie.getArmorBreakOrder();
        for (int i = 0; i < 4; ++i) {
            if (zombie.getHealth() > armorBreakPoints[i]) continue;
            this.hideArmorPiece(armorBreakOrder[i]);
        }
        this.setArmorModel(model);
        return true;
    }

    @Override
    protected boolean prepareArmor(ZombieArmoredMob zombie, int renderPass, float partialTick) {
        return this.setArmorModel(zombie, renderPass, partialTick);
    }

    private void hideArmorPiece(int piece) {
        if (piece == 0) {
            this.modelArmorChestplate.head.visible = false;
            this.modelArmorChestplate.hair.visible = false;
        } else if (piece == 1) {
            this.modelArmorChestplate.body.visible = false;
            this.modelArmorChestplate.arm1.visible = false;
            this.modelArmorChestplate.arm0.visible = false;
        } else if (piece == 2) {
            this.modelArmor.body.visible = false;
            this.modelArmor.leg1.visible = false;
            this.modelArmor.leg0.visible = false;
        } else if (piece == 3) {
            this.modelArmorChestplate.leg1.visible = false;
            this.modelArmorChestplate.leg0.visible = false;
        }
    }
}

