/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.BlockEntityRenderDispatcher;
import net.minecraft.client.render.blockentity.FlagBlockEntityRenderer;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.BoatModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindProvider;
import org.lwjgl.opengl.GL11;

public class BoatRenderer
extends EntityRenderer<BoatEntity> {
    private final Minecraft mc = Minecraft.getMinecraft(this);
    protected BaseModel modelBoat;
    private FlagBlockEntityRenderer flagRenderer = new FlagBlockEntityRenderer();

    public BoatRenderer() {
        this.shadowSize = 0.5f;
        this.modelBoat = new BoatModel();
        this.flagRenderer.setRenderDispatcher(BlockEntityRenderDispatcher.instance);
    }

    @Override
    public void render(Tessellator tessellator, BoatEntity entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float hurt = (float)entity.boatTimeSinceHit - partialTick;
        float dmg = (float)entity.boatCurrentDamage - partialTick;
        if (dmg < 0.0f) {
            dmg = 0.0f;
        }
        if (hurt > 0.0f) {
            GL11.glRotatef((float)(MathHelper.sin(hurt) * hurt * dmg / 10.0f * (float)entity.boatRockDirection), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entity.tileEntityFlag != null) {
            World theWorld = this.mc.theWorld;
            WindProvider theWind = theWorld.getWorldType().getWindManager();
            float windAngle = theWind.getWindDirection(theWorld, (float)x, (float)y, (float)z) * 360.0f + (180.0f - yaw);
            float boatAngle = 180.0f;
            float boatSpeed = MathHelper.sqrt_float((float)(entity.xd * entity.xd + entity.zd * entity.zd));
            float angle = MathHelper.lerp(windAngle, boatAngle, (float)MathHelper.clamp((double)boatSpeed, 0.0, 0.25) * 4.0f);
            this.flagRenderer.doRender(entity.tileEntityFlag, -1.19, 0.187, -0.5, partialTick, false, angle, 1.0f);
        }
        TextureRegistry.blockAtlas.bind();
        float f4 = 0.75f;
        GL11.glScalef((float)f4, (float)f4, (float)f4);
        GL11.glScalef((float)(1.0f / f4), (float)(1.0f / f4), (float)(1.0f / f4));
        this.bindTexture("/assets/minecraft/textures/entity/boat.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.modelBoat.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

