/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture;

import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.meta.TextureMetaHandler;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Textures;
import org.jetbrains.annotations.Nullable;

public class FileTexture
extends Texture {
    protected final String sourcePath;
    protected TextureMetaHandler metaHandler = new TextureMetaHandler();

    public FileTexture() {
        this.sourcePath = null;
    }

    public FileTexture(String path) {
        this.generate();
        this.sourcePath = path;
        this.init();
    }

    @Override
    public boolean hasMeta(String key) {
        return this.metaHandler.has(key);
    }

    @Override
    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return this.metaHandler.get(key, aClass);
    }

    @Override
    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return this.metaHandler.getOrDefault(key, metaDefault, aClass);
    }

    @Override
    public void init() {
        this.metaHandler.reset();
        if (this.sourcePath != null) {
            Minecraft mc = Minecraft.getMinecraft(this);
            TexturePack pack = mc.texturePackList.getHighestPriorityTexturePackWithFile(this.sourcePath);
            if (pack == null) {
                this.setupTexture(Textures.missingTexture);
                return;
            }
            try (InputStream stream = pack.getResourceAsStream(this.sourcePath + ".mcmeta");){
                if (stream != null) {
                    this.metaHandler.loadFromStream(stream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try (InputStream imageStream = pack.getResourceAsStream(this.sourcePath);){
                if (imageStream == null) {
                    this.setupTexture(Textures.missingTexture);
                    return;
                }
                this.setupTexture(Textures.readImage(imageStream));
            }
            catch (IOException e) {
                this.setupTexture(Textures.missingTexture);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Source: ").append(this.sourcePath).append("\n");
        builder.append("Meta: \n").append(this.metaHandler);
        return builder.toString();
    }
}

