/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class ButtonBlock
extends Block {
    public ButtonBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.decoration);
        this.setTicking(true);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        Side checkSide = side.getOpposite();
        return world.isBlockNormalCube(x + checkSide.getOffsetX(), y + checkSide.getOffsetY(), z + checkSide.getOffsetZ());
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x, y - 1, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x - 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            return true;
        }
        return world.isBlockNormalCube(x, y, z + 1);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        int i1 = world.getBlockMetadata(x, y, z);
        int j1 = i1 & 8;
        i1 &= 7;
        i1 = side == Side.BOTTOM && world.isBlockNormalCube(x, y + 1, z) ? 5 : (side == Side.TOP && world.isBlockNormalCube(x, y - 1, z) ? 6 : (side == Side.NORTH && world.isBlockNormalCube(x, y, z + 1) ? 4 : (side == Side.SOUTH && world.isBlockNormalCube(x, y, z - 1) ? 3 : (side == Side.WEST && world.isBlockNormalCube(x + 1, y, z) ? 2 : (side == Side.EAST && world.isBlockNormalCube(x - 1, y, z) ? 1 : this.getOrientation(world, x, y, z))))));
        world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
    }

    private int getOrientation(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x - 1, y, z)) {
            return 1;
        }
        if (world.isBlockNormalCube(x + 1, y, z)) {
            return 2;
        }
        if (world.isBlockNormalCube(x, y, z - 1)) {
            return 3;
        }
        if (world.isBlockNormalCube(x, y, z + 1)) {
            return 4;
        }
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return 5;
        }
        if (world.isBlockNormalCube(x, y - 1, z)) {
            return 6;
        }
        return 1;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (this.canButtonStay(world, x, y, z)) {
            int i1 = world.getBlockMetadata(x, y, z) & 7;
            boolean flag = false;
            if (!world.isBlockNormalCube(x - 1, y, z) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x + 1, y, z) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y, z + 1) && i1 == 4) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y + 1, z) && i1 == 5) {
                flag = true;
            }
            if (!world.isBlockNormalCube(x, y - 1, z) && i1 == 6) {
                flag = true;
            }
            if (flag) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, i1, null);
                world.setBlockWithNotify(x, y, z, 0);
            }
        }
    }

    private boolean canButtonStay(World world, int x, int y, int z) {
        if (!this.canPlaceBlockAt(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.1875f;
        float f3 = 0.125f;
        if (flag) {
            f3 = 0.0625f;
        }
        if (i1 == 1) {
            this.setBlockBounds(0.0, f, 0.5f - f2, f3, f1, 0.5f + f2);
        } else if (i1 == 2) {
            this.setBlockBounds(1.0f - f3, f, 0.5f - f2, 1.0, f1, 0.5f + f2);
        } else if (i1 == 3) {
            this.setBlockBounds(0.5f - f2, f, 0.0, 0.5f + f2, f1, f3);
        } else if (i1 == 4) {
            this.setBlockBounds(0.5f - f2, f, 1.0f - f3, 0.5f + f2, f1, 1.0);
        } else if (i1 == 5) {
            this.setBlockBounds(0.5f - f2, 1.0f - f3, f, 0.5f + f2, 1.0, f1);
        } else if (i1 == 6) {
            this.setBlockBounds(0.5f - f2, 0.0, f, 0.5f + f2, f3, f1);
        }
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onBlockRightClicked(world, x, y, z, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = l & 7;
        int j1 = 8 - (l & 8);
        if (j1 == 0) {
            return true;
        }
        world.setBlockMetadataWithNotify(x, y, z, i1 + j1);
        world.markBlocksDirty(x, y, z, x, y, z);
        world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id);
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        } else if (i1 == 5) {
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        } else {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
        return true;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if ((data & 8) > 0) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            int i1 = data & 7;
            if (i1 == 1) {
                world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
            } else if (i1 == 2) {
                world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
            } else if (i1 == 3) {
                world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
            } else if (i1 == 4) {
                world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
            } else if (i1 == 5) {
                world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
            } else {
                world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean getSignal(WorldSource blockAccess, int x, int y, int z, Side side) {
        return (blockAccess.getBlockMetadata(x, y, z) & 8) > 0;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) == 0) {
            return false;
        }
        int direction = meta & 7;
        if (direction == 6 && side == Side.TOP) {
            return true;
        }
        if (direction == 5 && side == Side.BOTTOM) {
            return true;
        }
        if (direction == 4 && side == Side.NORTH) {
            return true;
        }
        if (direction == 3 && side == Side.SOUTH) {
            return true;
        }
        if (direction == 2 && side == Side.WEST) {
            return true;
        }
        return direction == 1 && side == Side.EAST;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) == 0) {
            return;
        }
        world.setBlockMetadataWithNotify(x, y, z, l & 7);
        world.notifyBlocksOfNeighborChange(x, y, z, this.id);
        int i1 = l & 7;
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        } else if (i1 == 5) {
            world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        } else {
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        world.markBlocksDirty(x, y, z, x, y, z);
    }
}

