/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BasketBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.NoteBlockEntity;
import net.minecraft.core.block.entity.SeatBlockEntity;
import net.minecraft.core.block.entity.SensorBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;

public class BlockEntity {
    private static Map nameToClassMap = new HashMap();
    private static Map classToNameMap = new HashMap();
    public World worldObj;
    public int x;
    public int y;
    public int z;
    protected boolean tileEntityInvalid;

    private static void addMapping(Class class1, String s) {
        if (classToNameMap.containsKey(s)) {
            throw new IllegalArgumentException("Duplicate id: " + s);
        }
        nameToClassMap.put(s, class1);
        classToNameMap.put(class1, s);
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        String s = (String)classToNameMap.get(this.getClass());
        if (s == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.putString("id", s);
        nbttagcompound.putInt("x", this.x);
        nbttagcompound.putInt("y", this.y);
        nbttagcompound.putInt("z", this.z);
    }

    public void tick() {
    }

    public static BlockEntity createAndLoadEntity(CompoundTag nbttagcompound) {
        BlockEntity tileentity = null;
        try {
            Class class1 = (Class)nameToClassMap.get(nbttagcompound.getString("id"));
            if (class1 != null) {
                tileentity = (BlockEntity)class1.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileentity != null) {
            tileentity.readFromNBT(nbttagcompound);
        } else {
            System.out.println("Skipping BlockEntity with id " + nbttagcompound.getString("id"));
        }
        return tileentity;
    }

    public static Class<?> getClassFromID(String id) {
        return (Class)nameToClassMap.get(id);
    }

    public int getMovedData() {
        return this.worldObj.getBlockMetadata(this.x, this.y, this.z);
    }

    public void setChanged() {
        if (this.worldObj != null) {
            this.worldObj.updateTileEntityChunkAndSendToPlayer(this.x, this.y, this.z, this);
        }
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    public double getDistanceFrom(double d, double d1, double d2) {
        double d3 = (double)this.x + 0.5 - d;
        double d4 = (double)this.y + 0.5 - d1;
        double d5 = (double)this.z + 0.5 - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public Block getBlockType() {
        return Block.blocksList[this.worldObj.getBlockId(this.x, this.y, this.z)];
    }

    public boolean isInvalid() {
        return this.tileEntityInvalid;
    }

    public void invalidate() {
        this.tileEntityInvalid = true;
    }

    public void validate() {
        this.tileEntityInvalid = false;
    }

    static {
        BlockEntity.addMapping(FurnaceBlockEntity.class, "Furnace");
        BlockEntity.addMapping(ChestBlockEntity.class, "Chest");
        BlockEntity.addMapping(JukeboxBlockEntity.class, "RecordPlayer");
        BlockEntity.addMapping(DispenserBlockEntity.class, "Trap");
        BlockEntity.addMapping(SignBlockEntity.class, "Sign");
        BlockEntity.addMapping(MobSpawnerBlockEntity.class, "MobSpawner");
        BlockEntity.addMapping(NoteBlockEntity.class, "Music");
        BlockEntity.addMapping(MovingPistonBlockEntity.class, "Piston");
        BlockEntity.addMapping(BlastFurnaceBlockEntity.class, "BlastFurnace");
        BlockEntity.addMapping(SensorBlockEntity.class, "Sensor");
        BlockEntity.addMapping(TrommelBlockEntity.class, "Trommel");
        BlockEntity.addMapping(BasketBlockEntity.class, "Basket");
        BlockEntity.addMapping(FlagBlockEntity.class, "Flag");
        BlockEntity.addMapping(SeatBlockEntity.class, "Seat");
        BlockEntity.addMapping(FlowerJarBlockEntity.class, "FlowerJar");
        BlockEntity.addMapping(GoldMeshBlockEntity.class, "MeshGold");
    }
}

