/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.block.PistonBlockItem;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BasePistonBlock
extends Block {
    private boolean isSticky;

    public BasePistonBlock(String key, String namespaceId, int id, boolean isSticky) {
        super(key, namespaceId, id, Material.piston);
        this.isSticky = isSticky;
        this.setBlockItem(() -> new PistonBlockItem(this));
        this.withHardness(0.5f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        Direction placementDirection = mob.getPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, placementDirection.getId());
        if (!world.isClientSide) {
            this.checkIfExtend(world, x, y, z);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkIfExtend(world, x, y, z);
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        if (!world.isClientSide && world.getBlockEntity(x, y, z) == null) {
            this.checkIfExtend(world, x, y, z);
        }
    }

    private void checkIfExtend(World world, int x, int y, int z) {
        int data = world.getBlockMetadata(x, y, z);
        int direction = BasePistonBlock.getDirection(data);
        boolean hasNeighborSignal = this.getNeighborSignal(world, x, y, z, direction);
        if (data == 7) {
            return;
        }
        if (hasNeighborSignal && !BasePistonBlock.isPowered(data)) {
            if (BasePistonBlock.canPushLine(world, x, y, z, direction)) {
                world.setBlockMetadata(x, y, z, direction | 8);
                world.triggerEvent(x, y, z, 0, direction);
            }
        } else if (!hasNeighborSignal && BasePistonBlock.isPowered(data)) {
            world.setBlockMetadata(x, y, z, direction);
            world.triggerEvent(x, y, z, 1, direction);
        }
    }

    private boolean getNeighborSignal(World world, int x, int y, int z, int direction) {
        if (direction != 0 && world.isBlockIndirectlyProvidingPowerTo(x, y - 1, z, Side.BOTTOM)) {
            return true;
        }
        if (direction != 1 && world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z, Side.TOP)) {
            return true;
        }
        if (direction != 2 && world.isBlockIndirectlyProvidingPowerTo(x, y, z - 1, Side.NORTH)) {
            return true;
        }
        if (direction != 3 && world.isBlockIndirectlyProvidingPowerTo(x, y, z + 1, Side.SOUTH)) {
            return true;
        }
        if (direction != 5 && world.isBlockIndirectlyProvidingPowerTo(x + 1, y, z, Side.EAST)) {
            return true;
        }
        if (direction != 4 && world.isBlockIndirectlyProvidingPowerTo(x - 1, y, z, Side.WEST)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y, z, Side.BOTTOM)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 2, z, Side.TOP)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z - 1, Side.NORTH)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x, y + 1, z + 1, Side.SOUTH)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(x - 1, y + 1, z, Side.WEST)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(x + 1, y + 1, z, Side.EAST);
    }

    @Override
    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
        int direction = data;
        if (direction >= 6) {
            direction = 0;
        }
        if (index == 0) {
            if (this.tryExtend(world, x, y, z, direction)) {
                world.setBlockMetadataWithNotify(x, y, z, direction | 8);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.rand.nextFloat() * 0.25f + 0.6f);
            }
        } else if (index == 1) {
            BlockEntity tileentity = world.getBlockEntity(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction]);
            if (tileentity != null && tileentity instanceof MovingPistonBlockEntity) {
                ((MovingPistonBlockEntity)tileentity).finalTick();
            }
            world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id, direction);
            world.setBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(this.id, direction, direction, false, true));
            if (this.isSticky) {
                MovingPistonBlockEntity tileentitypiston;
                BlockEntity tileentity1;
                int x1 = x + PistonDirections.xOffset[direction] * 2;
                int y1 = y + PistonDirections.yOffset[direction] * 2;
                int z1 = z + PistonDirections.zOffset[direction] * 2;
                int id1 = world.getBlockId(x1, y1, z1);
                int meta1 = world.getBlockMetadata(x1, y1, z1);
                boolean flag = false;
                if (id1 == Blocks.PISTON_MOVING.id && (tileentity1 = world.getBlockEntity(x1, y1, z1)) != null && tileentity1 instanceof MovingPistonBlockEntity && (tileentitypiston = (MovingPistonBlockEntity)tileentity1).getDirection() == direction && tileentitypiston.isExtending()) {
                    tileentitypiston.finalTick();
                    id1 = tileentitypiston.getMovedId();
                    meta1 = tileentitypiston.getMovedData();
                    flag = true;
                }
                if (!flag && id1 > 0 && BasePistonBlock.isPushable(id1, world, x1, y1, z1, false) && (Block.blocksList[id1].getPistonPushReaction() == 0 || id1 == Blocks.PISTON_BASE.id || id1 == Blocks.PISTON_BASE_STICKY.id)) {
                    world.setBlockWithNotify(x1, y1, z1, 0);
                    world.setBlockAndMetadata(x += PistonDirections.xOffset[direction], y += PistonDirections.yOffset[direction], z += PistonDirections.zOffset[direction], Blocks.PISTON_MOVING.id, meta1);
                    world.setBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(id1, meta1, direction, false, false));
                } else if (!flag) {
                    world.setBlockWithNotify(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction], 0);
                }
            } else {
                world.setBlockWithNotify(x + PistonDirections.xOffset[direction], y + PistonDirections.yOffset[direction], z + PistonDirections.zOffset[direction], 0);
            }
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (BasePistonBlock.isPowered(l)) {
            switch (BasePistonBlock.getDirection(l)) {
                case 0: {
                    this.setBlockBounds(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 1: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbs) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        super.getCollidingBoundingBoxes(world, x, y, z, aabb, aabbs);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    public static int getDirection(int data) {
        return data & 7;
    }

    public static boolean isPowered(int data) {
        return (data & 8) != 0;
    }

    private static boolean isPushable(int id, World world, int x, int y, int z, boolean canDestroy) {
        BlockEntity tileentity;
        if (id == Blocks.OBSIDIAN.id) {
            return false;
        }
        if (id == Blocks.PISTON_BASE.id || id == Blocks.PISTON_BASE_STICKY.id) {
            if (BasePistonBlock.isPowered(world.getBlockMetadata(x, y, z))) {
                return false;
            }
        } else {
            if (Block.blocksList[id].getHardness() == -1.0f) {
                return false;
            }
            if (Block.blocksList[id].getPistonPushReaction() == 2) {
                return false;
            }
            if (Block.blocksList[id].getImmovable()) {
                return false;
            }
            if (!canDestroy && Block.blocksList[id].getPistonPushReaction() == 1) {
                return false;
            }
        }
        return (tileentity = world.getBlockEntity(x, y, z)) == null;
    }

    private static boolean canPushLine(World world, int x, int y, int z, int direction) {
        int xo = x + PistonDirections.xOffset[direction % 6];
        int yo = y + PistonDirections.yOffset[direction % 6];
        int zo = z + PistonDirections.zOffset[direction % 6];
        for (int i = 0; i < 13; ++i) {
            if (yo <= 0 || yo >= world.getHeightBlocks() - 1) {
                return false;
            }
            int id = world.getBlockId(xo, yo, zo);
            if (id == 0) break;
            if (!BasePistonBlock.isPushable(id, world, xo, yo, zo, true)) {
                if (i == 1 && (id == Blocks.OBSIDIAN.id || id == Blocks.BEDROCK.id)) {
                    int x2 = x + PistonDirections.xOffset[direction % 6];
                    int y2 = y + PistonDirections.yOffset[direction % 6];
                    int z2 = z + PistonDirections.zOffset[direction % 6];
                    world.playSoundEffect(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
                    Block.blocksList[world.getBlockId(x2, y2, z2)].dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x2, y2, z2, world.getBlockMetadata(x2, y2, z2), null);
                    world.setBlockWithNotify(x2, y2, z2, 0);
                    break;
                }
                return false;
            }
            if (Block.blocksList[id].getPistonPushReaction() == 1) break;
            if (i == 12) {
                return false;
            }
            xo += PistonDirections.xOffset[direction % 6];
            yo += PistonDirections.yOffset[direction % 6];
            zo += PistonDirections.zOffset[direction % 6];
        }
        return true;
    }

    private boolean tryExtend(World world, int x, int y, int z, int direction) {
        int i1 = x + PistonDirections.xOffset[direction % 6];
        int j1 = y + PistonDirections.yOffset[direction % 6];
        int k1 = z + PistonDirections.zOffset[direction % 6];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= world.getHeightBlocks() - 1) {
                return false;
            }
            int j2 = world.getBlockId(i1, j1, k1);
            if (j2 == 0) break;
            if (!BasePistonBlock.isPushable(j2, world, i1, j1, k1, true)) {
                return false;
            }
            if (Block.blocksList[j2].getPistonPushReaction() == 1) {
                Block.blocksList[j2].dropBlockWithCause(world, EnumDropCause.WORLD, i1, j1, k1, world.getBlockMetadata(i1, j1, k1), null);
                world.setBlockWithNotify(i1, j1, k1, 0);
                break;
            }
            if (l1 == 12) {
                return false;
            }
            i1 += PistonDirections.xOffset[direction % 6];
            j1 += PistonDirections.yOffset[direction % 6];
            k1 += PistonDirections.zOffset[direction % 6];
        }
        int l2 = 0;
        while (i1 != x || j1 != y || k1 != z) {
            int i2 = i1 - PistonDirections.xOffset[direction % 6];
            int k2 = j1 - PistonDirections.yOffset[direction % 6];
            l2 = k1 - PistonDirections.zOffset[direction % 6];
            int i3 = world.getBlockId(i2, k2, l2);
            int j3 = world.getBlockMetadata(i2, k2, l2);
            if (i3 == this.id && i2 == x && k2 == y && l2 == z) {
                world.setBlockAndMetadata(i1, j1, k1, Blocks.PISTON_MOVING.id, direction | (this.isSticky ? 8 : 0));
                world.setBlockTileEntity(i1, j1, k1, MovingPistonBlock.createTileEntity(Blocks.PISTON_HEAD.id, direction | (this.isSticky ? 8 : 0), direction, true, false));
            } else {
                world.setBlockAndMetadata(i1, j1, k1, Blocks.PISTON_MOVING.id, j3);
                world.setBlockTileEntity(i1, j1, k1, MovingPistonBlock.createTileEntity(i3, j3, direction, true, false));
            }
            i1 = i2;
            j1 = k2;
            k1 = l2;
        }
        return true;
    }
}

