/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class MovingPistonBlock
extends EntityBlock {
    public MovingPistonBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.piston);
        this.withHardness(-1.0f);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return null;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        BlockEntity tileentity = world.getBlockEntity(x, y, z);
        if (tileentity != null && tileentity instanceof MovingPistonBlockEntity) {
            ((MovingPistonBlockEntity)tileentity).finalTick();
        } else {
            super.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide && world.getBlockEntity(x, y, z) == null) {
            world.setBlockWithNotify(x, y, z, 0);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return null;
    }

    @Override
    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        MovingPistonBlockEntity piston = this.getBlockEntity(world, x, y, z);
        if (piston != null) {
            Block.blocksList[piston.getMovedId()].dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide || world.getBlockEntity(x, y, z) != null) {
            // empty if block
        }
    }

    public static BlockEntity createTileEntity(int id, int oldData, int newData, boolean flag, boolean flag1) {
        return new MovingPistonBlockEntity(id, oldData, newData, flag, flag1);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        MovingPistonBlockEntity tileEntity = this.getBlockEntity(world, x, y, z);
        if (tileEntity == null) {
            return null;
        }
        float progress = tileEntity.getProgress(0.0f);
        if (tileEntity.isExtending()) {
            progress = 1.0f - progress;
        }
        return this.getCollisionShapeFromTileEntity(world, x, y, z, tileEntity.getMovedId(), progress, tileEntity.getDirection());
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        MovingPistonBlockEntity tileentitypiston = this.getBlockEntity(world, x, y, z);
        if (tileentitypiston != null) {
            Block block = Block.blocksList[tileentitypiston.getMovedId()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(world, x, y, z);
            float f = tileentitypiston.getProgress(0.0f);
            if (tileentitypiston.isExtending()) {
                f = 1.0f - f;
            }
            int l = tileentitypiston.getDirection();
            this.minX = block.minX - (double)((float)PistonDirections.xOffset[l] * f);
            this.minY = block.minY - (double)((float)PistonDirections.yOffset[l] * f);
            this.minZ = block.minZ - (double)((float)PistonDirections.zOffset[l] * f);
            this.maxX = block.maxX - (double)((float)PistonDirections.xOffset[l] * f);
            this.maxY = block.maxY - (double)((float)PistonDirections.yOffset[l] * f);
            this.maxZ = block.maxZ - (double)((float)PistonDirections.zOffset[l] * f);
        }
    }

    public AABB getCollisionShapeFromTileEntity(WorldSource world, int x, int y, int z, int l, float f, int i1) {
        if (l == 0 || l == this.id) {
            return null;
        }
        AABB axisalignedbb = Block.blocksList[l].getCollisionBoundingBoxFromPool(world, x, y, z);
        if (axisalignedbb == null) {
            return null;
        }
        axisalignedbb.minX -= (double)((float)PistonDirections.xOffset[i1] * f);
        axisalignedbb.maxX -= (double)((float)PistonDirections.xOffset[i1] * f);
        axisalignedbb.minY -= (double)((float)PistonDirections.yOffset[i1] * f);
        axisalignedbb.maxY -= (double)((float)PistonDirections.yOffset[i1] * f);
        axisalignedbb.minZ -= (double)((float)PistonDirections.zOffset[i1] * f);
        axisalignedbb.maxZ -= (double)((float)PistonDirections.zOffset[i1] * f);
        return axisalignedbb;
    }

    private MovingPistonBlockEntity getBlockEntity(WorldSource world, int x, int y, int z) {
        BlockEntity blockEntity = world.getBlockEntity(x, y, z);
        if (blockEntity instanceof MovingPistonBlockEntity) {
            return (MovingPistonBlockEntity)blockEntity;
        }
        return null;
    }
}

