/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.PebbleProjectile;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class PebbleItem
extends Item
implements IDispensable {
    public PebbleItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        itemstack.consumeItem(entityplayer);
        world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new PebbleProjectile(world, entityplayer));
        }
        return itemstack;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int newMeta;
        int id = world.getBlockId(blockX, blockY, blockZ);
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if (id != Blocks.OVERLAY_PEBBLES.id && Block.blocksList[id] != null && Block.blocksList[id].hasTag(BlockTags.PLACE_OVERWRITES)) {
            id = 0;
            meta = 0;
        }
        if (itemstack.stackSize <= 0) {
            return false;
        }
        if (blockY == world.getHeightBlocks() - 1 && Blocks.OVERLAY_PEBBLES.blockMaterial.isSolid()) {
            return false;
        }
        if (id == Blocks.OVERLAY_PEBBLES.id && side == Side.TOP) {
            newMeta = meta + 1;
            if (!world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.OVERLAY_PEBBLES.id, newMeta);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
                return true;
            }
        }
        if (id != 0) {
            id = world.getBlockId(blockX += side.getOffsetX(), blockY += side.getOffsetY(), blockZ += side.getOffsetZ());
            meta = world.getBlockMetadata(blockX, blockY, blockZ);
        }
        if (id == Blocks.OVERLAY_PEBBLES.id) {
            newMeta = meta + 1;
            AABB bbBox = AABB.getTemporaryBB(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox) || !world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
                return false;
            }
            if (newMeta < 3) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.OVERLAY_PEBBLES.id, newMeta);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
                return true;
            }
        }
        if (world.canBlockBePlacedAt(Blocks.OVERLAY_PEBBLES.id, blockX, blockY, blockZ, false, side) && world.isBlockOpaqueCube(blockX, blockY - 1, blockZ)) {
            Block block = Blocks.OVERLAY_PEBBLES;
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.OVERLAY_PEBBLES.id, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Blocks.OVERLAY_PEBBLES.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, entityplayer, yPlaced);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.OVERLAY_PEBBLES, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int zOffset, Random random) {
        PebbleProjectile pebbleProjectile = new PebbleProjectile(world, x, y, z);
        pebbleProjectile.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
        world.entityJoinedWorld(pebbleProjectile);
    }
}

