/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.FluidBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PlaceableItem
extends Item {
    public Block blockToPlace;

    public PlaceableItem(String name, String namespaceId, int id, Block blockToPlace) {
        super(name, namespaceId, id);
        this.blockToPlace = blockToPlace;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Block currentBlock;
        boolean placedInside;
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        boolean bl = placedInside = (currentBlock = world.getBlock(blockX, blockY, blockZ)) != null && !(currentBlock instanceof FluidBlock);
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockToPlace.id, blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
            if (placedInside && !world.isClientSide) {
                world.playSoundEffect(2001, blockX, blockY, blockZ, world.getBlockId(blockX, blockY, blockZ));
            }
            if (world.setBlockWithNotify(blockX, blockY, blockZ, this.blockToPlace.id)) {
                this.blockToPlace.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, yPlaced);
                world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.blockToPlace, EnumBlockSoundEffectType.PLACE);
            }
            return true;
        }
        return false;
    }
}

