/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class AlgaeBlockItem
extends BlockItem {
    public AlgaeBlockItem(Block block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        return false;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.xRotO + (entityplayer.xRot - entityplayer.xRotO) * f;
        float f2 = entityplayer.yRotO + (entityplayer.yRot - entityplayer.yRotO) * f;
        double d = entityplayer.xo + (entityplayer.x - entityplayer.xo) * (double)f;
        double d1 = entityplayer.yo + (entityplayer.y - entityplayer.yo) * (double)f + 1.62 - (double)entityplayer.heightOffset;
        double d2 = entityplayer.zo + (entityplayer.z - entityplayer.zo) * (double)f;
        Vec3 vec3 = Vec3.getTempVec3(d, d1, d2);
        float f3 = MathHelper.cos(-f2 * 0.01745329f - (float)Math.PI);
        float f4 = MathHelper.sin(-f2 * 0.01745329f - (float)Math.PI);
        float f7 = f4 * (f5 = -MathHelper.cos(-f1 * 0.01745329f));
        Vec3 vec31 = vec3.add((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.sin(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        HitResult movingobjectposition = world.checkBlockCollisionBetweenPoints(vec3, vec31, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.hitType == HitResult.HitType.TILE) {
            int i = movingobjectposition.x;
            int j = movingobjectposition.y;
            int k = movingobjectposition.z;
            if (world.getBlockId(i, j, k) != Blocks.FLUID_WATER_STILL.id) {
                return itemstack;
            }
            if (world.getBlockId(i, ++j, k) != 0) {
                return itemstack;
            }
            Block block = Block.blocksList[Blocks.ALGAE.id];
            if (itemstack.consumeItem(entityplayer) && world.setBlockAndMetadataWithNotify(i, j, k, Blocks.ALGAE.id, 0)) {
                block.onBlockPlacedByMob(world, i, j, k, null, entityplayer, 0.0);
                world.playBlockSoundEffect(entityplayer, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block, EnumBlockSoundEffectType.PLACE);
                entityplayer.swingItem();
            }
        }
        return itemstack;
    }
}

