/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.FluidBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockItem
extends Item {
    protected int blockID;

    public BlockItem(Block block) {
        super(block.namespaceID, block.id);
        this.blockID = block.id;
        this.setKey(block.getKey());
    }

    public Block getBlock() {
        return Block.blocksList[this.blockID];
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Block currentBlock;
        boolean placedInside;
        if (stack.stackSize <= 0) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        boolean bl = placedInside = (currentBlock = world.getBlock(blockX, blockY, blockZ)) != null && !(currentBlock instanceof FluidBlock);
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
            Block block = Block.blocksList[this.blockID];
            if (placedInside && !world.isClientSide) {
                world.playSoundEffect(2001, blockX, blockY, blockZ, world.getBlockId(blockX, blockY, blockZ));
            }
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.blockID, this.getPlacedBlockMetadata(stack.getMetadata()))) {
                block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, yPlaced);
                world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, block, EnumBlockSoundEffectType.PLACE);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return Block.blocksList[this.blockID].getLanguageKey(itemstack.getMetadata());
    }

    @Override
    public String getKey() {
        return Block.blocksList[this.blockID].getKey();
    }
}

