/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.FluidBlock;
import net.minecraft.core.block.LadderBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class LadderBlockItem
extends BlockItem {
    private LadderBlock ladderBlock;

    public LadderBlockItem(LadderBlock block) {
        super(block);
        this.ladderBlock = block;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        Side sideForPlacement;
        Block clickedBlock = world.getBlock(x, y, z);
        if (clickedBlock == this.ladderBlock && !player.isSneaking()) {
            Side clickedLadderSide = this.ladderBlock.getSideFromMeta(world.getBlockMetadata(x, y, z));
            while (world.getBlock(x, y, z) == this.ladderBlock && this.ladderBlock.getSideFromMeta(world.getBlockMetadata(x, y, z)) == clickedLadderSide) {
                --y;
            }
            int meta = this.ladderBlock.getMetaForSide(clickedLadderSide);
            if (this.ladderBlock.canExistAt(world, x, y, z, meta)) {
                return this.placeBlock(world, x, y, z, meta, player, stack, clickedLadderSide, 0.5);
            }
            return false;
        }
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += side.getOffsetX();
            y += side.getOffsetY();
            z += side.getOffsetZ();
        }
        if ((sideForPlacement = this.ladderBlock.getSideForPlacement(world, x, y, z, side)) == null) {
            return false;
        }
        int meta = this.ladderBlock.getMetaForSide(sideForPlacement);
        if (this.ladderBlock.canExistAt(world, x, y, z, meta)) {
            return this.placeBlock(world, x, y, z, meta, player, stack, sideForPlacement, yPlaced);
        }
        return false;
    }

    public boolean placeBlock(World world, int x, int y, int z, int meta, Player player, ItemStack stack, Side side, double sideHeight) {
        Block currentBlock = world.getBlock(x, y, z);
        if (world.canPlaceInsideBlock(x, y, z) && world.canBlockBePlacedAt(this.blockID, x, y, z, false, side) && stack.consumeItem(player)) {
            if (currentBlock != null && !(currentBlock instanceof FluidBlock) && !world.isClientSide) {
                world.playSoundEffect(2001, x, y, z, world.getBlockId(x, y, z));
            }
            if (world.setBlockAndMetadataWithNotify(x, y, z, this.blockID, meta)) {
                Block.getBlock(this.blockID).onBlockPlacedByMob(world, x, y, z, side, player, sideHeight);
                world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this.ladderBlock, EnumBlockSoundEffectType.PLACE);
                return true;
            }
        }
        return false;
    }
}

