/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.TextFormatting;

public class WhisperCommand
extends Command {
    public WhisperCommand() {
        super("tell", "msg", "whisper");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        Player player = handler.getPlayer(args[0]);
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            builder.append(args[i] + " ");
        }
        String msg = builder.toString();
        msg = sender.getName() + TextFormatting.GRAY + " >> " + player.getDisplayName() + TextFormatting.GRAY + ": " + TextFormatting.LIGHT_GRAY + msg;
        sender.sendMessage(msg);
        if (sender.getPlayer() != player) {
            handler.sendMessageToPlayer(player, msg);
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/msg <username> <message>");
    }
}

