/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;

public class PlayerListPacket
extends Packet {
    public String[] players;
    public String[] scores;
    public int count;

    public PlayerListPacket() {
    }

    public PlayerListPacket(int playerCount, String[] players, String[] scores) {
        this.count = playerCount;
        this.players = players;
        this.scores = scores;
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.count = in.readInt();
        this.players = new String[this.count];
        this.scores = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.players[i] = PlayerListPacket.readString(in, 1024);
            this.scores[i] = PlayerListPacket.readString(in, 1024);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            PlayerListPacket.writeString(this.players[i], out);
            PlayerListPacket.writeString(this.scores[i], out);
        }
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handlePlayerList(this);
    }

    @Override
    public int getEstimatedSize() {
        int i;
        int size = 4;
        for (i = 0; i < this.scores.length; ++i) {
            size += this.scores[i].length();
        }
        for (i = 0; i < this.players.length; ++i) {
            size += this.players[i].length();
        }
        return size;
    }
}

