/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class Dimension {
    public int id;
    public final String languageKey;
    public final Dimension homeDim;
    public final WorldType defaultWorldType;
    public final float worldScale;
    public final int portalBlockId;
    private static final Map<Integer, Dimension> dimensionList = new HashMap<Integer, Dimension>();
    public static Dimension overworld;
    public static Dimension nether;
    public static Dimension paradise;

    public Dimension(String languageKey, Dimension homeDim, float worldScale, int portalBlockId, WorldType defaultWorldType) {
        this.languageKey = languageKey;
        this.homeDim = homeDim;
        this.worldScale = worldScale;
        this.portalBlockId = portalBlockId;
        this.defaultWorldType = defaultWorldType;
    }

    public DimensionData getDimensionData(World world) {
        if (world.dimension == this) {
            return world.dimensionData;
        }
        DimensionData dimensionData = world.saveHandler.getDimensionData(this.id);
        if (dimensionData == null) {
            dimensionData = new DimensionData(this.defaultWorldType);
        }
        return dimensionData;
    }

    public boolean canPortal(Dimension dim) {
        if (this.homeDim == null) {
            return true;
        }
        return dim == this.homeDim;
    }

    public static float getCoordScale(Dimension oldDim, Dimension newDim) {
        if (oldDim.homeDim == newDim) {
            return 1.0f / oldDim.worldScale;
        }
        if (newDim.homeDim == oldDim) {
            return newDim.worldScale;
        }
        return 1.0f;
    }

    public String getTranslatedName() {
        return I18n.getInstance().translateNameKey("dimension." + this.languageKey);
    }

    public String toString() {
        return "Dimension: [ ID: " + this.id + " Name: " + this.getTranslatedName() + " ]";
    }

    public static Map<Integer, Dimension> getDimensionList() {
        return Collections.unmodifiableMap(dimensionList);
    }

    public static void registerDimension(int id, Dimension dimension) throws IllegalArgumentException {
        if (dimensionList.containsKey(id)) {
            throw new IllegalArgumentException("Dimension with ID " + dimension.id + " is already registered!");
        }
        dimension.id = id;
        dimensionList.put(id, dimension);
    }

    public static void init() {
        overworld = new Dimension("overworld", null, 1.0f, -1, WorldTypes.OVERWORLD_DEFAULT);
        nether = new Dimension("hell", overworld, 0.125f, Blocks.PORTAL_NETHER.id, WorldTypes.NETHER_DEFAULT);
        paradise = new Dimension("paradise", overworld, 8.0f, Blocks.PORTAL_PARADISE.id, WorldTypes.PARADISE_DEFAULT);
        Dimension.registerDimension(0, overworld);
        Dimension.registerDimension(1, nether);
        Dimension.registerDimension(2, paradise);
    }
}

