/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Block;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import net.minecraft.core.world.wind.WindProvider;
import net.minecraft.core.world.wind.WindProviderGeneric;

public abstract class WorldType {
    private final String languageKey;
    private final Weather defaultWeather;
    private final WindProvider windProvider;
    private final boolean hasCeiling;
    private final float[] brightnessRamp;
    private final SeasonConfig seasonConfig;
    private final boolean hasClouds;
    private final boolean hasSky;
    private final int minY;
    private final int maxY;
    private final int oceanY;
    private final int oceanBlockId;
    private final int fillerBlockId;
    private final int dayNightCycleTicks;
    private final boolean mayRespawn;
    private final float cloudHeight;
    private final boolean hasGround;
    private final boolean hasAurora;

    public WorldType(Properties properties) {
        this.languageKey = properties.languageKey;
        this.defaultWeather = properties.defaultWeather == null ? Weathers.OVERWORLD_CLEAR : properties.defaultWeather;
        this.windProvider = properties.windProvider == null ? new WindProviderGeneric() : properties.windProvider;
        this.hasCeiling = properties.hasCeiling;
        this.brightnessRamp = properties.brightnessRamp;
        this.seasonConfig = properties.seasonConfig == null ? SeasonConfig.builder().withSingleSeason(Seasons.NULL).build() : properties.seasonConfig;
        this.hasClouds = properties.hasClouds;
        this.hasSky = properties.hasSky;
        this.minY = properties.minY;
        this.maxY = properties.maxY;
        this.oceanY = properties.oceanY;
        this.oceanBlockId = properties.oceanBlock == null ? 0 : ((Properties)properties).oceanBlock.id;
        this.fillerBlockId = properties.fillerBlock == null ? 0 : ((Properties)properties).fillerBlock.id;
        this.dayNightCycleTicks = properties.dayNightCycleTicks;
        this.mayRespawn = properties.mayRespawn;
        this.cloudHeight = properties.cloudHeight == null ? (float)(properties.maxY + 1 - 20) : properties.cloudHeight.floatValue();
        this.hasGround = properties.hasGround;
        this.hasAurora = properties.hasAurora;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public Weather getDefaultWeather() {
        return this.defaultWeather;
    }

    public WindProvider getWindManager() {
        return this.windProvider;
    }

    public boolean hasCeiling() {
        return this.hasCeiling;
    }

    public float[] getBrightnessRamp() {
        return this.brightnessRamp;
    }

    public SeasonConfig getSeasonConfig() {
        return this.seasonConfig;
    }

    public boolean hasClouds() {
        return this.hasClouds;
    }

    public boolean hasSky() {
        return this.hasSky;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getOceanY() {
        return this.oceanY;
    }

    public int getOceanBlockId() {
        return this.oceanBlockId;
    }

    public int getFillerBlockId() {
        return this.fillerBlockId;
    }

    public int getDayNightCycleTicks() {
        return this.dayNightCycleTicks;
    }

    public boolean mayRespawn() {
        return this.mayRespawn;
    }

    public float getCloudHeight() {
        return this.cloudHeight;
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public boolean hasAurora() {
        return this.hasAurora;
    }

    public void onWorldCreation(World world) {
    }

    public final int getYRange() {
        return this.getMaxY() - this.getMinY();
    }

    public final double getYPercentage(int y) {
        int range = this.getYRange();
        return (double)(y -= this.getMinY()) / (double)range;
    }

    public abstract BiomeProvider createBiomeProvider(World var1);

    public abstract ChunkGenerator createChunkGenerator(World var1);

    public abstract boolean isValidSpawn(World var1, int var2, int var3, int var4);

    public void getInitialSpawnLocation(World world) {
        int x = 0;
        int y = 0;
        int z = 0;
        block0: while (true) {
            x += world.rand.nextInt(64) - world.rand.nextInt(64);
            z += world.rand.nextInt(64) - world.rand.nextInt(64);
            y = this.getMaxY();
            while (true) {
                if (y < this.getMinY()) continue block0;
                if (world.getBlockId(x, y + 1, z) == 0 && this.isValidSpawn(world, x, y, z)) break block0;
                --y;
            }
            break;
        }
        world.getLevelData().setSpawn(x, y, z);
    }

    public void getRespawnLocation(World world) {
        LevelData levelData = world.getLevelData();
        if (levelData.getSpawnY() <= 0) {
            levelData.setSpawnY(this.getOceanY());
        }
        int x = levelData.getSpawnX();
        int z = levelData.getSpawnZ();
        while (world.getTopBlock(x, z) == 0) {
            x += world.rand.nextInt(8) - world.rand.nextInt(8);
            z += world.rand.nextInt(8) - world.rand.nextInt(8);
        }
        levelData.setSpawnX(x);
        levelData.setSpawnZ(z);
    }

    protected int getDayLengthTicks(World world) {
        float dayLength;
        float seasonProgress = world.getSeasonManager().getSeasonProgress();
        if (seasonProgress < 0.5f) {
            float lastSeasonDayLength = world.getSeasonManager().getPreviousSeason().dayLength;
            float thisSeasonDayLength = world.getSeasonManager().getCurrentSeason().dayLength;
            float seasonModifier = world.getSeasonManager().getSeasonModifier() * 0.5f + 0.5f;
            dayLength = lastSeasonDayLength * (1.0f - seasonModifier) + thisSeasonDayLength * seasonModifier;
        } else {
            float thisSeasonDayLength = world.getSeasonManager().getCurrentSeason().dayLength;
            float nextSeasonDayLength = world.getSeasonManager().getNextSeason().dayLength;
            float seasonModifier = world.getSeasonManager().getSeasonModifier() * 0.5f + 0.5f;
            dayLength = thisSeasonDayLength * seasonModifier + nextSeasonDayLength * (1.0f - seasonModifier);
        }
        int cycleTicks = this.getDayNightCycleTicks();
        return (int)(dayLength * (float)cycleTicks);
    }

    public int getSunriseTick(World world) {
        int dayLengthTicks = this.getDayLengthTicks(world);
        int cycleTicks = this.getDayNightCycleTicks();
        return cycleTicks / 4 - dayLengthTicks / 2;
    }

    public float getTimeOfDay(World world, long tick, float partialTick) {
        float time;
        int cycleTicks = this.getDayNightCycleTicks();
        int dayTicks = this.getDayLengthTicks(world);
        int nightTicks = cycleTicks - dayTicks;
        for (time = (cycleTick = (float)((int)((tick += 18000L) % (long)cycleTicks)) + partialTick) < (float)dayTicks / 2.0f ? cycleTick / ((float)dayTicks / 2.0f) * 0.25f : (cycleTick < (float)dayTicks / 2.0f + (float)nightTicks / 2.0f ? 0.25f + (cycleTick - (float)dayTicks / 2.0f) / ((float)nightTicks / 2.0f) * 0.25f : (cycleTick < (float)dayTicks / 2.0f + (float)nightTicks / 2.0f + (float)nightTicks / 2.0f ? 0.5f + (cycleTick - (float)dayTicks / 2.0f - (float)nightTicks / 2.0f) / ((float)nightTicks / 2.0f) * 0.25f : 0.75f + (cycleTick - (float)dayTicks / 2.0f - (float)nightTicks / 2.0f - (float)nightTicks / 2.0f) / ((float)dayTicks / 2.0f) * 0.25f)); time < 0.0f; time += 1.0f) {
        }
        while (time >= 1.0f) {
            time -= 1.0f;
        }
        return time;
    }

    public abstract float getCelestialAngle(World var1, long var2, float var4);

    public abstract float[] getSunriseColor(float var1, float var2);

    public abstract int getSkyDarken(World var1, long var2, float var4);

    public abstract Vec3 getFogColor(World var1, double var2, double var4, double var6, float var8, float var9);

    public static class Properties {
        private final String languageKey;
        private Weather defaultWeather = null;
        private WindProvider windProvider = null;
        private boolean hasCeiling = false;
        private float[] brightnessRamp = null;
        private SeasonConfig seasonConfig = null;
        private boolean hasClouds = true;
        private boolean hasSky = true;
        private int minY = 0;
        private int maxY = 255;
        private int oceanY = 128;
        private Block oceanBlock = null;
        private Block fillerBlock = null;
        private int dayNightCycleTicks = 24000;
        private boolean mayRespawn = false;
        private Float cloudHeight = null;
        private boolean hasGround = true;
        private boolean hasAurora = false;

        private Properties(String languageKey) {
            this.languageKey = languageKey;
        }

        public static Properties of(String languageKey) {
            return new Properties(languageKey);
        }

        public Properties defaultWeather(Weather weather) {
            this.defaultWeather = weather;
            return this;
        }

        public Properties windManager(WindProvider windProvider) {
            this.windProvider = windProvider;
            return this;
        }

        public Properties withCeiling() {
            this.hasCeiling = true;
            return this;
        }

        public Properties brightnessRamp(float[] brightnessRamp) {
            this.brightnessRamp = brightnessRamp;
            return this;
        }

        public Properties seasonConfig(SeasonConfig seasonConfig) {
            this.seasonConfig = seasonConfig;
            return this;
        }

        public Properties noClouds() {
            this.hasClouds = false;
            return this;
        }

        public Properties noSky() {
            this.hasSky = false;
            return this;
        }

        public Properties bounds(int minY, int maxY, int oceanY) {
            if (minY < 0) {
                throw new IllegalArgumentException("minY cannot be negative");
            }
            if (maxY < 0) {
                throw new IllegalArgumentException("maxY cannot be negative");
            }
            if (maxY <= minY) {
                throw new IllegalArgumentException("maxY cannot be less than or equal to minY");
            }
            if (oceanY < 0) {
                throw new IllegalArgumentException("oceanY cannot be negative");
            }
            this.minY = minY;
            this.maxY = maxY;
            this.oceanY = oceanY;
            return this;
        }

        public Properties oceanBlock(Block oceanBlock) {
            this.oceanBlock = oceanBlock;
            return this;
        }

        public Properties fillerBlock(Block fillerBlock) {
            this.fillerBlock = fillerBlock;
            return this;
        }

        public Properties dayNightCycleTicks(int ticks) {
            this.dayNightCycleTicks = ticks;
            return this;
        }

        public Properties allowRespawn() {
            this.mayRespawn = true;
            return this;
        }

        public Properties cloudHeight(float cloudHeight) {
            this.cloudHeight = Float.valueOf(cloudHeight);
            return this;
        }

        public Properties noGround() {
            this.hasGround = false;
            return this;
        }

        public Properties withAurora() {
            this.hasAurora = true;
            return this;
        }
    }
}

