/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.nbt.CompoundTag;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.legacy.LegacyWorldTypes;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.IUpdatePlayerListBox;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PropertyManager;
import net.minecraft.core.net.ServerCommandEntry;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveConverters;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.SaveHandlerServer;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.entity.ServerSkinVariantList;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.gui.ServerGui;
import net.minecraft.server.net.ConsoleCommandHandler;
import net.minecraft.server.net.NetworkListenThread;
import net.minecraft.server.net.PlayerList;
import net.minecraft.server.net.thread.ThreadCommandReader;
import net.minecraft.server.net.thread.ThreadServerApplication;
import net.minecraft.server.net.thread.ThreadSleepForeverServer;
import net.minecraft.server.world.ConvertProgressUpdater;
import net.minecraft.server.world.WorldManager;
import net.minecraft.server.world.WorldServer;
import net.minecraft.server.world.WorldServerMulti;
import net.minecraft.server.world.chunk.provider.ChunkProviderServer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class MinecraftServer
implements Runnable,
ICommandListener,
MinecraftAccessor {
    public static Logger logger = Logger.getLogger("Minecraft");
    public static final String VERSION = Global.VERSION;
    private static MinecraftServer instance;
    public static HashMap field_6037_b;
    public NetworkListenThread networkServer;
    public PropertyManager propertyManager;
    public WorldServer[] dimensionWorlds;
    public PlayerList playerList;
    private ConsoleCommandHandler commandHandler;
    private boolean serverRunning;
    public boolean serverStopped;
    int deathTime;
    public String currentTask;
    public int percentDone;
    private final List field_9010_p;
    private final List<ServerCommandEntry> commands;
    public EntityTracker[] entityTracker;
    public boolean onlineMode;
    public boolean spawnPeacefulMobs;
    public boolean pvpOn;
    public boolean allowFlight;
    public int spawnProtectionRange;
    public WorldType defaultWorldType;
    public int difficulty;
    public final ServerCommandHandler serverCommandHandler = new ServerCommandHandler(this);
    public String joinMessage = null;
    public int summonLimit;
    public String language;
    public int sleepPercentage = 100;
    public int maxPlayers = 20;
    public Gamemode defaultGamemode;
    public static String statsToken;
    public static boolean statsStatus;
    public boolean disablePhotoMode = false;
    public String motd = "";
    private final SkinVariantList skinVariantList = new ServerSkinVariantList();
    public int autoSaveInterval = 5;
    public int chunksSavedPerAutosave = 24;
    public boolean forceSaveAllChunksOnAutosave = false;
    public SpawnerMobs.SpawnerConfig spawnerConfig = new SpawnerMobs.SpawnerConfig();

    public MinecraftServer() {
        Global.accessor = this;
        this.serverRunning = true;
        this.serverStopped = false;
        this.deathTime = 0;
        this.field_9010_p = new ArrayList();
        this.commands = Collections.synchronizedList(new ArrayList());
        new ThreadSleepForeverServer(this);
    }

    private boolean startServer() throws UnknownHostException {
        instance = this;
        Global.isServer = true;
        this.commandHandler = new ConsoleCommandHandler(this);
        ThreadCommandReader threadcommandreader = new ThreadCommandReader(this);
        threadcommandreader.setDaemon(true);
        threadcommandreader.start();
        logger.info("Starting Better than Adventure! server for version " + VERSION);
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            logger.warn("**** NOT ENOUGH RAM!");
            logger.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        logger.info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"));
        String s = this.propertyManager.getStringProperty("server-ip", "");
        this.onlineMode = this.propertyManager.getBooleanProperty("online-mode", true);
        this.spawnerConfig.setPassiveSpawning(this.propertyManager.getBooleanProperty("spawn-animals", true));
        this.spawnerConfig.setHostileSpawning(this.propertyManager.getBooleanProperty("spawn-monsters", true));
        this.pvpOn = this.propertyManager.getBooleanProperty("pvp", true);
        this.allowFlight = this.propertyManager.getBooleanProperty("allow-flight", false);
        statsToken = this.propertyManager.getStringProperty("stats-token", "only-enter-a-value-if-you-are-a-registered-server");
        this.defaultWorldType = Registries.WORLD_TYPES.getItem(this.propertyManager.getStringProperty("world-type", Registries.WORLD_TYPES.getKey(WorldTypes.OVERWORLD_EXTENDED)));
        this.spawnProtectionRange = this.propertyManager.getIntProperty("spawn-protection", 0);
        this.difficulty = this.propertyManager.getIntProperty("difficulty", 2);
        this.joinMessage = this.propertyManager.getStringProperty("join-message", "");
        this.summonLimit = this.propertyManager.getIntProperty("summon-limit", 10);
        this.sleepPercentage = this.propertyManager.getIntProperty("sleep-percentage", 0);
        NetworkManager.PACKET_DELAY = this.propertyManager.getIntProperty("packet-delay", 20);
        this.maxPlayers = this.propertyManager.getIntProperty("max-players", 20);
        this.language = this.propertyManager.getStringProperty("language", "en_US");
        this.disablePhotoMode = this.propertyManager.getBooleanProperty("disable-photomode", false);
        this.motd = this.propertyManager.getStringProperty("motd", "A Better than Adventure! Server");
        this.autoSaveInterval = this.propertyManager.getIntProperty("autosaveInterval", 5);
        this.chunksSavedPerAutosave = this.propertyManager.getIntProperty("maxChunksSavedPerAutosave", 24);
        this.forceSaveAllChunksOnAutosave = this.propertyManager.getBooleanProperty("forceSaveAllChunksOnAutosave", false);
        String gamemodeProperty = this.propertyManager.getStringProperty("default-gamemode", "survival");
        this.defaultGamemode = null;
        for (Gamemode gamemode : Gamemode.gamemodesList) {
            if (!gamemode.getLanguageKey().replace("gamemode.", "").equals(gamemodeProperty)) continue;
            this.defaultGamemode = gamemode;
            break;
        }
        if (this.defaultGamemode == null) {
            try {
                this.defaultGamemode = Gamemode.gamemodesList[Integer.parseInt(gamemodeProperty)];
            }
            catch (Exception e) {
                this.defaultGamemode = Gamemode.survival;
            }
        }
        if (this.defaultWorldType == null) {
            WorldType legacyWorldType;
            String worldTypeString = this.propertyManager.getStringProperty("world-type", null);
            if (worldTypeString == null) {
                this.defaultWorldType = WorldTypes.OVERWORLD_EXTENDED;
            }
            if ((legacyWorldType = LegacyWorldTypes.getWorldTypeByKey(worldTypeString)) != null) {
                this.defaultWorldType = legacyWorldType;
                this.propertyManager.setProperty("world-type", Registries.WORLD_TYPES.getKey(this.defaultWorldType));
                this.propertyManager.saveProperties();
            } else {
                this.defaultWorldType = WorldTypes.OVERWORLD_EXTENDED;
            }
        }
        Blocks.init();
        Items.init();
        Dimension.init();
        this.entityTracker = new EntityTracker[Dimension.getDimensionList().size()];
        new Registries();
        BiomeProviderOverworld.init();
        DataLoader.loadRecipesFromFile("/recipes/blast_furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/trommel.json");
        DataLoader.loadRecipesFromFile("/recipes/workbench.json");
        DataLoader.loadDataPacks(this);
        int recipes = Registries.RECIPES.getAllRecipes().size();
        int groups = Registries.RECIPES.getAllGroups().size();
        int namespaces = Registries.RECIPES.size();
        int itemGroups = Registries.ITEM_GROUPS.size();
        System.out.printf("%d item groups.%n", itemGroups);
        System.out.printf("%d recipes in %d groups in %d namespaces.%n", recipes, groups, namespaces);
        SoundTypes.registerSounds();
        I18n.initialize(this.language);
        StatList.init();
        if (!statsToken.equals("only-enter-a-value-if-you-are-a-registered-server") && !statsToken.equals("")) {
            statsStatus = true;
            int errorCode = RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + statsToken + "&count=0");
            switch (errorCode) {
                case 401: {
                    logger.warn("Your server stats token is invalid. Please clear server.properties -> stats-token");
                    statsStatus = false;
                    break;
                }
                case 503: {
                    logger.warn("Cannot access server stats API! Your server might be offline.");
                    statsStatus = false;
                }
            }
        }
        InetAddress inetaddress = null;
        if (s.length() > 0) {
            inetaddress = InetAddress.getByName(s);
        }
        int i = this.propertyManager.getIntProperty("server-port", 25565);
        logger.info("Starting Minecraft server on " + (s.length() != 0 ? s : "*") + ":" + i);
        try {
            this.networkServer = new NetworkListenThread(this, inetaddress, i);
        }
        catch (IOException ioexception) {
            logger.warn("**** FAILED TO BIND TO PORT!");
            logger.warn("The exception was: " + ioexception);
            logger.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            logger.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            logger.warn("The server will make no attempt to authenticate usernames. Beware.");
            logger.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            logger.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        this.playerList = new PlayerList(this);
        for (int q = 0; q < Dimension.getDimensionList().size(); ++q) {
            this.entityTracker[q] = new EntityTracker(this, q);
        }
        long l = System.nanoTime();
        String s1 = this.propertyManager.getStringProperty("level-name", "world");
        String s2 = this.propertyManager.getStringProperty("level-seed", "");
        long l1 = new Random().nextLong();
        if (s2.length() > 0) {
            try {
                l1 = Long.parseLong(s2);
            }
            catch (NumberFormatException numberformatexception) {
                l1 = s2.hashCode();
            }
        }
        logger.info("Preparing level \"" + s1 + "\"");
        this.initWorld(new SaveFormat19134(new File(".")), s1, l1);
        logger.info("Generating RSA key...");
        try {
            RSA.RSAKeyChain = RSA.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("Done (" + (System.nanoTime() - l) + "ns)! For help, type \"help\" or \"?\"");
        return true;
    }

    private void convertWorld(ISaveFormat saveFormat, String worldDirName) {
        int worldSaveVersion = 0;
        try {
            LevelData info = new LevelData(new File(worldDirName));
            worldSaveVersion = info.getSaveVersion();
        }
        catch (IOException e) {
            worldSaveVersion = saveFormat.getSaveVersion();
        }
        if (worldSaveVersion < 19134) {
            this.doWorldConversion(worldSaveVersion, worldDirName);
        }
    }

    private void doWorldConversion(int fromVersion, String worldDirName) {
        ConvertProgressUpdater updater = new ConvertProgressUpdater();
        ISaveFormat fromWorldFormat = SaveFormats.createSaveFormat(fromVersion, new File("."));
        if (fromWorldFormat != null) {
            ISaveFormat toWorldFormat;
            ISaveConverter converterToUse = null;
            for (ISaveConverter converter : SaveConverters.saveConverters) {
                if (converter.fromVersion() != fromVersion || converterToUse != null && converter.toVersion() <= converterToUse.toVersion()) continue;
                converterToUse = converter;
            }
            if (converterToUse != null && (toWorldFormat = SaveFormats.createSaveFormat(converterToUse.toVersion(), new File("."))) != null) {
                CompoundTag levelDataTag = toWorldFormat.getLevelDataRaw(worldDirName);
                converterToUse.convertSave(levelDataTag, new File("."), worldDirName, updater);
                levelDataTag.putInt("version", toWorldFormat.getSaveVersion());
                LevelStorage saveHandler = toWorldFormat.getSaveHandler(worldDirName, false);
                saveHandler.saveLevelDataRaw(levelDataTag);
            }
        }
    }

    private void initWorld(ISaveFormat saveFormat, String worldDirName, long l) {
        this.convertWorld(saveFormat, worldDirName);
        this.dimensionWorlds = new WorldServer[Dimension.getDimensionList().size()];
        SaveHandlerServer saveHandler = new SaveHandlerServer(saveFormat, new File("."), worldDirName, true);
        for (int i = 0; i < this.dimensionWorlds.length; ++i) {
            this.dimensionWorlds[i] = i == 0 ? new WorldServer(this, saveHandler, worldDirName, i, this.defaultWorldType, l, this.spawnerConfig) : new WorldServerMulti(this, saveHandler, worldDirName, i, Dimension.getDimensionList().get((Object)Integer.valueOf((int)i)).defaultWorldType, l, this.dimensionWorlds[0], this.spawnerConfig);
            this.dimensionWorlds[i].addListener(new WorldManager(this, this.dimensionWorlds[i]));
            this.dimensionWorlds[i].difficultySetting = this.difficulty;
            this.dimensionWorlds[i].sleepPercent = this.sleepPercentage;
            this.playerList.setPlayerManager(this.dimensionWorlds);
        }
        int c = 196;
        long l1 = System.currentTimeMillis();
        for (int j = 0; j < this.dimensionWorlds.length; ++j) {
            logger.info("Preparing start region for level " + j);
            if (j == Dimension.nether.id && !this.propertyManager.getBooleanProperty("allow-nether", true) || j == Dimension.paradise.id && !this.propertyManager.getBooleanProperty("allow-paradise", false)) continue;
            WorldServer worldserver = this.dimensionWorlds[j];
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            for (int k = -c; k <= c && this.serverRunning; k += 16) {
                for (int i1 = -c; i1 <= c && this.serverRunning; i1 += 16) {
                    long l2 = System.currentTimeMillis();
                    if (l2 < l1) {
                        l1 = l2;
                    }
                    if (l2 > l1 + 1000L) {
                        int j1 = (c * 2 + 1) * (c * 2 + 1);
                        int k1 = (k + c) * (c * 2 + 1) + (i1 + 1);
                        this.outputPercentRemaining("Preparing spawn area", k1 * 100 / j1);
                        l1 = l2;
                    }
                    worldserver.chunkProviderServer.prepareChunk(chunkcoordinates.x + k >> 4, chunkcoordinates.z + i1 >> 4);
                    while (worldserver.updatingLighting() && this.serverRunning) {
                    }
                }
            }
        }
        this.clearCurrentTask();
    }

    private void outputPercentRemaining(String s, int i) {
        this.currentTask = s;
        this.percentDone = i;
        logger.info(s + ": " + i + "%");
    }

    private void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    private void saveServerWorld() {
        logger.info("Saving chunks");
        for (int i = 0; i < this.dimensionWorlds.length; ++i) {
            WorldServer worldserver = this.dimensionWorlds[i];
            worldserver.saveWorld(true, null, i == 0);
            worldserver.func_30006_w();
        }
    }

    private void stopServer() {
        logger.info("Stopping server");
        if (statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + statsToken + "&count=0");
        }
        this.propertyManager.setProperty("difficulty", this.difficulty);
        this.propertyManager.saveProperties();
        if (this.playerList != null) {
            this.playerList.savePlayerStates();
        }
        this.saveServerWorld();
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.startServer()) {
                long startTime = System.currentTimeMillis();
                long timeSinceLastTick = 0L;
                int i = 0;
                while (this.serverRunning) {
                    long currentTime = System.currentTimeMillis();
                    long timeChange = currentTime - startTime;
                    if (timeChange > 2000L) {
                        logger.warn("Can't keep up! Did the system time change, or is the server overloaded?");
                        timeChange = 2000L;
                    }
                    if (timeChange < 0L) {
                        logger.warn("Time ran backwards! Did the system time change?");
                        timeChange = 0L;
                    }
                    timeSinceLastTick += timeChange;
                    startTime = currentTime;
                    if (this.dimensionWorlds[0].areEnoughPlayersFullyAsleep()) {
                        this.doTick();
                        timeSinceLastTick = 0L;
                    } else {
                        while (timeSinceLastTick > 10L) {
                            timeSinceLastTick -= 10L;
                            ++i;
                            for (ServerPlayer player : this.playerList.playerEntities) {
                                player.tickSendChunks();
                            }
                            if (i % 5 != 0) continue;
                            this.doTick();
                            i = 0;
                        }
                    }
                    Thread.sleep(1L);
                }
                return;
            } else {
                while (this.serverRunning) {
                    this.commandLineParser();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedexception) {
                        interruptedexception.printStackTrace();
                    }
                }
            }
            return;
        }
        catch (Throwable throwable1) {
            throwable1.printStackTrace();
            logger.error("Unexpected exception", throwable1);
            while (this.serverRunning) {
                this.commandLineParser();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedexception1) {
                    interruptedexception1.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                this.stopServer();
                this.serverStopped = true;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void doTick() {
        int i;
        ArrayList<String> arraylist = new ArrayList<String>();
        for (String s : field_6037_b.keySet()) {
            int i1 = (Integer)field_6037_b.get(s);
            if (i1 > 0) {
                field_6037_b.put(s, i1 - 1);
                continue;
            }
            arraylist.add(s);
        }
        for (i = 0; i < arraylist.size(); ++i) {
            field_6037_b.remove(arraylist.get(i));
        }
        AABB.initializePool();
        Vec3.initializePool();
        ++this.deathTime;
        for (i = 0; i < this.dimensionWorlds.length; ++i) {
            if (i == Dimension.nether.id && !this.propertyManager.getBooleanProperty("allow-nether", true) || i == Dimension.paradise.id && !this.propertyManager.getBooleanProperty("allow-paradise", false)) continue;
            WorldServer worldserver = this.dimensionWorlds[i];
            if (this.deathTime % 20 == 0) {
                this.playerList.sendPacketToAllPlayersInDimension(new SetTimePacket(worldserver.getWorldTime()), worldserver.dimension.id);
            }
            worldserver.tick();
            while (worldserver.updatingLighting()) {
            }
            worldserver.updateEntities();
        }
        this.networkServer.handleNetworkListenThread();
        this.playerList.onTick();
        for (int k = 0; k < this.entityTracker.length; ++k) {
            this.entityTracker[k].tick();
        }
        for (int l = 0; l < this.field_9010_p.size(); ++l) {
            ((IUpdatePlayerListBox)this.field_9010_p.get(l)).update();
        }
        try {
            this.commandLineParser();
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while parsing console command", exception);
        }
    }

    public void addCommand(String s, ICommandListener icommandlistener) {
        this.commands.add(new ServerCommandEntry(s, icommandlistener));
    }

    public void commandLineParser() {
        while (this.commands.size() > 0) {
            ServerCommandEntry servercommand = this.commands.remove(0);
            this.commandHandler.handleCommand(servercommand);
        }
    }

    public void func_6022_a(IUpdatePlayerListBox iupdateplayerlistbox) {
        this.field_9010_p.add(iupdateplayerlistbox);
    }

    public static void main(String[] args) {
        try {
            File log4jConf = new File("log4j.properties");
            if (!log4jConf.exists()) {
                log4jConf.createNewFile();
                String contents = "log4j.appender.file=org.apache.log4j.rolling.RollingFileAppender\nlog4j.appender.file.layout=org.apache.log4j.PatternLayout\nlog4j.appender.file.layout.ConversionPattern=%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1} - %m%n\nlog4j.appender.file.rollingPolicy=org.apache.log4j.rolling.TimeBasedRollingPolicy\nlog4j.appender.file.rollingPolicy.FileNamePattern=./logs/%d{yyyy-MM-dd}.log\nlog4j.appender.file.rollingPolicy.ActiveFileName=./logs/latest.log\n\nlog4j.appender.stdout=org.apache.log4j.ConsoleAppender\nlog4j.appender.stdout.Target=System.out\nlog4j.appender.stdout.layout=org.apache.log4j.PatternLayout\nlog4j.appender.stdout.layout.ConversionPattern=%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1} - %m%n\n\nlog4j.logger.Minecraft=DEBUG, file, stdout\n";
                OutputStream out = Files.newOutputStream(Paths.get("log4j.properties", new String[0]), new OpenOption[0]);
                out.write(contents.getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PropertyConfigurator.configure("log4j.properties");
        try {
            MinecraftServer minecraftserver = new MinecraftServer();
            if (!(GraphicsEnvironment.isHeadless() || args.length > 0 && args[0].equals("nogui"))) {
                ServerGui.initGui(minecraftserver);
            }
            new ThreadServerApplication("Server thread", minecraftserver).start();
        }
        catch (Exception exception) {
            logger.error("Failed to start the minecraft server", exception);
        }
    }

    public File getFile(String s) {
        return new File(s);
    }

    @Override
    public File getMinecraftDir() {
        return new File(".");
    }

    @Override
    public String getMinecraftVersion() {
        return VERSION;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return new ChunkProviderServer((WorldServer)world, chunkLoader, world.worldType.createChunkGenerator(world));
    }

    @Override
    public void log(String s) {
        logger.info(s);
    }

    public void logWarning(String s) {
        logger.warn(s);
    }

    @Override
    public String getUsername() {
        return "CONSOLE";
    }

    public WorldServer getDimensionWorld(int dim) {
        return this.dimensionWorlds[dim];
    }

    public EntityTracker getEntityTracker(int i) {
        return this.entityTracker[i];
    }

    public static boolean isServerRunning(MinecraftServer minecraftserver) {
        return minecraftserver.serverRunning;
    }

    public static MinecraftServer getInstance() {
        return instance;
    }

    @Override
    public int getAutosaveTimer() {
        return this.autoSaveInterval;
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return this.skinVariantList;
    }

    static {
        field_6037_b = new HashMap();
    }
}

