/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.ByteArrayTag;
import com.mojang.nbt.ByteTag;
import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.DoubleArrayTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.EndTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.IntTag;
import com.mojang.nbt.ListTag;
import com.mojang.nbt.LongTag;
import com.mojang.nbt.ShortArrayTag;
import com.mojang.nbt.ShortTag;
import com.mojang.nbt.StringTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public abstract class Tag<T> {
    private String name = null;
    private T value;

    public Tag() {
    }

    public Tag(T value) {
        this.value = value;
    }

    abstract void read(DataInput var1) throws IOException;

    abstract void write(DataOutput var1) throws IOException;

    public abstract byte getId();

    public String getTagName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public Tag<T> setName(String key) {
        this.name = key;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public Tag<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public static Tag<?> readNamedTag(DataInput dis) throws IOException {
        byte typeId = dis.readByte();
        if (typeId == 0) {
            return new EndTag();
        }
        Tag<?> tag = Tag.newTag(typeId);
        tag.name = dis.readUTF();
        tag.read(dis);
        return tag;
    }

    public static void writeNamedTag(Tag<?> tag, DataOutput dos) throws IOException {
        dos.writeByte(tag.getId());
        if (tag.getId() != 0) {
            dos.writeUTF(tag.getTagName());
            tag.write(dos);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)obj;
        return Objects.equals(this.getValue(), tag.getValue());
    }

    public static Tag<?> createTagOfType(Class<?> type) {
        if (type == Byte.class) {
            return new ByteTag();
        }
        if (type == Short.class) {
            return new ShortTag();
        }
        if (type == Integer.class) {
            return new IntTag();
        }
        if (type == Long.class) {
            return new LongTag();
        }
        if (type == Float.class) {
            return new FloatTag();
        }
        if (type == Double.class) {
            return new DoubleTag();
        }
        if (type == String.class) {
            return new StringTag();
        }
        return null;
    }

    public static Tag<?> newTag(byte type) throws IOException {
        switch (type) {
            case 0: {
                return new EndTag();
            }
            case 1: {
                return new ByteTag();
            }
            case 2: {
                return new ShortTag();
            }
            case 3: {
                return new IntTag();
            }
            case 4: {
                return new LongTag();
            }
            case 5: {
                return new FloatTag();
            }
            case 6: {
                return new DoubleTag();
            }
            case 7: {
                return new ByteArrayTag();
            }
            case 8: {
                return new StringTag();
            }
            case 9: {
                return new ListTag();
            }
            case 10: {
                return new CompoundTag();
            }
            case 11: {
                return new ShortArrayTag();
            }
            case 12: {
                return new DoubleArrayTag();
            }
        }
        throw new IOException("Cannot read NBT Tag type for type '" + type + "'!");
    }

    public static String getTagName(byte type) {
        switch (type) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
            case 11: {
                return "TAG_Short_Array";
            }
            case 12: {
                return "TAG_Double_Array";
            }
        }
        return "UNKNOWN";
    }
}

