/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends GuiButton {
    public float sliderValue;
    public boolean dragging = false;
    private FloatOption option;

    public GuiSlider(int id, int xPosition, int yPosition, FloatOption floatOption) {
        this(id, xPosition, yPosition, 150, 20, floatOption);
    }

    public GuiSlider(int id, int xPosition, int yPosition, int width, int height, FloatOption floatOption) {
        super(id, xPosition, yPosition, width, height, floatOption.getDisplayStringValue());
        this.option = floatOption;
        this.sliderValue = ((Float)floatOption.value).floatValue();
    }

    public GuiSlider(int id, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id, xPosition, yPosition, width, height, text);
        this.option = null;
        this.sliderValue = defaultValue;
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.option != null) {
                this.option.set(Float.valueOf(this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
        }
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        IconCoordinate tex;
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.fontRenderer;
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (state) {
            case 0: {
                tex = this.disabledTexture;
                break;
            }
            case 2: {
                tex = this.hoveredTexture;
                break;
            }
            default: {
                tex = this.defaultTexture;
            }
        }
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, this.disabledTexture);
        this.drawGuiIcon(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)), this.yPosition, 8, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        this.drawStringCentered(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        if (super.mouseClicked(mc, mouseX, mouseY)) {
            this.sliderValue = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.option != null) {
                this.option.set(Float.valueOf(this.sliderValue));
                this.displayString = this.option.getDisplayString();
            }
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

