/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerButton;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerTextField;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Utils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import paulscode.sound.SoundSystem;

public class GuiSoundTest
extends GuiScreen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    protected int top;
    protected int bottom;
    protected Field[] repoFields;
    protected SoundRepository[] repos;
    protected int repoIndex;
    protected SoundRepository currentRepo;
    protected int entryIndex = 0;
    @Nullable
    protected SoundEntry currentEntry;
    protected GuiListenerButton leftEntry;
    protected GuiListenerButton leftRepo;
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected boolean showURL = true;

    public GuiSoundTest(GuiScreen parent) {
        super(parent);
        this.initRepos();
    }

    public void initRepos() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : SoundEngine.class.getFields()) {
            if (!f.getType().isAssignableFrom(SoundRepository.class)) continue;
            fields.add(f);
        }
        this.repoFields = new Field[fields.size()];
        this.repos = new SoundRepository[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            this.repoFields[i] = (Field)fields.get(i);
            try {
                this.repos[i] = (SoundRepository)((Field)fields.get(i)).get(Minecraft.getMinecraft((Object)this).sndManager);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.currentRepo = this.repos[0];
        this.currentEntry = this.currentRepo.getAllEntries().get(0);
        this.entryIndex = 0;
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == Keyboard.KEY_ESCAPE) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        ArrayList _buttons = new ArrayList(this.controlList);
        for (GuiButton button : _buttons) {
            if (!(button instanceof IListenerElement) || !button.isHovered(mouseX, mouseY)) continue;
            ((IListenerElement)((Object)button)).onKeyTyped(c, key);
        }
    }

    @Override
    public void tick() {
        ArrayList _buttons = new ArrayList(this.controlList);
        for (GuiButton button : _buttons) {
            if (!(button instanceof GuiListenerButton)) continue;
            ((GuiListenerButton)button).tick();
        }
    }

    @Override
    public void init() {
        this.top = 24;
        this.bottom = this.height - 28;
        this.add(new GuiListenerButton(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.sound_test.button.done")).setActionListener(() -> {
            this.onClosed();
            this.mc.displayGuiScreen(null);
        }));
        this.leftRepo = this.add(new GuiListenerButton(1, this.width - 48, this.bottom - 24, 20, 20, "<").setActionListener(() -> this.cycleRepo(-1)));
        this.add(new GuiListenerButton(2, this.width - 24, this.bottom - 24, 20, 20, ">").setActionListener(() -> this.cycleRepo(1)));
        this.leftEntry = this.add(new GuiListenerButton(11, this.width - 48, this.bottom - 48, 20, 20, "<").setActionListener(() -> this.cycleEntry(-1)));
        this.add(new GuiListenerButton(12, this.width - 24, this.bottom - 48, 20, 20, ">").setActionListener(() -> this.cycleEntry(1)));
        this.add(new GuiListenerButton(20, this.width / 2 - 100, this.bottom - 24, 98, 20, I18n.getInstance().translateKey("gui.sound_test.button.play")).setActionListener(() -> this.playEntry(false)));
        this.add(new GuiListenerButton(21, this.width / 2 + 100 - 98, this.bottom - 24, 98, 20, I18n.getInstance().translateKey("gui.sound_test.button.play_stream")).setActionListener(() -> this.playEntry(true)));
        this.add(new GuiListenerButton(22, this.width / 2 + 100 + 4, this.bottom - 24, 20, 20, "X").setActionListener(this::stopSound));
        this.add(new GuiListenerButton(30, 4, this.bottom - 24, 20, 20, "").setActionListener(() -> Utils.openDirectory(new File(this.mc.getMinecraftDir(), "resources"))).setTextures("minecraft:gui/misc/button_folder", "minecraft:gui/misc/button_folder_highlighted", "minecraft:gui/misc/button_folder"));
        this.add(new GuiListenerButton(31, 28, this.bottom - 24, 20, 20, "V")).setActionListener(() -> {
            this.showURL = !this.showURL;
        });
        this.add(new GuiListenerButton(32, 52, this.bottom - 24, 40, 20, I18n.getInstance().translateKey("gui.sound_test.button.reload"))).setActionListener(() -> {
            this.mc.sndManager = new SoundEngine();
            this.mc.sndManager.init(this.mc.gameSettings);
            this.mc.downloadResourcesThread.reloadResources();
            this.initRepos();
        });
        GuiListenerTextField volumeField = new GuiListenerTextField(this.parentScreen, this.mc.fontRenderer, this.width - 4 - 60, this.bottom - 72, 60, 20, String.valueOf(this.volume), "Volume");
        this.add(volumeField).setPrefaceText("Vol: ").setKeyListener(key -> {
            try {
                this.volume = Float.parseFloat(volumeField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).setActionListener(() -> {
            if (Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL)) {
                volumeField.setText(String.valueOf(1));
                this.volume = 1.0f;
            }
        });
        GuiListenerTextField pitchField = new GuiListenerTextField(this.parentScreen, this.mc.fontRenderer, this.width - 4 - 60, this.bottom - 96, 60, 20, String.valueOf(this.pitch), "Pitch");
        this.add(pitchField).setPrefaceText("Pitch: ").setKeyListener(key -> {
            try {
                this.pitch = Float.parseFloat(pitchField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).setActionListener(() -> {
            if (Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL)) {
                pitchField.setText(String.valueOf(1));
                this.pitch = 1.0f;
            }
        });
    }

    @Override
    protected void buttonPressed(GuiButton button) {
    }

    @Override
    protected void buttonReleased(GuiButton button) {
    }

    protected void cycleRepo(int offset) {
        int index = (this.repoIndex + offset + this.repos.length) % this.repos.length;
        this.currentRepo = this.repos[index];
        this.repoIndex = index;
        try {
            this.currentEntry = this.currentRepo.getAllEntries().get(0);
            this.entryIndex = 0;
        }
        catch (Exception e) {
            this.currentEntry = null;
            this.entryIndex = -1;
        }
    }

    protected void cycleEntry(int offset) {
        if (this.currentRepo.getAllEntries().size() <= 0) {
            return;
        }
        int index = (this.entryIndex + offset + this.currentRepo.getAllEntries().size()) % this.currentRepo.getAllEntries().size();
        this.currentEntry = this.currentRepo.getAllEntries().get(index);
        this.entryIndex = index;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTick);
        this.fontRenderer.drawCenteredString(I18n.getInstance().translateKey("gui.sound_test.label.title"), this.width / 2, 5, 0xFFFFFF);
        this.fontRenderer.drawCenteredString(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.repo", this.repoFields[this.repoIndex].getName()), this.width / 2, this.top + 10, 0xFFFFFF);
        String msg = I18n.getInstance().translateKey("gui.sound_test.label.select_repo");
        this.fontRenderer.drawString(msg, this.leftRepo.getX() - 4 - this.fontRenderer.getStringWidth(msg), this.leftRepo.getY() + 6, 0xFFFFFF);
        msg = I18n.getInstance().translateKey("gui.sound_test.label.select_entry");
        this.fontRenderer.drawString(msg, this.leftEntry.getX() - 4 - this.fontRenderer.getStringWidth(msg), this.leftEntry.getY() + 6, 0xFFFFFF);
        StringBuilder builder = new StringBuilder();
        builder.append(this.fontRenderer.wrapFormattedStringToWidth(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.id", this.currentEntry == null ? null : this.currentEntry.soundID), this.width - 10)).append("\n");
        builder.append(this.fontRenderer.wrapFormattedStringToWidth(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.name", this.currentEntry == null ? null : this.currentEntry.name), this.width - 10)).append("\n");
        builder.append(this.fontRenderer.wrapFormattedStringToWidth(I18n.getInstance().translateKeyAndFormat("gui.sound_test.label.url", String.valueOf(this.currentEntry == null ? null : (this.showURL ? this.currentEntry.url : "REDACTED"))), this.width - 10)).append("\n");
        String[] lines = builder.toString().split("\n");
        int y = this.top + 30;
        for (String line : lines) {
            this.fontRenderer.drawString(line, 5, y, 0xBBBBBB);
            y += 10;
        }
    }

    @Override
    public void drawDefaultBackground() {
        super.drawDefaultBackground();
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.renderEngine.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)this.bottom / scale);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)this.top / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)this.top / scale);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
        }
    }

    public void playEntry(boolean asStream) {
        if (this.currentEntry == null) {
            return;
        }
        if (asStream) {
            float streamingVolume = 16.0f;
            SoundSystem soundSystem = SoundEngine.getSoundSystem();
            soundSystem.newStreamingSource(true, "debug", this.currentEntry.url, this.currentEntry.name, false, 0.0f, 0.0f, 0.0f, 2, 64.0f);
            soundSystem.setVolume("debug", this.volume * ((Float)this.mc.gameSettings.masterVolume.value).floatValue());
            soundSystem.play("debug");
        } else {
            this.mc.sndManager.playSoundEntry(this.currentEntry, "debug", SoundCategory.GUI_SOUNDS, this.volume, this.pitch);
        }
    }

    public void stopSound() {
        SoundEngine.getSoundSystem().stop("debug");
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            this.mc.renderEngine.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
            tessellator.draw();
        }
    }
}

